/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.block.crops.MartianFlowerBlock;
import com.lightning.northstar.block.crops.MartianTallFlowerBlock;
import com.lightning.northstar.block.simple.MarsRootBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MarsMothEntity
extends Monster
implements GeoAnimatable {
    private static final EntityDataAccessor<Byte> RESTING = SynchedEntityData.defineId(MarsMothEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> FLYING = SynchedEntityData.defineId(MarsMothEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final TargetingConditions BAT_RESTING_TARGETING = TargetingConditions.forNonCombat().range(4.0);
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    private BlockPos targetPosition;
    private int pollinationTimer = 0;
    private int timeForPollination = 400;
    private int timeForPathFinding = 400;
    private boolean pollinating = false;
    boolean floorOrCeiling;

    public MarsMothEntity(EntityType<? extends MarsMothEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.tickCount;
    }

    private PlayState predicate(AnimationState<MarsMothEntity> event) {
        boolean resting = this.isResting();
        if (!resting && this.isFlying()) {
            event.getController().setAnimationSpeed(2.0).setAnimation(RawAnimation.begin().thenLoop("fly"));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed((double)event.getLimbSwingAmount()).setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else if (resting) {
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().thenLoop("sleep"));
        } else {
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RESTING, (Object)0);
        builder.define(FLYING, (Object)1);
    }

    protected SoundEvent getAmbientSound() {
        if (this.isResting()) {
            return (SoundEvent)NorthstarSounds.MARS_MOTH_SNORE.get();
        }
        if (this.random.nextInt(9) == 0) {
            return (SoundEvent)NorthstarSounds.MARS_MOTH_IDLE.get();
        }
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return (SoundEvent)NorthstarSounds.MARS_MOTH_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)NorthstarSounds.MARS_MOTH_DEATH.get();
    }

    public void handleEntityEvent(byte pId) {
        super.handleEntityEvent(pId);
    }

    public static boolean mothSpawnRules(EntityType<MarsMothEntity> moth, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        int surfaceY = level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ());
        BlockState state = level.getBlockState(pos.below());
        if (pos.getY() >= surfaceY) {
            return false;
        }
        if (pos.getY() < surfaceY / 2) {
            int light = level.getMaxLocalRawBrightness(pos);
            return light != 0 ? false : MarsMothEntity.checkMobSpawnRules(moth, (LevelAccessor)level, (MobSpawnType)spawntype, (BlockPos)pos, (RandomSource)rando) && state.is(NorthstarTags.NorthstarBlockTags.NATURAL_MARS_BLOCKS.tag);
        }
        return false;
    }

    public void tick() {
        super.tick();
        if (this.pollinationTimer > 0) {
            this.pollinationTimer = Mth.clamp((int)this.pollinationTimer, (int)0, (int)(this.pollinationTimer - 1));
        }
        if (this.isResting()) {
            this.setDeltaMovement(Vec3.ZERO);
            this.setPosRaw(this.getX(), (double)Mth.floor((double)this.getY()) + 1.0 - (double)this.getBbHeight(), this.getZ());
        } else if (this.isFlying()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
        }
    }

    protected void usePlayerItem(Player player, InteractionHand hand, ItemStack stack) {
        if (this.isFood(stack)) {
            this.playSound(SoundEvents.CAT_EAT, 1.0f, 1.0f);
            this.targetPosition = this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, this.blockPosition());
            this.setFlying(true);
        }
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(((MarsRootBlock)((Object)NorthstarBlocks.GLOWING_MARS_ROOTS.get())).asItem());
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        BlockPos blockpos = this.blockPosition();
        BlockPos blockpos1 = blockpos.above();
        if (this.isResting()) {
            boolean flag = this.isSilent();
            if (this.level().getBlockState(blockpos1).isRedstoneConductor((BlockGetter)this.level(), blockpos)) {
                if (this.random.nextInt(200) == 0) {
                    this.yHeadRot = this.random.nextInt(360);
                }
                if (this.level().getNearestPlayer(BAT_RESTING_TARGETING, (LivingEntity)this) != null) {
                    this.setResting(false);
                    if (!flag) {
                        this.level().levelEvent(null, 1025, blockpos, 0);
                    }
                }
            } else {
                this.setResting(false);
                if (!flag) {
                    this.level().levelEvent(null, 1025, blockpos, 0);
                }
            }
        } else if (this.isFlying()) {
            this.fallDistance = 0.0f;
            if (!(this.targetPosition == null || this.level().isEmptyBlock(this.targetPosition) && this.targetPosition.getY() > this.level().getMinBuildHeight())) {
                this.targetPosition = null;
            }
            if (this.timeForPathFinding > 0) {
                this.timeForPathFinding = Mth.clamp((int)this.timeForPathFinding, (int)0, (int)(this.timeForPathFinding - 1));
            } else {
                this.targetPosition = null;
                this.timeForPathFinding = 400;
            }
            if (this.pollinationTimer <= 0 && this.targetPosition == null) {
                this.targetPosition = this.searchForFlower();
            }
            if (this.targetPosition == null || this.random.nextInt(30) == 0 || this.targetPosition.closerToCenterThan((Position)this.position(), 2.0) && !this.pollinating) {
                this.targetPosition = new BlockPos(this.getBlockX() + this.random.nextInt(16) - this.random.nextInt(16), this.getBlockY() + this.random.nextInt(16) - this.random.nextInt(16), this.getBlockZ() + this.random.nextInt(16) - this.random.nextInt(16));
            }
            if (this.timeForPollination > 0) {
                --this.timeForPollination;
            } else {
                this.pollinating = false;
            }
            if (this.pollinating && this.targetPosition.closerToCenterThan((Position)this.position(), 0.5)) {
                this.pollinating = false;
                this.pollinationTimer = 6000;
                if (this.level().getBlockState(this.targetPosition).getBlock() instanceof MartianFlowerBlock) {
                    item = ((MartianFlowerBlock)this.level().getBlockState(this.targetPosition).getBlock()).getSeedItem();
                    ItemEntity spawnedItem = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)item, 1));
                    this.level().addFreshEntity((Entity)spawnedItem);
                } else if (this.level().getBlockState(this.targetPosition).getBlock() instanceof MartianTallFlowerBlock) {
                    item = (Item)NorthstarItems.MARS_SPROUT_SEEDS.get();
                    ItemEntity spawnedItem = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)item, 1));
                    this.level().addFreshEntity((Entity)spawnedItem);
                }
                this.targetPosition = null;
            }
            if (this.targetPosition != null) {
                double tX = (double)this.targetPosition.getX() + 0.5 - this.getX();
                double tY = (double)this.targetPosition.getY() + 0.1 - this.getY();
                double tZ = (double)this.targetPosition.getZ() + 0.5 - this.getZ();
                Vec3 vec3 = this.getDeltaMovement();
                Vec3 vec31 = vec3.add((Math.signum(tX) * 0.5 - vec3.x) * (double)0.1f, (Math.signum(tY) * (double)0.7f - vec3.y) * (double)0.1f, (Math.signum(tZ) * 0.5 - vec3.z) * (double)0.1f);
                this.setDeltaMovement(vec31);
                float f = (float)(Mth.atan2((double)vec31.z, (double)vec31.x) * 57.2957763671875) - 90.0f;
                float f1 = Mth.wrapDegrees((float)(f - this.getYRot()));
                this.zza = 0.5f;
                this.setYRot(this.getYRot() + f1);
                if (this.random.nextInt(100) == 0 && this.level().getBlockState(blockpos1).isRedstoneConductor((BlockGetter)this.level(), blockpos1) && !this.pollinating) {
                    this.setResting(true);
                } else if (this.random.nextInt(300) == 0 && this.level().getBlockState(blockpos.below()).isRedstoneConductor((BlockGetter)this.level(), blockpos.below()) && !this.pollinating) {
                    this.setFlying(false);
                }
            }
        } else if (this.random.nextInt(500) == 0) {
            this.setFlying(true);
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("flying", this.isFlying());
        pCompound.putBoolean("resting", this.isResting());
        pCompound.putBoolean("pollinating", this.pollinating);
        pCompound.putInt("pollinationTimer", this.pollinationTimer);
        pCompound.putInt("timeForPollination", this.timeForPollination);
        pCompound.putInt("timeForPathFinding", this.timeForPathFinding);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("flying")) {
            this.setFlying(pCompound.getBoolean("flying"));
        }
        if (pCompound.contains("resting")) {
            this.setResting(pCompound.getBoolean("resting"));
        }
        if (pCompound.contains("pollinating")) {
            this.pollinating = pCompound.getBoolean("pollinating");
        }
        if (pCompound.contains("pollinationTimer")) {
            this.pollinationTimer = pCompound.getInt("pollinationTimer");
        }
        if (pCompound.contains("timeForPollination")) {
            this.timeForPollination = pCompound.getInt("timeForPollination");
        }
        if (pCompound.contains("timeForPathFinding")) {
            this.timeForPathFinding = pCompound.getInt("timeForPathFinding");
        }
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isInvulnerableTo(pSource)) {
            return false;
        }
        if (!this.level().isClientSide && this.isResting()) {
            this.setResting(false);
        } else if (!this.level().isClientSide && !this.isFlying()) {
            this.setFlying(true);
        }
        return super.hurt(pSource, pAmount);
    }

    public boolean isResting() {
        return ((Byte)this.entityData.get(RESTING) & 1) != 0;
    }

    public boolean isFlying() {
        return ((Byte)this.entityData.get(FLYING) & 1) != 0;
    }

    public void setResting(boolean pIsResting) {
        byte b0 = (Byte)this.entityData.get(RESTING);
        if (pIsResting) {
            this.entityData.set(RESTING, (Object)((byte)(b0 | 1)));
        } else {
            this.entityData.set(RESTING, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void setFlying(boolean flying) {
        byte b0 = (Byte)this.entityData.get(RESTING);
        if (flying) {
            this.entityData.set(FLYING, (Object)((byte)(b0 | 1)));
        } else {
            this.entityData.set(FLYING, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        super.registerGoals();
    }

    @Nullable
    private BlockPos searchForFlower() {
        for (int bX = -5; bX < 5; ++bX) {
            for (int bY = -5; bY < 5; ++bY) {
                for (int bZ = -5; bZ < 5; ++bZ) {
                    BlockPos blockpo = this.blockPosition().offset(bX, bY, bZ);
                    BlockState state = this.level().getBlockState(blockpo);
                    if (state.getBlock() instanceof MartianFlowerBlock && this.level().random.nextInt(4) == 0) {
                        if ((Integer)state.getValue((Property)MartianFlowerBlock.AGE) != 2) continue;
                        this.timeForPollination = 400;
                        this.pollinating = true;
                        return blockpo;
                    }
                    if (!(state.getBlock() instanceof MartianTallFlowerBlock) || this.level().random.nextInt(4) != 0) continue;
                    this.timeForPollination = 400;
                    this.pollinating = true;
                    return blockpo;
                }
            }
        }
        return null;
    }

    public boolean doHurtTarget(Entity pEntity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound(SoundEvents.RAVAGER_ATTACK, 1.0f, 1.0f);
        return super.doHurtTarget(pEntity);
    }
}

