/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.entity.goals.RunToGroupGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MercuryRoachEntity
extends Monster
implements GeoAnimatable {
    private static final ResourceLocation SPEED_MODIFIER_ATTACKING_ID = Northstar.asResource("attacking");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_ID, 0.2, AttributeModifier.Operation.ADD_VALUE);
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int eating = 0;
    public int stealTimer = 0;

    public MercuryRoachEntity(EntityType<? extends MercuryRoachEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(1.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.tickCount;
    }

    private PlayState predicate(AnimationState<MercuryRoachEntity> event) {
        if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed((double)event.getLimbSwingAmount()).setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else if (this.eating > 0) {
            --this.eating;
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().then("munch", Animation.LoopType.PLAY_ONCE));
        } else {
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    public static boolean roachSpawnRules(EntityType<MercuryRoachEntity> lunargrade, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        int surfaceY = level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ());
        BlockState state = level.getBlockState(pos.below());
        if (pos.getY() >= surfaceY) {
            return false;
        }
        return state.is(NorthstarTags.NorthstarBlockTags.NATURAL_MERCURY_BLOCKS.tag);
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 10) {
            this.eating = 40;
        }
        super.handleEntityEvent(pId);
    }

    public void tick() {
        if (this.stealTimer > 0) {
            this.stealTimer = Mth.clamp((int)this.stealTimer, (int)0, (int)(this.stealTimer - 1));
        }
        super.tick();
    }

    protected void customServerAiStep() {
        AttributeInstance attributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (this.getTarget() != null) {
            if (!attributeinstance.hasModifier(SPEED_MODIFIER_ATTACKING_ID)) {
                attributeinstance.addTransientModifier(SPEED_MODIFIER_ATTACKING);
            }
        } else if (attributeinstance.hasModifier(SPEED_MODIFIER_ATTACKING_ID)) {
            attributeinstance.removeModifier(SPEED_MODIFIER_ATTACKING);
        }
        super.customServerAiStep();
    }

    protected SoundEvent getAmbientSound() {
        super.getAmbientSound();
        return (SoundEvent)NorthstarSounds.MERCURY_ROACH_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return (SoundEvent)NorthstarSounds.MERCURY_ROACH_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)NorthstarSounds.MERCURY_ROACH_DIE.get();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(9, new RunToGroupGoal<Player>((PathfinderMob)this, Player.class, 7.0f, 1.0, 1.2));
        this.goalSelector.addGoal(7, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        super.registerGoals();
    }

    public boolean doHurtTarget(Entity pEntity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound(SoundEvents.RAVAGER_ATTACK, 1.0f, 1.0f);
        return super.doHurtTarget(pEntity);
    }
}

