/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.entity.projectiles.LunargradeSpit;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MoonLunargradeEntity
extends Monster
implements GeoAnimatable,
RangedAttackMob {
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    boolean didSpit;
    int spitTimer = 0;

    public MoonLunargradeEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(1.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.tickCount;
    }

    private PlayState predicate(AnimationState<MoonLunargradeEntity> event) {
        if (!(event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.spitTimer != 0)) {
            event.getController().setAnimationSpeed((double)event.getLimbSwingAmount()).setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else if (this.spitTimer > 0) {
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().then("spit", Animation.LoopType.PLAY_ONCE));
        } else {
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(3, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.25, 40, 20.0f));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new LunargradeHurtByTargetGoal(this));
    }

    void setDidSpit(boolean bool) {
        this.didSpit = bool;
    }

    public static boolean lunargradeSpawnRules(EntityType<MoonLunargradeEntity> lunargrade, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        int surfaceY = level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ());
        BlockState state = level.getBlockState(pos.below());
        if (level.getEntitiesOfClass(Monster.class, new AABB(pos).inflate(92.0)).size() >= 24) {
            return false;
        }
        if (pos.getY() >= surfaceY) {
            return false;
        }
        return state.is(NorthstarTags.NorthstarBlockTags.NATURAL_MOON_BLOCKS.tag);
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        super.getAmbientSound();
        return (SoundEvent)NorthstarSounds.MOON_LUNARGRADE_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return (SoundEvent)NorthstarSounds.MOON_LUNARGRADE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)NorthstarSounds.MOON_LUNARGRADE_DIE.get();
    }

    private void spit(LivingEntity pTarget) {
        LunargradeSpit lunargradespit = new LunargradeSpit(this.level(), this);
        double d0 = pTarget.getX() - this.getX();
        double d1 = pTarget.getY(0.3333333333333333) - lunargradespit.getY();
        double d2 = pTarget.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
        lunargradespit.shoot(d0, d1 + d3, d2, 1.5f, 10.0f);
        if (!this.isSilent()) {
            this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), SoundEvents.LLAMA_SPIT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        this.level().addFreshEntity((Entity)lunargradespit);
        this.didSpit = true;
        this.spitTimer = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
    }

    public void performRangedAttack(LivingEntity target, float dist) {
        this.spit(target);
    }

    public void tick() {
        super.tick();
        if (this.spitTimer > 0) {
            this.spitTimer = Mth.clamp((int)this.spitTimer, (int)0, (int)(this.spitTimer - 1));
        }
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 4) {
            this.spitTimer = 10;
        }
        super.handleEntityEvent(pId);
    }

    static class LunargradeHurtByTargetGoal
    extends HurtByTargetGoal {
        public LunargradeHurtByTargetGoal(MoonLunargradeEntity lunargrade) {
            super((PathfinderMob)lunargrade, new Class[0]);
        }

        public boolean canContinueToUse() {
            Mob mob = this.mob;
            if (mob instanceof MoonLunargradeEntity) {
                MoonLunargradeEntity lunargrade = (MoonLunargradeEntity)mob;
                if (lunargrade.didSpit) {
                    lunargrade.setDidSpit(false);
                    return false;
                }
            }
            return super.canContinueToUse();
        }
    }
}

