/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VenusMimicEntity
extends Monster
implements GeoAnimatable {
    private static final ResourceLocation SPEED_MODIFIER_ATTACKING_ID = Northstar.asResource("attacking");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_ID, 0.2, AttributeModifier.Operation.ADD_VALUE);
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int attackTick;
    private int hideTick;
    private int ignoreHideTimer = 0;
    private int aggroTimer = 0;
    private boolean hiding = false;
    private boolean attacking = false;
    public boolean isDeep;
    public boolean deepCheck;

    public VenusMimicEntity(EntityType<? extends VenusMimicEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.tickCount;
    }

    private PlayState predicate(AnimationState<VenusMimicEntity> event) {
        AnimationController controller = event.getController();
        if (this.attackTick > 0) {
            --this.attackTick;
            controller.setAnimation(RawAnimation.begin().then("mimic_bite", Animation.LoopType.PLAY_ONCE));
        } else if (!(event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.attacking)) {
            controller.setAnimation(RawAnimation.begin().thenLoop("mimic_walk"));
        } else if (!(event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || !this.attacking)) {
            controller.setAnimation(RawAnimation.begin().thenLoop("mimic_run"));
        } else if (this.hiding && this.hideTick > 0) {
            controller.setAnimation(RawAnimation.begin().thenLoop("mimic_hide"));
        } else if (this.hiding) {
            controller.setAnimation(RawAnimation.begin().thenLoop("mimic_hide_idle"));
        } else {
            controller.setAnimation(RawAnimation.begin().thenLoop("mimic_idle"));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    public boolean canBeCollidedWith() {
        return this.isAlive();
    }

    public static boolean mimicSpawnRules(EntityType<VenusMimicEntity> cobra, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        BlockState state = level.getBlockState(pos.below());
        return state.is(NorthstarTags.NorthstarBlockTags.NATURAL_VENUS_BLOCKS.tag) && !level.canSeeSky(pos);
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 4) {
            this.attackTick = 40;
        } else if (pId == 8) {
            this.hiding = true;
            this.hideTick = 12;
        } else if (pId == 9) {
            this.hiding = false;
            this.ignoreHideTimer = 1200;
        } else if (pId == 12) {
            this.attacking = true;
        } else if (pId == 13) {
            this.attacking = false;
        } else {
            super.handleEntityEvent(pId);
        }
    }

    public void tick() {
        super.tick();
        if (!this.deepCheck) {
            if (this.level().getBlockState(this.blockPosition().below()).is((Block)NorthstarBlocks.VENUS_DEEP_STONE.get()) || this.level().getBlockState(this.blockPosition().below()).is((Block)AllPaletteStoneTypes.SCORCHIA.getBaseBlock().get())) {
                this.isDeep = true;
            }
            this.deepCheck = true;
        }
        if (this.getTarget() != null) {
            if (this.distanceTo((Entity)this.getTarget()) < 5.0f) {
                if (this.aggroTimer > 100) {
                    this.hiding = false;
                    this.ignoreHideTimer = 500;
                    this.level().broadcastEntityEvent((Entity)this, (byte)9);
                    this.targetSelector.enableControlFlag(Goal.Flag.MOVE);
                    this.targetSelector.enableControlFlag(Goal.Flag.LOOK);
                    this.targetSelector.enableControlFlag(Goal.Flag.JUMP);
                }
                ++this.aggroTimer;
            } else {
                --this.aggroTimer;
            }
        }
        if (this.level().random.nextInt(250) == 0 && this.getTarget() == null && !this.hiding && !this.level().isClientSide && this.ignoreHideTimer <= 0) {
            this.level().broadcastEntityEvent((Entity)this, (byte)8);
            this.hiding = true;
            this.hideTick = 12;
            this.setXRot(Mth.roundToward((int)((int)this.getXRot()), (int)90));
        }
        if (this.hiding && this.level().random.nextInt(2000) == 0 && !this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)9);
            this.ignoreHideTimer = 100;
            this.hiding = false;
        }
        if (this.hiding && !this.level().isClientSide && this.getTarget() != null) {
            this.targetSelector.disableControlFlag(Goal.Flag.MOVE);
            this.targetSelector.disableControlFlag(Goal.Flag.LOOK);
            this.targetSelector.disableControlFlag(Goal.Flag.JUMP);
            this.getNavigation().stop();
            if (this.hideTick == 12) {
                // empty if block
            }
            this.setYBodyRot(0.0f);
            this.setYHeadRot(0.0f);
            --this.hideTick;
        } else if (this.hiding && this.level().isClientSide) {
            this.targetSelector.disableControlFlag(Goal.Flag.MOVE);
            this.targetSelector.disableControlFlag(Goal.Flag.LOOK);
            this.targetSelector.disableControlFlag(Goal.Flag.JUMP);
            this.getNavigation().stop();
            this.setYBodyRot(0.0f);
            this.setYHeadRot(0.0f);
            --this.hideTick;
        }
        if (!this.hiding) {
            if (this.ignoreHideTimer > 0) {
                this.ignoreHideTimer = Mth.clamp((int)this.ignoreHideTimer, (int)0, (int)(this.ignoreHideTimer - 1));
            }
            this.targetSelector.enableControlFlag(Goal.Flag.MOVE);
            this.targetSelector.enableControlFlag(Goal.Flag.LOOK);
            this.targetSelector.enableControlFlag(Goal.Flag.JUMP);
        }
    }

    protected void customServerAiStep() {
        AttributeInstance attributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (this.getTarget() != null && !this.hiding) {
            if (!attributeinstance.hasModifier(SPEED_MODIFIER_ATTACKING_ID)) {
                attributeinstance.addTransientModifier(SPEED_MODIFIER_ATTACKING);
                this.attacking = true;
                this.level().broadcastEntityEvent((Entity)this, (byte)12);
            }
        } else if (attributeinstance.hasModifier(SPEED_MODIFIER_ATTACKING_ID)) {
            this.attacking = false;
            this.level().broadcastEntityEvent((Entity)this, (byte)13);
            attributeinstance.removeModifier(SPEED_MODIFIER_ATTACKING);
        }
        super.customServerAiStep();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        super.registerGoals();
    }

    public boolean doHurtTarget(Entity pEntity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.hiding = false;
        this.ignoreHideTimer = 1200;
        this.level().broadcastEntityEvent((Entity)this, (byte)9);
        this.playSound(SoundEvents.RAVAGER_ATTACK, 1.0f, 1.0f);
        return super.doHurtTarget(pEntity);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("isDeep", this.isDeep);
        pCompound.putBoolean("deepCheck", this.deepCheck);
        pCompound.putBoolean("hiding", this.hiding);
        pCompound.putInt("aggroTimer", this.aggroTimer);
        pCompound.putInt("ignoreHideTimer", this.ignoreHideTimer);
        pCompound.putInt("hideTick", this.hideTick);
        pCompound.putInt("attackTick", this.attackTick);
        pCompound.putInt("tickCount", this.tickCount);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("isDeep")) {
            this.isDeep = pCompound.getBoolean("isDeep");
        }
        if (pCompound.contains("deepCheck")) {
            this.deepCheck = pCompound.getBoolean("deepCheck");
        }
        if (pCompound.contains("hiding")) {
            this.hiding = pCompound.getBoolean("hiding");
        }
        if (pCompound.contains("aggroTimer")) {
            this.aggroTimer = pCompound.getInt("aggroTimer");
        }
        if (pCompound.contains("ignoreHideTimer")) {
            this.ignoreHideTimer = pCompound.getInt("ignoreHideTimer");
        }
        if (pCompound.contains("hideTick")) {
            this.hideTick = pCompound.getInt("hideTick");
        }
        if (pCompound.contains("attackTick")) {
            this.attackTick = pCompound.getInt("attackTick");
        }
        if (pCompound.contains("tickCount")) {
            this.tickCount = pCompound.getInt("tickCount");
        }
    }

    protected SoundEvent getAmbientSound() {
        if (!this.hiding) {
            return (SoundEvent)NorthstarSounds.VENUS_MIMIC_IDLE.get();
        }
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        super.getHurtSound(pDamageSource);
        return (SoundEvent)NorthstarSounds.VENUS_MIMIC_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        super.getDeathSound();
        return (SoundEvent)NorthstarSounds.VENUS_MIMIC_DEATH.get();
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isInvulnerableTo(pSource)) {
            return false;
        }
        if (!this.level().isClientSide && this.hiding) {
            this.hiding = false;
            this.ignoreHideTimer = 1200;
            this.level().broadcastEntityEvent((Entity)this, (byte)9);
        }
        return super.hurt(pSource, pAmount);
    }

    boolean isLookingAtMe(Player pPlayer) {
        ItemStack itemstack = (ItemStack)pPlayer.getInventory().armor.get(3);
        if (itemstack.is(Blocks.CARVED_PUMPKIN.asItem())) {
            return false;
        }
        Vec3 vec3 = pPlayer.getViewVector(1.0f).normalize();
        Vec3 vec31 = new Vec3(this.getX() - pPlayer.getX(), this.getEyeY() - pPlayer.getEyeY(), this.getZ() - pPlayer.getZ());
        double d0 = vec31.length();
        vec31 = vec31.normalize();
        double d1 = vec3.dot(vec31);
        Northstar.LOGGER.debug("{}", (Object)d1);
        Northstar.LOGGER.debug("comparer: {}", (Object)(1.0 - 0.35 / (d0 / 8.0)));
        return d1 > 1.0 - 0.35 / (d0 / 8.0) ? pPlayer.hasLineOfSight((Entity)this) : false;
    }

    boolean canTarget(LivingEntity target) {
        if (!this.canAttack(target)) {
            return false;
        }
        return target.getType() == EntityType.PLAYER;
    }

    static class MimicLookForPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final VenusMimicEntity mimic;
        @Nullable
        private Player pendingTarget;
        private int aggroTime;
        private int stareTimer;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.forCombat().ignoreLineOfSight();

        public MimicLookForPlayerGoal(VenusMimicEntity coberuh, @Nullable Predicate<LivingEntity> pSelectionPredicate) {
            super((Mob)coberuh, Player.class, 10, false, false, pSelectionPredicate);
            this.mimic = coberuh;
            this.startAggroTargetConditions = TargetingConditions.forCombat().range(this.getFollowDistance()).selector(p_32578_ -> coberuh.isLookingAtMe((Player)p_32578_));
        }

        public boolean canUse() {
            this.pendingTarget = this.mimic.level().getNearestPlayer(this.startAggroTargetConditions, (LivingEntity)this.mimic);
            return this.pendingTarget != null;
        }

        public void start() {
            this.aggroTime = this.adjustedTickDelay(5);
        }

        public void stop() {
            this.pendingTarget = null;
            super.stop();
        }

        public boolean canContinueToUse() {
            if (this.pendingTarget != null) {
                if (!this.mimic.isLookingAtMe(this.pendingTarget)) {
                    return false;
                }
                this.stareTimer = Mth.clamp((int)(this.stareTimer + 1), (int)0, (int)120);
                Northstar.LOGGER.debug("{}", (Object)this.stareTimer);
                if (this.stareTimer >= 32) {
                    this.mimic.lookAt((Entity)this.pendingTarget, 10.0f, 10.0f);
                    return true;
                }
                return false;
            }
            return this.target != null && this.continueAggroTargetConditions.test((LivingEntity)this.mimic, this.target) ? true : super.canContinueToUse();
        }

        public void tick() {
            if (this.mimic.getTarget() == null) {
                super.setTarget((LivingEntity)null);
            }
            if (this.pendingTarget != null) {
                if (!this.mimic.isLookingAtMe(this.pendingTarget)) {
                    this.stareTimer = Mth.clamp((int)this.stareTimer, (int)0, (int)(this.stareTimer - 1));
                    Northstar.LOGGER.debug("{}", (Object)this.stareTimer);
                }
                if (--this.aggroTime <= 0) {
                    if (!this.mimic.hiding) {
                        this.mimic.hiding = true;
                        this.mimic.hideTick = 12;
                        this.mimic.level().broadcastEntityEvent((Entity)this.mimic, (byte)8);
                    }
                    this.pendingTarget = null;
                    super.start();
                }
            }
            super.tick();
        }
    }

    static class HideWhenStaredAt
    extends Goal {
        private final VenusMimicEntity mimic;
        @Nullable
        private LivingEntity target;

        public HideWhenStaredAt(VenusMimicEntity mimiece) {
            this.mimic = mimiece;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            this.target = this.mimic.getTarget();
            if (!(this.target instanceof Player)) {
                return false;
            }
            double d0 = this.target.distanceToSqr((Entity)this.mimic);
            return !(d0 > 256.0) && this.mimic.isLookingAtMe((Player)this.target) && d0 > 5.0;
        }

        public void start() {
            this.mimic.getNavigation().stop();
        }

        public void tick() {
            this.mimic.getLookControl().setLookAt(this.mimic.getX() + 20.0, this.mimic.getY(), this.mimic.getZ() + 20.0);
        }
    }
}

