/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.entity.projectiles.VenusScorpionSpit;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VenusScorpionEntity
extends Monster
implements GeoAnimatable,
RangedAttackMob {
    private static final ResourceLocation SPEED_MODIFIER_ATTACKING_ID = Northstar.asResource("attacking");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_ID, 0.05, AttributeModifier.Operation.ADD_VALUE);
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int spitAnim = 0;

    public VenusScorpionEntity(EntityType<? extends VenusScorpionEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.tickCount;
    }

    private PlayState predicate(AnimationState<VenusScorpionEntity> event) {
        if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else if (this.spitAnim > 0) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("spit"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    public static boolean scorpionSpawnRules(EntityType<VenusScorpionEntity> moth, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        BlockState state = level.getBlockState(pos.below());
        return state.is(NorthstarTags.NorthstarBlockTags.NATURAL_VENUS_BLOCKS.tag);
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 4) {
            this.spitAnim = 10;
        }
        super.handleEntityEvent(pId);
    }

    public void tick() {
        if (this.spitAnim > 0) {
            --this.spitAnim;
        }
        super.tick();
    }

    protected void customServerAiStep() {
        AttributeInstance attributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (this.getTarget() != null) {
            if (!attributeinstance.hasModifier(SPEED_MODIFIER_ATTACKING_ID)) {
                attributeinstance.addTransientModifier(SPEED_MODIFIER_ATTACKING);
            }
        } else if (attributeinstance.hasModifier(SPEED_MODIFIER_ATTACKING_ID)) {
            attributeinstance.removeModifier(SPEED_MODIFIER_ATTACKING);
        }
        super.customServerAiStep();
    }

    protected SoundEvent getAmbientSound() {
        super.getAmbientSound();
        return (SoundEvent)NorthstarSounds.VENUS_SCORPION_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return (SoundEvent)NorthstarSounds.VENUS_SCORPION_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)NorthstarSounds.VENUS_SCORPION_DEATH.get();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 3.0f, 1.0, 1.0));
        this.goalSelector.addGoal(4, (Goal)new ShootAcidGoal(this));
        this.goalSelector.addGoal(9, (Goal)new StareAtTargetGoal(this));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, ZombifiedPiglin.class, true));
        super.registerGoals();
    }

    public boolean doHurtTarget(Entity pEntity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound(SoundEvents.RAVAGER_ATTACK, 1.0f, 1.0f);
        return super.doHurtTarget(pEntity);
    }

    public void performRangedAttack(LivingEntity pTarget, float pVelocity) {
    }

    static class ShootAcidGoal
    extends Goal {
        private final VenusScorpionEntity shooter;
        public int chargeTime;

        public ShootAcidGoal(VenusScorpionEntity shooter) {
            this.shooter = shooter;
        }

        public boolean canUse() {
            return this.shooter.getTarget() != null;
        }

        public void start() {
            this.chargeTime = 0;
        }

        public void stop() {
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingentity = this.shooter.getTarget();
            if (livingentity != null && !this.shooter.getNavigation().isInProgress()) {
                if (livingentity.distanceToSqr((Entity)this.shooter) < 4096.0 && this.shooter.hasLineOfSight((Entity)livingentity)) {
                    Level level = this.shooter.level();
                    ++this.chargeTime;
                    if (this.chargeTime == 20) {
                        Vec3 vec3 = this.shooter.getViewVector(1.0f);
                        VenusScorpionSpit acidspit = new VenusScorpionSpit(level, this.shooter);
                        double newX = this.shooter.getTarget().getX() - this.shooter.getX();
                        double newY = this.shooter.getTarget().getY(0.3333333333333333) - acidspit.getY();
                        double newZ = this.shooter.getTarget().getZ() - this.shooter.getZ();
                        double newThing = Math.sqrt(newX * newX + newZ * newZ) * (double)0.2f;
                        this.shooter.spitAnim = 10;
                        level.broadcastEntityEvent((Entity)this.shooter, (byte)4);
                        acidspit.shoot(newX, newY + newThing, newZ, 1.5f, 10.0f);
                        acidspit.setPos(this.shooter.getX() + vec3.x, this.shooter.getY(0.5), acidspit.getZ() + vec3.z);
                        level.addFreshEntity((Entity)acidspit);
                        this.chargeTime = -40;
                    }
                } else if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
            }
        }
    }

    static class StareAtTargetGoal
    extends Goal {
        private final VenusScorpionEntity shooter;

        public StareAtTargetGoal(VenusScorpionEntity pShooter) {
            this.shooter = pShooter;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return true;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            if (this.shooter.getTarget() == null) {
                Vec3 vec3 = this.shooter.getDeltaMovement();
                this.shooter.setYRot(-((float)Mth.atan2((double)vec3.x, (double)vec3.z)) * 57.295776f);
                this.shooter.yBodyRot = this.shooter.getYRot();
            } else {
                LivingEntity livingentity = this.shooter.getTarget();
                if (livingentity.distanceToSqr((Entity)this.shooter) < 4096.0) {
                    double d1 = livingentity.getX() - this.shooter.getX();
                    double d2 = livingentity.getZ() - this.shooter.getZ();
                    this.shooter.setYRot(-((float)Mth.atan2((double)d1, (double)d2)) * 57.295776f);
                    this.shooter.yBodyRot = this.shooter.getYRot();
                }
            }
        }
    }
}

