/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity.goals;

import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.entity.MarsToadEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.neoforged.neoforge.event.EventHooks;

public class EatRootsGoal
extends Goal {
    private static final Predicate<BlockState> IS_EDIBLE = BlockStatePredicate.forBlock((Block)((Block)NorthstarBlocks.MARS_ROOTS.get()));
    private final Mob mob;
    private final Level level;
    private int eatAnimationTick;
    private boolean performedCheck = false;

    public EatRootsGoal(Mob pMob) {
        this.mob = pMob;
        this.level = pMob.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        if (this.mob.getRandom().nextInt(this.mob.isBaby() ? 50 : 1000) != 0) {
            return false;
        }
        BlockPos blockpos = this.mob.blockPosition();
        return IS_EDIBLE.test(this.level.getBlockState(blockpos));
    }

    public void start() {
        this.eatAnimationTick = this.adjustedTickDelay(40);
        Mob mob = this.mob;
        if (mob instanceof MarsToadEntity) {
            MarsToadEntity toad = (MarsToadEntity)mob;
            toad.eating = 40;
        }
        this.level.broadcastEntityEvent((Entity)this.mob, (byte)10);
        this.mob.getNavigation().stop();
    }

    public void stop() {
        this.eatAnimationTick = 0;
    }

    public boolean canContinueToUse() {
        return this.eatAnimationTick > 0;
    }

    public int getEatAnimationTick() {
        return this.eatAnimationTick;
    }

    public void tick() {
        BlockPos blockpos;
        if (!this.performedCheck) {
            int rootnumber = 0;
            for (BlockState state : this.level.getBlockStates(this.mob.getBoundingBox().inflate(15.0)).toList()) {
                if (!state.is((Block)NorthstarBlocks.MARS_ROOTS.get())) continue;
                ++rootnumber;
            }
            if (rootnumber < 10) {
                this.stop();
                return;
            }
            this.performedCheck = true;
        }
        this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        if (this.eatAnimationTick == this.adjustedTickDelay(4) && IS_EDIBLE.test(this.level.getBlockState(blockpos = this.mob.blockPosition()))) {
            if (EventHooks.canEntityGrief((Level)this.level, (Entity)this.mob)) {
                this.level.destroyBlock(blockpos, false);
            }
            this.mob.ate();
        }
    }
}

