/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity.goals;

import com.lightning.northstar.entity.MercuryRaptorEntity;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.neoforged.neoforge.event.EventHooks;

public class PushRedstoneComponentsGoal
extends MoveToBlockGoal {
    private final MercuryRaptorEntity disruptor;
    private BlockPos pos;
    private int ticksSinceReachedGoal;
    private static final int WAIT_AFTER_BLOCK_FOUND = 20;

    public PushRedstoneComponentsGoal(MercuryRaptorEntity pRemoverMob, double pSpeedModifier, int pSearchRange) {
        super((PathfinderMob)pRemoverMob, pSpeedModifier, 24, pSearchRange);
        this.disruptor = pRemoverMob;
    }

    public double acceptedDistance() {
        return 3.0;
    }

    public boolean canUse() {
        if (!EventHooks.canEntityGrief((Level)this.disruptor.level(), (Entity)this.disruptor)) {
            return false;
        }
        if (this.disruptor.disruptTimer > 0 && this.disruptor.timeSpentAttacking < 300) {
            return false;
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        if (this.tryFindBlock()) {
            this.nextStartTick = PushRedstoneComponentsGoal.reducedTickDelay((int)20);
            return true;
        }
        this.nextStartTick = this.nextStartTick(this.mob);
        return false;
    }

    private boolean tryFindBlock() {
        return this.blockPos != null && this.isValidTarget((LevelReader)this.mob.level(), this.blockPos) ? true : this.findNearestBlock();
    }

    public void stop() {
        super.stop();
        this.disruptor.fallDistance = 1.0f;
    }

    public void start() {
        super.start();
        this.ticksSinceReachedGoal = 0;
    }

    public void playDestroyProgressSound(LevelAccessor pLevel, BlockPos pPos) {
    }

    public void playBreakSound(Level pLevel, BlockPos pPos) {
    }

    public void tick() {
        super.tick();
        Level level = this.disruptor.level();
        BlockState state = level.getBlockState(this.pos);
        if (this.disruptor.disruptTimer != 0) {
            this.stop();
        }
        if (this.isReachedTarget() && this.disruptor.disruptTimer == 0) {
            BlockState newstate = level.getBlockState(this.pos);
            this.disruptor.disruptTimer = 600;
            ++this.ticksSinceReachedGoal;
            Block block = newstate.getBlock();
            if (block instanceof SlidingDoorBlock) {
                SlidingDoorBlock sliding = (SlidingDoorBlock)block;
                this.disruptor.timeSpentAttacking = 0;
                sliding.setOpen((Entity)this.disruptor, level, newstate, this.pos, (Boolean)newstate.getValue((Property)SlidingDoorBlock.OPEN) == false);
            }
            if ((block = newstate.getBlock()) instanceof DoorBlock) {
                DoorBlock door = (DoorBlock)block;
                this.disruptor.timeSpentAttacking = 0;
                door.setOpen((Entity)this.disruptor, level, newstate, this.pos, (Boolean)newstate.getValue((Property)DoorBlock.OPEN) == false);
                return;
            }
            block = newstate.getBlock();
            if (block instanceof ButtonBlock) {
                ButtonBlock button = (ButtonBlock)block;
                this.disruptor.timeSpentAttacking = 0;
                button.press(newstate, level, this.pos, null);
                return;
            }
            block = newstate.getBlock();
            if (block instanceof LeverBlock) {
                LeverBlock lever = (LeverBlock)block;
                this.disruptor.timeSpentAttacking = 0;
                lever.pull(state, level, this.pos, null);
            }
        }
    }

    protected boolean isValidTarget(LevelReader pLevel, BlockPos pPos) {
        boolean flag;
        ChunkAccess chunkaccess = pLevel.getChunk(SectionPos.blockToSectionCoord((int)pPos.getX()), SectionPos.blockToSectionCoord((int)pPos.getZ()), ChunkStatus.FULL, false);
        if (chunkaccess == null) {
            return false;
        }
        if (!chunkaccess.getBlockState(pPos).canEntityDestroy((BlockGetter)pLevel, pPos, (Entity)this.disruptor)) {
            return false;
        }
        boolean bl = flag = chunkaccess.getBlockState(pPos).hasProperty((Property)DoorBlock.OPEN);
        if (chunkaccess.getBlockState(pPos).hasProperty((Property)ButtonBlock.POWERED) || chunkaccess.getBlockState(pPos).hasProperty((Property)LeverBlock.POWERED)) {
            flag = true;
        }
        if (flag) {
            this.pos = pPos;
            return true;
        }
        return false;
    }
}

