/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity.goals;

import com.lightning.northstar.entity.MercuryRoachEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class ScourChestGoal
extends MoveToBlockGoal {
    private final MercuryRoachEntity disruptor;
    private BlockPos pos;
    private int ticksSinceReachedGoal;
    private int searchTime = 0;
    private static final int WAIT_AFTER_BLOCK_FOUND = 20;

    public ScourChestGoal(MercuryRoachEntity pRemoverMob, double pSpeedModifier, int pSearchRange) {
        super((PathfinderMob)pRemoverMob, pSpeedModifier, 24, pSearchRange);
        this.disruptor = pRemoverMob;
    }

    public double acceptedDistance() {
        return 3.0;
    }

    public boolean canUse() {
        if (!EventHooks.canEntityGrief((Level)this.disruptor.level(), (Entity)this.disruptor)) {
            return false;
        }
        if (this.disruptor.stealTimer > 0) {
            return false;
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        if (this.tryFindBlock()) {
            this.nextStartTick = ScourChestGoal.reducedTickDelay((int)20);
            return true;
        }
        this.nextStartTick = this.nextStartTick(this.mob);
        return false;
    }

    private boolean tryFindBlock() {
        return this.blockPos != null && this.isValidTarget((LevelReader)this.mob.level(), this.blockPos) ? true : this.findNearestBlock();
    }

    public void stop() {
        super.stop();
        this.disruptor.fallDistance = 1.0f;
    }

    public void start() {
        super.start();
        this.ticksSinceReachedGoal = 0;
    }

    public void playDestroyProgressSound(LevelAccessor pLevel, BlockPos pPos) {
    }

    public void playBreakSound(Level pLevel, BlockPos pPos) {
    }

    public void tick() {
        super.tick();
        Level level = this.disruptor.level();
        BlockState state = level.getBlockState(this.pos);
        if (this.searchTime > 0 && this.isReachedTarget()) {
            if (level.getBlockEntity(this.pos) != null) {
                ChestBlockEntity ent = (ChestBlockEntity)level.getBlockEntity(this.pos);
                if (level.getNearestPlayer((Entity)this.disruptor, 128.0) != null) {
                    ent.startOpen(level.getNearestPlayer((Entity)this.disruptor, 128.0));
                }
                if (!ent.isEmpty()) {
                    int randomint = level.random.nextInt(27);
                    ItemStack rando = ent.getItem(randomint);
                    ItemStack newstack = rando.copy();
                    newstack.setCount(1);
                    rando.setCount(rando.getCount() - 1);
                    ent.setItem(randomint, rando);
                    ItemEntity item = new ItemEntity(level, (double)this.pos.getX() + 0.5, (double)(this.pos.getY() + 1), (double)this.pos.getZ() + 0.5, newstack);
                    item.setDeltaMovement(new Vec3((double)level.random.nextInt(-1, 1) * 0.2, (double)level.random.nextInt(0, 1) * 0.2, (double)level.random.nextInt(-1, 1) * 0.2));
                    level.addFreshEntity((Entity)item);
                }
            }
            this.searchTime = Mth.clamp((int)this.searchTime, (int)0, (int)(this.searchTime - 1));
        }
        if (this.disruptor.stealTimer != 0) {
            this.stop();
        }
        if (this.isReachedTarget() && this.disruptor.stealTimer == 0) {
            BlockState newstate = level.getBlockState(this.pos);
            this.disruptor.stealTimer = 600;
            ++this.ticksSinceReachedGoal;
            Block block = newstate.getBlock();
            if (block instanceof ChestBlock) {
                ChestBlock chest = (ChestBlock)block;
                if (this.searchTime == 0) {
                    this.searchTime = 60;
                }
            }
        }
    }

    protected boolean isValidTarget(LevelReader pLevel, BlockPos pPos) {
        ChunkAccess chunkaccess = pLevel.getChunk(SectionPos.blockToSectionCoord((int)pPos.getX()), SectionPos.blockToSectionCoord((int)pPos.getZ()), ChunkStatus.FULL, false);
        if (chunkaccess == null) {
            return false;
        }
        if (!chunkaccess.getBlockState(pPos).canEntityDestroy((BlockGetter)pLevel, pPos, (Entity)this.disruptor)) {
            return false;
        }
        boolean flag = false;
        if (chunkaccess.getBlockState(pPos).is(Blocks.CHEST) && !((ChestBlockEntity)pLevel.getBlockEntity(pPos)).isEmpty()) {
            flag = true;
        }
        if (flag) {
            this.pos = pPos;
            return true;
        }
        return false;
    }
}

