/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity.projectiles;

import com.lightning.northstar.content.NorthstarEntityTypes;
import com.lightning.northstar.entity.VenusScorpionEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class VenusScorpionSpit
extends Projectile {
    public VenusScorpionSpit(EntityType<? extends VenusScorpionSpit> guy, Level pLevel) {
        super(guy, pLevel);
    }

    public VenusScorpionSpit(Level pLevel, VenusScorpionEntity scorpion) {
        this((EntityType<? extends VenusScorpionSpit>)((EntityType)NorthstarEntityTypes.VENUS_SCORPION_SPIT.get()), pLevel);
        this.setOwner((Entity)scorpion);
        this.setPos(scorpion.getX() - (double)(scorpion.getBbWidth() + 1.0f) * 0.5 * (double)Mth.sin((float)(scorpion.yBodyRot * ((float)Math.PI / 180))), scorpion.getEyeY() - (double)0.1f, scorpion.getZ() + (double)(scorpion.getBbWidth() + 1.0f) * 0.5 * (double)Mth.cos((float)(scorpion.yBodyRot * ((float)Math.PI / 180))));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        Vec3 vec3 = this.getDeltaMovement();
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
        if (hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.onHit(hitresult);
        }
        double newX = this.getX() + vec3.x;
        double newY = this.getY() + vec3.y;
        double newZ = this.getZ() + vec3.z;
        this.updateRotation();
        if (this.level().getBlockStates(this.getBoundingBox()).noneMatch(BlockBehaviour.BlockStateBase::isAir)) {
            this.discard();
        } else if (this.isInWaterOrBubble()) {
            this.discard();
        } else {
            this.setDeltaMovement(vec3.scale((double)0.99f));
            if (!this.isNoGravity()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)-0.06f, 0.0));
            }
            this.setPos(newX, newY, newZ);
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
        super.onHitEntity(pResult);
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            pResult.getEntity().hurt(this.level().damageSources().mobProjectile((Entity)this, (LivingEntity)entity), 12.0f);
        }
    }

    protected void onHitBlock(BlockHitResult pResult) {
        super.onHitBlock(pResult);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    public void recreateFromPacket(ClientboundAddEntityPacket pPacket) {
        super.recreateFromPacket(pPacket);
        double d0 = pPacket.getXa();
        double d1 = pPacket.getYa();
        double d2 = pPacket.getZa();
        for (int i = 0; i < 7; ++i) {
            double d3 = 0.4 + 0.1 * (double)i;
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), d0 * d3, d1, d2 * d3);
        }
        this.setDeltaMovement(d0, d1, d2);
    }
}

