/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.item;

import com.lightning.northstar.block.simple.GlowstoneTorchWallBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class GlowstoneTorchItem
extends BlockItem {
    private final Block wallBlock = (Block)NorthstarBlocks.GLOWSTONE_TORCH_WALL.get();

    public GlowstoneTorchItem(GlowstoneTorchWallBlock pStandingBlock, Item.Properties pProperties) {
        super((Block)pStandingBlock, pProperties);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState blockstate = this.wallBlock.getStateForPlacement(context);
        BlockState blockstate1 = null;
        Level levelreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState blockstate2;
            if (direction == Direction.UP) continue;
            BlockState blockState = blockstate2 = direction == Direction.DOWN ? this.getBlock().getStateForPlacement(context) : blockstate;
            if (blockstate2 == null || !blockstate2.canSurvive((LevelReader)levelreader, blockpos)) continue;
            blockstate1 = blockstate2;
            break;
        }
        return blockstate1 != null && levelreader.isUnobstructed(blockstate1, blockpos, CollisionContext.empty()) ? blockstate1 : null;
    }

    public void registerBlocks(Map<Block, Item> pBlockToItemMap, Item pItem) {
        super.registerBlocks(pBlockToItemMap, pItem);
        pBlockToItemMap.put(this.wallBlock, pItem);
    }

    public void removeFromBlockToItemMap(Map<Block, Item> blockToItemMap, Item itemIn) {
        super.removeFromBlockToItemMap(blockToItemMap, itemIn);
        blockToItemMap.remove(this.wallBlock);
    }
}

