/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.block;

import com.lightning.northstar.accessor.NorthstarFluidState;
import com.lightning.northstar.world.sealer.SealingMode;
import com.lightning.northstar.world.temperature.NorthstarTemperature;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mixin(value={FluidState.class})
public class FluidStateMixin
implements NorthstarFluidState {
    @Inject(method={"tick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="TAIL")})
    public void northstar$tick(Level level, BlockPos pos, CallbackInfo info) {
        this.northstar$onSealUpdated(level, pos, SealingMode.TEMPERATURE);
    }

    @Override
    public void northstar$onSealUpdated(Level level, BlockPos pos, SealingMode mode) {
        if (mode != SealingMode.TEMPERATURE) {
            return;
        }
        FluidState self = (FluidState)this;
        float temperature = NorthstarTemperature.getTemperatureAt(level, (Vec3i)pos);
        if (temperature >= (float)NorthstarTemperature.getBoilingPoint(self)) {
            BlockState block = level.getBlockState(pos);
            if (block.hasProperty((Property)BlockStateProperties.WATERLOGGED) && !self.isEmpty()) {
                level.setBlockAndUpdate(pos, (BlockState)block.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
            } else {
                NorthstarTemperature.evaporate(level, pos);
            }
            return;
        }
        if (temperature <= (float)NorthstarTemperature.getFreezingPoint(self) && self.is((Fluid)Fluids.WATER)) {
            BlockState block = level.getBlockState(pos);
            if (block.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                level.setBlockAndUpdate(pos, (BlockState)block.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
            } else {
                level.setBlockAndUpdate(pos, Blocks.ICE.defaultBlockState());
            }
            return;
        }
        if (NorthstarTemperature.isCombustible(self) && temperature >= (float)NorthstarTemperature.combustionTemp(self)) {
            this.northstar$combust(level, pos);
        }
    }

    @Unique
    public void northstar$combust(Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 2.5f, true, Level.ExplosionInteraction.MOB);
    }
}

