/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.block;

import com.lightning.northstar.block.simple.ExtinguishedTorchBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.mixin.accessor.FlowingFluidAccessor;
import com.lightning.northstar.world.oxygen.NorthstarOxygen;
import com.lightning.northstar.world.sealer.SealReactiveBlock;
import com.lightning.northstar.world.sealer.SealingMode;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mixin(value={TorchBlock.class})
public class TorchBlockMixin
extends Block
implements LiquidBlockContainer,
SealReactiveBlock {
    public TorchBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return true;
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (fluidState.getType() != Fluids.WATER || state.getBlock() != Blocks.TORCH) {
            Fluid fluid = fluidState.getType();
            if (fluid instanceof FlowingFluidAccessor) {
                FlowingFluidAccessor flowing = (FlowingFluidAccessor)fluid;
                flowing.northstar$beforeDestroyingBlock(level, pos, state);
            }
            level.setBlock(pos, fluidState.createLegacyBlock(), 3);
            return true;
        }
        level.setBlock(pos, (BlockState)NorthstarBlocks.EXTINGUISHED_TORCH.getDefaultState().setValue((Property)ExtinguishedTorchBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
        return true;
    }

    @Override
    public void northstar$onSealUpdated(Level level, BlockPos pos, BlockState state, SealingMode mode) {
        if (mode == SealingMode.OXYGEN && state.getBlock() == Blocks.TORCH && !NorthstarOxygen.hasOxygen(level, (Vec3i)pos)) {
            level.setBlock(pos, ((ExtinguishedTorchBlock)((Object)NorthstarBlocks.EXTINGUISHED_TORCH.get())).defaultBlockState(), 3);
        }
    }
}

