/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.dimensionstuff;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.particle.NorthstarParticles;
import com.lightning.northstar.world.dimension.NorthstarDimensions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    private static final ResourceLocation EARTH_CLOSE = Northstar.asResource("textures/environment/earth_close.png");
    private static final ResourceLocation EARTH_FAR = Northstar.asResource("textures/environment/earth_far.png");
    private static final ResourceLocation MOON_CLOSE = Northstar.asResource("textures/environment/moon_close.png");
    private static final ResourceLocation MOON_FAR = Northstar.asResource("textures/environment/moon_far.png");
    private static final ResourceLocation VENUS_FAR = Northstar.asResource("textures/environment/venus_far_sky.png");
    private static final ResourceLocation VENUS_CLOSE = Northstar.asResource("textures/environment/venus_close.png");
    private static final ResourceLocation BARE_SUN = Northstar.asResource("textures/environment/baresun.png");
    private static final ResourceLocation BLURRED_SUN = Northstar.asResource("textures/environment/sun_blurry.png");
    private static final ResourceLocation MARS_CLOSE = Northstar.asResource("textures/environment/mars_close.png");
    private static final ResourceLocation MARS_VERY_FAR = Northstar.asResource("textures/environment/mars_very_far_sky.png");
    private static final ResourceLocation MERCURY_CLOSE = Northstar.asResource("textures/environment/mercury_close.png");
    private static final ResourceLocation PHOBOS_DEIMOS = Northstar.asResource("textures/environment/phobos_and_deimos.png");
    private static final ResourceLocation NORTHERN_STAR = Northstar.asResource("textures/environment/northernstar_sky.png");
    private static final ResourceLocation MARS_DUST = Northstar.asResource("textures/environment/mars_dust.png");
    private static final ResourceLocation ACID_RAIN = Northstar.asResource("textures/environment/acid_rain.png");
    private static final ResourceLocation MOON_LOC = ResourceLocation.parse((String)"textures/environment/moon_phases.png");
    private static final ResourceLocation CLOUDS_LOCATION = ResourceLocation.parse((String)"textures/environment/clouds.png");
    private static final ResourceLocation SNOW_LOCATION = ResourceLocation.parse((String)"textures/environment/snow.png");
    @Nullable
    private VertexBuffer darkBuffer;
    @Shadow
    private VertexBuffer skyBuffer;
    @Shadow
    private VertexBuffer starBuffer;
    private VertexBuffer starBuffer2;
    private VertexBuffer starBuffer3;
    @Shadow
    @Nullable
    private VertexBuffer cloudBuffer;
    @Nullable
    private VertexBuffer cloudBuffer2;
    private boolean generateClouds = true;
    private int prevCloudX = Integer.MIN_VALUE;
    private int prevCloudY = Integer.MIN_VALUE;
    private int prevCloudZ = Integer.MIN_VALUE;
    private Vec3 prevCloudColor = Vec3.ZERO;
    @Nullable
    private CloudStatus prevCloudsType;
    @Shadow
    @Nullable
    private ClientLevel level;
    @Final
    @Shadow
    private Minecraft minecraft;
    private float f_alpha = 1.0f;
    private int ticks;
    private int rainSoundTime;
    private float dust_bounce = 0.01f;
    float sc = 1.0f;
    private static final Vector3f VENUS_DIFFUSE_1 = new Vector3f(0.2f, -1.0f, -0.7f).normalize();
    private static final Vector3f VENUS_DIFFUSE_2 = new Vector3f(-0.2f, -1.0f, 0.7f).normalize();
    private final float[] rainSizeX = new float[1024];
    private final float[] rainSizeZ = new float[1024];

    @Inject(method={"renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderWeather(LightTexture lightTexture, float partialTick, double camXd, double camYd, double camZd, CallbackInfo info) {
        float rain_det;
        float playerEyeLevel;
        float camX = (float)camXd;
        float camY = (float)camYd;
        float camZ = (float)camZd;
        if (this.minecraft != null && (playerEyeLevel = (float)this.minecraft.player.getEyePosition().y) > 450.0f) {
            info.cancel();
            return;
        }
        ResourceKey player_dim = Minecraft.getInstance().level.dimension();
        if (player_dim == NorthstarDimensions.MARS_DIM_KEY) {
            info.cancel();
            rain_det = this.minecraft.level.getRainLevel(partialTick);
            if (!(rain_det <= 0.0f)) {
                lightTexture.turnOnLightLayer();
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Camera pCamera = Minecraft.getInstance().gameRenderer.getMainCamera();
                GameRenderer gRenderer = Minecraft.getInstance().gameRenderer;
                Vec3 vec3 = pCamera.getPosition();
                float fog_x = (float)vec3.x();
                float fog_y = (float)vec3.y();
                FogRenderer.setupColor((Camera)pCamera, (float)partialTick, (ClientLevel)this.minecraft.level, (int)this.minecraft.options.getEffectiveRenderDistance(), (float)gRenderer.getDarkenWorldAmount(partialTick));
                FogRenderer.levelFogColor();
                boolean flag2 = this.minecraft.level.effects().isFoggyAt(Mth.floor((float)fog_x), Mth.floor((float)fog_y)) || this.minecraft.gui.getBossOverlay().shouldCreateWorldFog();
                FogRenderer.setupFog((Camera)pCamera, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_TERRAIN, (float)(this.minecraft.options.getEffectiveRenderDistance() / 5), (boolean)flag2, (float)partialTick);
                FogRenderer.setupNoFog();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.disableBlend();
                lightTexture.turnOnLightLayer();
                ClientLevel level = this.minecraft.level;
                int i = Mth.floor((float)camX);
                int j = Mth.floor((float)camY);
                int k = Mth.floor((float)camZ);
                Tesselator tesselator = Tesselator.getInstance();
                BufferBuilder bufferbuilder = null;
                RenderSystem.disableCull();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableDepthTest();
                int l = 2;
                if (Minecraft.useFancyGraphics()) {
                    l = 3;
                }
                RenderSystem.depthMask((boolean)Minecraft.useShaderTransparency());
                int i1 = -1;
                float f1 = (float)this.ticks + partialTick;
                RenderSystem.setShader(GameRenderer::getParticleShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int j1 = k - l; j1 <= k + l; ++j1) {
                    for (int k1 = i - l; k1 <= i + l; ++k1) {
                        int l1 = (j1 - k + 8) * 32 + k1 - i + 8;
                        float d0 = this.rainSizeX[l1] * 1.25f;
                        float d1 = this.rainSizeZ[l1] * 1.25f;
                        blockpos$mutableblockpos.set((double)k1, (double)camY, (double)j1);
                        Biome biome = (Biome)level.getBiome((BlockPos)blockpos$mutableblockpos).value();
                        if (biome.hasPrecipitation()) continue;
                        int i2 = level.getHeight(Heightmap.Types.MOTION_BLOCKING, k1, j1);
                        int j2 = j - l;
                        int k2 = j + l;
                        if (j2 < i2) {
                            j2 = i2;
                        }
                        if (k2 < i2) {
                            k2 = i2;
                        }
                        int l2 = i2;
                        if (i2 < j) {
                            l2 = j;
                        }
                        if (j2 == k2) continue;
                        RandomSource randomsource = RandomSource.create((long)(k1 * k1 * 3121 + k1 * 45238971 ^ j1 * j1 * 418711 + j1 * 13761));
                        blockpos$mutableblockpos.set(k1, j2, j1);
                        if (biome.warmEnoughToRain((BlockPos)blockpos$mutableblockpos)) {
                            if (i1 != 0) {
                                if (i1 >= 0) {
                                    BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                                }
                                i1 = 0;
                                RenderSystem.setShaderTexture((int)0, (ResourceLocation)MARS_DUST);
                                bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                            }
                            int i3 = this.ticks + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                            float f2 = -((float)i3 + partialTick) / 32.0f * 0.75f;
                            this.dust_bounce = this.dust_bounce > 0.0f ? (float)((double)this.dust_bounce - 0.01) : (float)((double)this.dust_bounce + 0.01);
                            blockpos$mutableblockpos.set(k1, l2, j1);
                            RenderSystem.setShaderColor((float)2.0f, (float)1.178f, (float)0.698f, (float)0.5f);
                            boolean j3 = false;
                            bufferbuilder.addVertex((float)k1 - camX - d0 + -10.5f, (float)k2 - camY, (float)j1 - camZ - d1 + 10.5f).setUv(0.0f + f2, 0.0f).setColor(1.0f, 1.0f, 1.0f, 0.2f).setUv2(0, 0);
                            bufferbuilder.addVertex((float)k1 - camX + d0 + 10.5f, (float)k2 - camY, (float)j1 - camZ + d1 + -10.5f).setUv(1.0f + f2, 0.0f + this.dust_bounce / 2.0f).setColor(1.0f, 1.0f, 1.0f, 0.2f).setUv2(0, 0);
                            bufferbuilder.addVertex((float)k1 - camX + d0 + 10.5f, (float)j2 - camY, (float)j1 - camZ + d1 + -10.5f).setUv(1.0f + f2, 1.0f + this.dust_bounce / 2.0f).setColor(1.0f, 1.0f, 1.0f, 0.2f).setUv2(0, 0);
                            bufferbuilder.addVertex((float)k1 - camX - d0 + -10.5f, (float)j2 - camY, (float)j1 - camZ - d1 + 10.5f).setUv(0.0f + f2, 1.0f).setColor(1.0f, 1.0f, 1.0f, 0.2f).setUv2(0, 0);
                            continue;
                        }
                        if (i1 != 1) {
                            if (i1 >= 0) {
                                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                            }
                            i1 = 1;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SNOW_LOCATION);
                            bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                        }
                        float f5 = -((float)(this.ticks & 0x1FF) + partialTick) / 512.0f;
                        float f6 = randomsource.nextFloat() + f1 * 0.01f * (float)randomsource.nextGaussian();
                        float f7 = randomsource.nextFloat() + f1 * (float)randomsource.nextGaussian() * 0.001f;
                        float d3 = (float)k1 + 0.5f - camX;
                        float d5 = (float)j1 + 0.5f - camZ;
                        float f8 = (float)Math.sqrt(d3 * d3 + d5 * d5) / (float)l;
                        float f9 = ((1.0f - f8 * f8) * 0.3f + 0.5f) * rain_det;
                        blockpos$mutableblockpos.set(k1, l2, j1);
                        int k3 = 4;
                        int l3 = k3 >> 16 & 0xFFFF;
                        int i4 = k3 & 0xFFFF;
                        int j4 = (l3 * 3 + 240) / 4;
                        int k4 = (i4 * 3 + 240) / 4;
                        bufferbuilder.addVertex((float)k1 - camX - d0 + 0.5f, (float)k2 - camY, (float)j1 - camZ - d1 + 0.5f).setUv(0.0f + f6, (float)j2 * 0.25f + f5 + f7).setColor(1.0f, 1.0f, 1.0f, f9).setUv2(k4, j4);
                        bufferbuilder.addVertex((float)k1 - camX + d0 + 0.5f, (float)k2 - camY, (float)j1 - camZ + d1 + 0.5f).setUv(1.0f + f6, (float)j2 * 0.25f + f5 + f7).setColor(1.0f, 1.0f, 1.0f, f9).setUv2(k4, j4);
                        bufferbuilder.addVertex((float)k1 - camX + d0 + 0.5f, (float)j2 - camY, (float)j1 - camZ + d1 + 0.5f).setUv(1.0f + f6, (float)k2 * 0.25f + f5 + f7).setColor(1.0f, 1.0f, 1.0f, f9).setUv2(k4, j4);
                        bufferbuilder.addVertex((float)k1 - camX - d0 + 0.5f, (float)j2 - camY, (float)j1 - camZ - d1 + 0.5f).setUv(0.0f + f6, (float)k2 * 0.25f + f5 + f7).setColor(1.0f, 1.0f, 1.0f, f9).setUv2(k4, j4);
                    }
                }
                if (i1 >= 0) {
                    BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableCull();
                RenderSystem.disableBlend();
            }
        }
        if (player_dim == NorthstarDimensions.VENUS_DIM_KEY) {
            info.cancel();
            rain_det = this.minecraft.level.getRainLevel(partialTick);
            if (!(rain_det <= 0.0f)) {
                lightTexture.turnOnLightLayer();
                ClientLevel level = this.minecraft.level;
                int i = Mth.floor((float)camX);
                int j = Mth.floor((float)camY);
                int k = Mth.floor((float)camZ);
                Tesselator tesselator = Tesselator.getInstance();
                BufferBuilder bufferbuilder = null;
                RenderSystem.disableCull();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableDepthTest();
                int l = 5;
                if (Minecraft.useFancyGraphics()) {
                    l = 10;
                }
                RenderSystem.depthMask((boolean)Minecraft.useShaderTransparency());
                int i1 = -1;
                RenderSystem.setShader(GameRenderer::getParticleShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int j1 = k - l; j1 <= k + l; ++j1) {
                    for (int k1 = i - l; k1 <= i + l; ++k1) {
                        int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                        float d0 = this.rainSizeX[l1] * 0.5f;
                        float d1 = this.rainSizeZ[l1] * 0.5f;
                        blockpos$mutableblockpos.set((double)k1, (double)camY, (double)j1);
                        Biome biome = (Biome)level.getBiome((BlockPos)blockpos$mutableblockpos).value();
                        if (biome.hasPrecipitation()) continue;
                        int i2 = level.getHeight(Heightmap.Types.MOTION_BLOCKING, k1, j1);
                        int j2 = j - l;
                        int k2 = j + l;
                        if (j2 < i2) {
                            j2 = i2;
                        }
                        if (k2 < i2) {
                            k2 = i2;
                        }
                        int l2 = i2;
                        if (i2 < j) {
                            l2 = j;
                        }
                        if (j2 == k2) continue;
                        RandomSource randomsource = RandomSource.create((long)(k1 * k1 * 3121 + k1 * 45238971 ^ j1 * j1 * 418711 + j1 * 13761));
                        blockpos$mutableblockpos.set(k1, j2, j1);
                        if (!biome.warmEnoughToRain((BlockPos)blockpos$mutableblockpos)) continue;
                        if (i1 != 0) {
                            if (i1 >= 0) {
                                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                            }
                            i1 = 0;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ACID_RAIN);
                            bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                        }
                        int i3 = this.ticks + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                        float f2 = -((float)i3 + partialTick) / 32.0f * (3.0f + randomsource.nextFloat());
                        float d2 = (float)k1 + 0.5f - camX;
                        float d4 = (float)j1 + 0.5f - camZ;
                        float f3 = (float)Math.sqrt(d2 * d2 + d4 * d4) / (float)l;
                        float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * rain_det;
                        blockpos$mutableblockpos.set(k1, l2, j1);
                        int j3 = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                        int k4 = j3 >> 16 & 0xFFFF;
                        int l4 = j3 & 0xFFFF;
                        int l3 = (k4 * 3 + 240) / 4;
                        int i4 = (l4 * 3 + 240) / 4;
                        bufferbuilder.addVertex((float)k1 - camX - d0 + 0.5f, (float)k2 - camY, (float)j1 - camZ - d1 + 0.5f).setUv(0.0f, (float)j2 * 0.25f + f2).setColor(1.0f, 1.0f, 1.0f, f4).setUv2(l3, i4);
                        bufferbuilder.addVertex((float)k1 - camX + d0 + 0.5f, (float)k2 - camY, (float)j1 - camZ + d1 + 0.5f).setUv(1.0f, (float)j2 * 0.25f + f2).setColor(1.0f, 1.0f, 1.0f, f4).setUv2(l3, i4);
                        bufferbuilder.addVertex((float)k1 - camX + d0 + 0.5f, (float)j2 - camY, (float)j1 - camZ + d1 + 0.5f).setUv(1.0f, (float)k2 * 0.25f + f2).setColor(1.0f, 1.0f, 1.0f, f4).setUv2(l3, i4);
                        bufferbuilder.addVertex((float)k1 - camX - d0 + 0.5f, (float)j2 - camY, (float)j1 - camZ - d1 + 0.5f).setUv(0.0f, (float)k2 * 0.25f + f2).setColor(1.0f, 1.0f, 1.0f, f4).setUv2(l3, i4);
                    }
                }
                if (i1 >= 0) {
                    BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableCull();
                RenderSystem.disableBlend();
            }
        }
    }

    @Inject(method={"tickRain(Lnet/minecraft/client/Camera;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void tickRain(Camera pCamera, CallbackInfo info) {
        float d4;
        float d3;
        float d2;
        VoxelShape voxelshape;
        FluidState fluidstate;
        BlockState blockstate;
        float d1;
        float d0;
        Biome biome;
        BlockPos blockpos2;
        int l;
        int k;
        int j;
        int i;
        BlockPos blockpos1;
        BlockPos blockpos;
        ClientLevel levelreader;
        RandomSource randomsource;
        float rain_det;
        float playerEyeLevel;
        if (this.minecraft != null && (playerEyeLevel = (float)this.minecraft.player.getEyePosition().y) > 450.0f) {
            info.cancel();
            return;
        }
        ResourceKey player_dim = Minecraft.getInstance().level.dimension();
        if (player_dim == NorthstarDimensions.MARS_DIM_KEY) {
            info.cancel();
            rain_det = this.minecraft.level.getRainLevel(3.0f);
            if (this.level.random.nextInt(2) == 0 && this.level.isDay()) {
                BlockPos newpos = this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, new BlockPos(pCamera.getBlockPosition().getX() + this.level.random.nextIntBetweenInclusive(-64, 64), 0, pCamera.getBlockPosition().getZ() + this.level.random.nextIntBetweenInclusive(-64, 64)));
                this.level.isClientSide();
                this.level.addAlwaysVisibleParticle((ParticleOptions)NorthstarParticles.DUST_CLOUD.get(), (double)newpos.getX(), (double)(newpos.getY() + this.level.random.nextInt(3)), (double)newpos.getZ(), 0.0, 0.0, 0.0);
            }
            if (!(rain_det <= 0.0f)) {
                if (this.level.effects().tickRain(this.level, this.ticks, pCamera)) {
                    return;
                }
                float f = this.minecraft.level.getRainLevel(1.0f) / (Minecraft.useFancyGraphics() ? 1.0f : 2.0f);
                if (!(f <= 0.0f)) {
                    randomsource = RandomSource.create((long)((long)this.ticks * 312987231L));
                    levelreader = this.minecraft.level;
                    blockpos = BlockPos.containing((Position)pCamera.getPosition());
                    blockpos1 = null;
                    i = (int)(100.0f * f * f) / (this.minecraft.options.particles().get() == ParticleStatus.DECREASED ? 2 : 1);
                    for (j = 0; j < i; ++j) {
                        k = randomsource.nextInt(21) - 10;
                        l = randomsource.nextInt(21) - 10;
                        blockpos2 = levelreader.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos.offset(k, 0, l));
                        biome = (Biome)levelreader.getBiome(blockpos2).value();
                        if (blockpos2.getY() <= levelreader.getMinBuildHeight() || blockpos2.getY() > blockpos.getY() + 10 || blockpos2.getY() < blockpos.getY() - 10 || biome.hasPrecipitation() || !biome.warmEnoughToRain(blockpos2)) continue;
                        blockpos1 = blockpos2.below();
                        if (this.minecraft.options.particles().get() == ParticleStatus.MINIMAL) break;
                        d0 = randomsource.nextFloat();
                        d1 = randomsource.nextFloat();
                        blockstate = levelreader.getBlockState(blockpos1);
                        fluidstate = levelreader.getFluidState(blockpos1);
                        voxelshape = blockstate.getCollisionShape((BlockGetter)levelreader, blockpos1);
                        d2 = (float)voxelshape.max(Direction.Axis.Y, (double)d0, (double)d1);
                        d3 = fluidstate.getHeight((BlockGetter)levelreader, blockpos1);
                        d4 = Math.max(d2, d3);
                        if (this.level.random.nextInt(10) != 0) continue;
                        this.minecraft.level.addParticle((ParticleOptions)NorthstarParticles.DUST_CLOUD.get(), (double)((float)blockpos1.getX() + d0), (double)((float)blockpos1.getY() + d4 + (float)this.level.random.nextInt(4)), (double)((float)blockpos1.getZ() + d1), 0.0, 0.0, 0.0);
                    }
                    if (blockpos1 != null && randomsource.nextInt(12) < this.rainSoundTime++) {
                        this.rainSoundTime = 0;
                        if (blockpos1.getY() > blockpos.getY() + 1 && levelreader.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos).getY() > Mth.floor((float)blockpos.getY())) {
                            this.minecraft.level.playLocalSound(blockpos1, (SoundEvent)NorthstarSounds.MARTIAN_DUST_STORM_ABOVE.get(), SoundSource.WEATHER, 0.1f, 0.5f, false);
                        } else {
                            this.minecraft.level.playLocalSound(blockpos1, (SoundEvent)NorthstarSounds.MARTIAN_DUST_STORM.get(), SoundSource.WEATHER, 0.5f, 1.0f, false);
                        }
                    }
                }
            }
        }
        if (player_dim == NorthstarDimensions.VENUS_DIM_KEY) {
            info.cancel();
            rain_det = this.minecraft.level.getRainLevel(3.0f);
            if (!(rain_det <= 0.0f)) {
                if (this.level.effects().tickRain(this.level, this.ticks, pCamera)) {
                    return;
                }
                float f = this.minecraft.level.getRainLevel(1.0f) / (Minecraft.useFancyGraphics() ? 1.0f : 2.0f);
                if (!(f <= 0.0f)) {
                    randomsource = RandomSource.create((long)((long)this.ticks * 312987231L));
                    levelreader = this.minecraft.level;
                    blockpos = BlockPos.containing((Position)pCamera.getPosition());
                    blockpos1 = null;
                    i = (int)(100.0f * f * f) / (this.minecraft.options.particles().get() == ParticleStatus.DECREASED ? 2 : 1);
                    for (j = 0; j < i; ++j) {
                        k = randomsource.nextInt(21) - 10;
                        l = randomsource.nextInt(21) - 10;
                        blockpos2 = levelreader.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos.offset(k, 0, l));
                        biome = (Biome)levelreader.getBiome(blockpos2).value();
                        if (blockpos2.getY() <= levelreader.getMinBuildHeight() || blockpos2.getY() > blockpos.getY() + 10 || blockpos2.getY() < blockpos.getY() - 10 || biome.hasPrecipitation() || !biome.warmEnoughToRain(blockpos2)) continue;
                        blockpos1 = blockpos2.below();
                        if (this.minecraft.options.particles().get() == ParticleStatus.MINIMAL) break;
                        d0 = randomsource.nextFloat();
                        d1 = randomsource.nextFloat();
                        blockstate = levelreader.getBlockState(blockpos1);
                        fluidstate = levelreader.getFluidState(blockpos1);
                        voxelshape = blockstate.getCollisionShape((BlockGetter)levelreader, blockpos1);
                        d2 = (float)voxelshape.max(Direction.Axis.Y, (double)d0, (double)d1);
                        d3 = fluidstate.getHeight((BlockGetter)levelreader, blockpos1);
                        d4 = Math.max(d2, d3);
                        SimpleParticleType particleoptions = ParticleTypes.SMOKE;
                        this.minecraft.level.addParticle((ParticleOptions)particleoptions, (double)((float)blockpos1.getX() + d0), (double)((float)blockpos1.getY() + d4), (double)((float)blockpos1.getZ() + d1), 0.0, 0.0, 0.0);
                    }
                    if (blockpos1 != null && randomsource.nextInt(3) < this.rainSoundTime++) {
                        this.rainSoundTime = 0;
                        if (blockpos1.getY() > blockpos.getY() + 1 && levelreader.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos).getY() > Mth.floor((float)blockpos.getY())) {
                            this.minecraft.level.playLocalSound(blockpos1, SoundEvents.WEATHER_RAIN_ABOVE, SoundSource.WEATHER, 0.1f, 0.5f, false);
                        } else {
                            this.minecraft.level.playLocalSound(blockpos1, SoundEvents.WEATHER_RAIN, SoundSource.WEATHER, 0.2f, 1.0f, false);
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"createStars()V"}, at={@At(value="TAIL")})
    private void createStars(CallbackInfo ci) {
        RenderSystem.setShader(GameRenderer::getPositionShader);
        if (this.starBuffer2 != null) {
            this.starBuffer2.close();
        }
        this.starBuffer2 = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.starBuffer2.bind();
        this.starBuffer2.upload(this.drawStars2());
        VertexBuffer.unbind();
        RenderSystem.setShader(GameRenderer::getPositionShader);
        if (this.starBuffer3 != null) {
            this.starBuffer3.close();
        }
        this.starBuffer3 = new VertexBuffer(VertexBuffer.Usage.STATIC);
        MeshData bufferbuilder$renderedbuffer3 = this.drawStars3();
        this.starBuffer3.bind();
        this.starBuffer3.upload(bufferbuilder$renderedbuffer3);
        VertexBuffer.unbind();
    }

    private MeshData drawStars2() {
        RandomSource randomsource = RandomSource.create((long)92410L);
        BufferBuilder pBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        for (int i = 0; i < 2500; ++i) {
            float d0 = randomsource.nextFloat() * 2.0f - 1.0f;
            float d1 = randomsource.nextFloat() * 2.0f - 1.0f;
            float d2 = randomsource.nextFloat() * 2.0f - 1.0f;
            float d3 = 0.15f + randomsource.nextFloat() * 0.1f;
            float d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0f) || !(d4 > 0.01f)) continue;
            d4 = (float)(1.0 / Math.sqrt(d4));
            float d5 = (d0 *= d4) * 100.0f;
            float d6 = (d1 *= d4) * 100.0f;
            float d7 = (d2 *= d4) * 100.0f;
            float d8 = (float)Math.atan2(d0, d2);
            float d9 = (float)Math.sin(d8);
            float d10 = (float)Math.cos(d8);
            float d11 = (float)Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            float d12 = (float)Math.sin(d11);
            float d13 = (float)Math.cos(d11);
            float d14 = (float)((double)randomsource.nextFloat() * Math.PI * 2.0);
            float d15 = (float)Math.sin(d14);
            float d16 = (float)Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                float d18 = (float)((j & 2) - 1) * d3;
                float d19 = (float)((j + 1 & 2) - 1) * d3;
                float d21 = d18 * d16 - d19 * d15;
                float d22 = d19 * d16 + d18 * d15;
                float d23 = d21 * d12 + 0.0f * d13;
                float d24 = 0.0f * d12 - d21 * d13;
                float d25 = d24 * d9 - d22 * d10;
                float d26 = d22 * d9 + d24 * d10;
                pBuilder.addVertex(d5 + d25, d6 + d23, d7 + d26);
            }
        }
        return pBuilder.build();
    }

    private MeshData drawStars3() {
        RandomSource randomsource = RandomSource.create((long)64094L);
        BufferBuilder pBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        for (int i = 0; i < 1800; ++i) {
            float d0 = randomsource.nextFloat() * 2.0f - 1.0f;
            float d1 = randomsource.nextFloat() * 2.0f - 1.0f;
            float d2 = randomsource.nextFloat() * 2.0f - 1.0f;
            float d3 = 0.15f + randomsource.nextFloat() * 0.1f;
            float d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0f) || !(d4 > 0.01f)) continue;
            d4 = (float)(1.0 / Math.sqrt(d4));
            float d5 = (d0 *= d4) * 100.0f;
            float d6 = (d1 *= d4) * 100.0f;
            float d7 = (d2 *= d4) * 100.0f;
            float d8 = (float)Math.atan2(d0, d2);
            float d9 = (float)Math.sin(d8);
            float d10 = (float)Math.cos(d8);
            float d11 = (float)Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            float d12 = (float)Math.sin(d11);
            float d13 = (float)Math.cos(d11);
            float d14 = (float)((double)randomsource.nextFloat() * Math.PI * 2.0);
            float d15 = (float)Math.sin(d14);
            float d16 = (float)Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                float d18 = (float)((j & 2) - 1) * d3;
                float d19 = (float)((j + 1 & 2) - 1) * d3;
                float d21 = d18 * d16 - d19 * d15;
                float d22 = d19 * d16 + d18 * d15;
                float d23 = d21 * d12 + 0.0f * d13;
                float d24 = 0.0f * d12 - d21 * d13;
                float d25 = d24 * d9 - d22 * d10;
                float d26 = d22 * d9 + d24 * d10;
                pBuilder.addVertex(d5 + d25, d6 + d23, d7 + d26);
            }
        }
        return pBuilder.buildOrThrow();
    }

    @Inject(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderSky(Matrix4f frustumMatrix, Matrix4f pProjectionMatrix, float pPartialTick, Camera camera, boolean isFoggy, Runnable runnable, CallbackInfo info) {
        ResourceKey player_dim = Minecraft.getInstance().level.dimension();
        PoseStack pPoseStack = new PoseStack();
        pPoseStack.mulPose(frustumMatrix);
        if (this.minecraft != null) {
            float starBrightness;
            float f;
            float playerEyeLevel;
            ShaderInstance shaderinstance;
            float f2;
            float f1;
            float f3;
            float rain_det = 0.0f;
            if (player_dim == NorthstarDimensions.MARS_DIM_KEY) {
                info.cancel();
                runnable.run();
                BufferBuilder bufferbuilder = null;
                Vec3 vec3 = this.level.getSkyColor(this.minecraft.gameRenderer.getMainCamera().getPosition(), pPartialTick);
                float playerEyeLevel2 = (float)this.minecraft.player.getEyePosition((float)pPartialTick).y;
                f3 = (float)vec3.x;
                f1 = (float)vec3.y;
                f2 = (float)vec3.z;
                if (playerEyeLevel2 > 400.0f) {
                    f3 = (float)(vec3.x - (double)((playerEyeLevel2 - 400.0f) / 300.0f));
                    f1 = (float)(vec3.y - (double)((playerEyeLevel2 - 400.0f) / 300.0f));
                    f2 = (float)(vec3.z - (double)((playerEyeLevel2 - 400.0f) / 300.0f));
                    this.f_alpha = 1.0f - (playerEyeLevel2 - 400.0f) / 300.0f;
                    if (this.f_alpha < 0.0f) {
                        this.f_alpha = 0.0f;
                    }
                } else {
                    this.f_alpha = 1.0f;
                }
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)f3, (float)f1, (float)f2, (float)this.f_alpha);
                shaderinstance = RenderSystem.getShader();
                this.skyBuffer.bind();
                this.skyBuffer.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, shaderinstance);
                VertexBuffer.unbind();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                float SUN = 20.0f;
                float PD = 15.0f;
                if (!(rain_det <= 0.0f)) {
                    if ((double)this.sc > 0.45) {
                        this.sc = (float)((double)this.sc - 0.01);
                    }
                } else if (!(this.sc <= 1.0f)) {
                    this.sc = (float)((double)this.sc + 0.01);
                }
                RenderSystem.setShaderColor((float)this.sc, (float)this.sc, (float)this.sc, (float)1.0f);
                VertexBuffer.unbind();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                float[] afloat = this.level.effects().getSunriseColor(this.level.getTimeOfDay(pPartialTick), pPartialTick);
                if (afloat != null) {
                    RenderSystem.setShader(GameRenderer::getPositionColorShader);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    pPoseStack.pushPose();
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    float f32 = Mth.sin((float)this.level.getSunAngle(pPartialTick)) < 0.0f ? 180.0f : 0.0f;
                    pPoseStack.mulPose(Axis.ZP.rotationDegrees(f32));
                    pPoseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    float f4 = afloat[0];
                    float f5 = afloat[1];
                    float f6 = afloat[2];
                    Matrix4f matrix4f = pPoseStack.last().pose();
                    bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
                    bufferbuilder.addVertex(matrix4f, 0.0f, 100.0f, 0.0f).setColor(f4, f5, f6, afloat[3]);
                    for (int j = 0; j <= 16; ++j) {
                        float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                        float f8 = Mth.sin((float)f7);
                        float f9 = Mth.cos((float)f7);
                        bufferbuilder.addVertex(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).setColor(afloat[0], afloat[1], afloat[2], 0.0f);
                    }
                    BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                    pPoseStack.popPose();
                }
                pPoseStack.pushPose();
                pPoseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                pPoseStack.mulPose(Axis.XP.rotationDegrees(this.level.getTimeOfDay(pPartialTick) * 360.0f));
                Matrix4f matrix4f1 = pPoseStack.last().pose();
                float rain_det2 = this.minecraft.level.getRainLevel(pPartialTick);
                float f10 = 2.0f;
                if (!(rain_det2 <= 0.0f) && playerEyeLevel2 <= 450.0f) {
                    f10 = 0.0f;
                }
                if (f10 > 0.0f) {
                    RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)f10);
                    FogRenderer.setupNoFog();
                    this.starBuffer.bind();
                    this.starBuffer.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)0.67f);
                    this.starBuffer2.bind();
                    this.starBuffer2.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)0.33f);
                    this.starBuffer3.bind();
                    this.starBuffer3.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    runnable.run();
                }
                float sky_brightness = (float)((double)this.level.getStarBrightness(pPartialTick) * 1.5) * (float)(!this.level.isRaining() || !(playerEyeLevel2 < 450.0f) ? 1 : 0);
                float f11 = 1.0f - this.level.getRainLevel(pPartialTick);
                if (playerEyeLevel2 > 400.0f) {
                    f11 += (playerEyeLevel2 - 400.0f) / 200.0f;
                    f11 = Mth.clamp((float)f11, (float)0.0f, (float)1.0f);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)PHOBOS_DEIMOS);
                bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(matrix4f1, 10.0f + PD, -100.0f, 5.0f + -PD).setUv(0.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, 10.0f + -PD, -100.0f, 5.0f + -PD).setUv(1.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, 10.0f + -PD, -100.0f, 5.0f + PD).setUv(1.0f, 1.0f);
                bufferbuilder.addVertex(matrix4f1, 10.0f + PD, -100.0f, 5.0f + PD).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BARE_SUN);
                bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(matrix4f1, SUN, 100.0f, SUN).setUv(0.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, -SUN, 100.0f, SUN).setUv(1.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, -SUN, 100.0f, -SUN).setUv(1.0f, 1.0f);
                bufferbuilder.addVertex(matrix4f1, SUN, 100.0f, -SUN).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                RenderSystem.setShaderColor((float)sky_brightness, (float)sky_brightness, (float)sky_brightness, (float)1.0f);
                float EF = 3.0f;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)EARTH_FAR);
                bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(matrix4f1, 100.0f, -40.0f + EF, 50.0f + EF).setUv(0.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, 100.0f, -39.0f + EF, 50.0f + -EF).setUv(1.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, 100.0f, -39.0f + -EF, 50.0f + -EF).setUv(1.0f, -1.0f);
                bufferbuilder.addVertex(matrix4f1, 100.0f, -40.0f + -EF, 50.0f + EF).setUv(0.0f, -1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                float MF = 1.5f;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_FAR);
                bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(matrix4f1, 100.0f, -40.0f + MF, 55.0f + MF).setUv(0.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, 100.0f, -39.5f + MF, 55.0f + -MF).setUv(1.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, 100.0f, -39.5f + -MF, 55.0f + -MF).setUv(1.0f, -1.0f);
                bufferbuilder.addVertex(matrix4f1, 100.0f, -40.0f + -MF, 55.0f + MF).setUv(0.0f, -1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                float NS = 2.0f;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)NORTHERN_STAR);
                bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(matrix4f1, -100.0f, -30.0f + NS, -NS).setUv(0.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, -100.0f, -30.0f + NS, NS).setUv(1.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, -100.0f, -30.0f + -NS, NS).setUv(1.0f, 1.0f);
                bufferbuilder.addVertex(matrix4f1, -100.0f, -30.0f + -NS, -NS).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                float VF = 2.0f;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)VENUS_FAR);
                bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(matrix4f1, -58.75f, -30.0f + VF, -80.0f + -VF).setUv(0.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, -60.0f, -29.25f + VF, -80.0f + VF).setUv(1.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, -60.0f, -29.25f + -VF, -80.0f + VF).setUv(1.0f, -1.0f);
                bufferbuilder.addVertex(matrix4f1, -58.75f, -30.0f + -VF, -80.0f + -VF).setUv(0.0f, -1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                RenderSystem.depthMask((boolean)true);
                pPoseStack.popPose();
                pPoseStack.pushPose();
                pPoseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                pPoseStack.mulPose(Axis.XP.rotationDegrees(0.0f));
                float mars_alpha = (playerEyeLevel2 - 400.0f) / 100.0f;
                float mars_dist = (playerEyeLevel2 - 400.0f) / 10.0f;
                if (playerEyeLevel2 > 400.0f) {
                    float MC = 1500.0f;
                    if (playerEyeLevel2 > 650.0f) {
                        RenderSystem.disableBlend();
                    } else {
                        RenderSystem.enableBlend();
                    }
                    Matrix4f matrix4f2 = pPoseStack.last().pose();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)mars_alpha);
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    RenderSystem.setShader(GameRenderer::getPositionTexShader);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)MARS_CLOSE);
                    bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                    bufferbuilder.addVertex(matrix4f2, MC, -100.0f - mars_dist, -MC).setUv(0.0f, 0.0f);
                    bufferbuilder.addVertex(matrix4f2, -MC, -100.0f - mars_dist, -MC).setUv(1.0f, 0.0f);
                    bufferbuilder.addVertex(matrix4f2, -MC, -100.0f - mars_dist, MC).setUv(1.0f, 1.0f);
                    bufferbuilder.addVertex(matrix4f2, MC, -100.0f - mars_dist, MC).setUv(0.0f, 1.0f);
                    BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableBlend();
                pPoseStack.popPose();
            }
            if (player_dim == Level.OVERWORLD && (playerEyeLevel = (float)this.minecraft.player.getEyePosition((float)pPartialTick).y) > 450.0f) {
                info.cancel();
                runnable.run();
                BufferBuilder bufferbuilder3 = null;
                Vec3 vec3 = this.level.getSkyColor(this.minecraft.gameRenderer.getMainCamera().getPosition(), pPartialTick);
                f3 = (float)vec3.x;
                f1 = (float)vec3.y;
                f2 = (float)vec3.z;
                if (playerEyeLevel > 450.0f) {
                    f3 = (float)(vec3.x - (double)((playerEyeLevel - 450.0f) / 300.0f));
                    f1 = (float)(vec3.y - (double)((playerEyeLevel - 450.0f) / 300.0f));
                    f2 = (float)(vec3.z - (double)((playerEyeLevel - 450.0f) / 300.0f));
                    this.f_alpha = 1.0f - (playerEyeLevel - 450.0f) / 300.0f;
                    if (this.f_alpha < 0.0f) {
                        this.f_alpha = 0.0f;
                    }
                } else {
                    this.f_alpha = 1.0f;
                }
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)f3, (float)f1, (float)f2, (float)this.f_alpha);
                shaderinstance = RenderSystem.getShader();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                this.skyBuffer.bind();
                this.skyBuffer.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, shaderinstance);
                VertexBuffer.unbind();
                pPoseStack.pushPose();
                pPoseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                pPoseStack.mulPose(Axis.XP.rotationDegrees(this.level.getTimeOfDay(pPartialTick) * 360.0f));
                Matrix4f matrix4f3 = pPoseStack.last().pose();
                float f10 = this.level.getStarBrightness(pPartialTick);
                float starBrightness2 = f10 > 0.0f ? -(f10 - (playerEyeLevel - 300.0f) / 100.0f) : (playerEyeLevel - 450.0f) / 200.0f;
                float starBrightness22 = f10 > 0.0f ? (playerEyeLevel - 450.0f) / 200.0f : (playerEyeLevel - 600.0f) / 200.0f;
                float starBrightness3 = f10 > 0.0f ? (playerEyeLevel - 600.0f) / 300.0f : (playerEyeLevel - 700.0f) / 200.0f;
                starBrightness22 = Mth.clamp((float)starBrightness22, (float)0.0f, (float)0.67f);
                starBrightness3 = Mth.clamp((float)starBrightness22, (float)0.0f, (float)0.33f);
                if (starBrightness2 > 0.0f) {
                    RenderSystem.setShaderColor((float)starBrightness2, (float)starBrightness2, (float)starBrightness2, (float)(starBrightness2 / 2.0f));
                    FogRenderer.setupNoFog();
                    this.starBuffer.bind();
                    this.starBuffer.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    RenderSystem.setShaderColor((float)starBrightness2, (float)starBrightness2, (float)starBrightness2, (float)starBrightness22);
                    this.starBuffer2.bind();
                    this.starBuffer2.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    RenderSystem.setShaderColor((float)starBrightness2, (float)starBrightness2, (float)starBrightness2, (float)starBrightness3);
                    this.starBuffer3.bind();
                    this.starBuffer3.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    runnable.run();
                }
                BufferBuilder bufferbuilder_earth_sky = null;
                Matrix4f matrix4f_earth_sky = pPoseStack.last().pose();
                float earth_sky_planet_brightness = (float)((double)this.level.getStarBrightness(pPartialTick) * 1.5) * (float)(!this.level.isRaining() || !(playerEyeLevel < 450.0f) ? 1 : 0);
                float northstar_brightness = earth_sky_planet_brightness * 2.0f;
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.depthMask((boolean)true);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                float NS = 2.0f;
                RenderSystem.setShaderColor((float)northstar_brightness, (float)northstar_brightness, (float)northstar_brightness, (float)northstar_brightness);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)NORTHERN_STAR);
                bufferbuilder_earth_sky = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, -100.0f, -30.0f + NS, -NS).setUv(0.0f, 0.0f);
                bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, -100.0f, -30.0f + NS, NS).setUv(1.0f, 0.0f);
                bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, -100.0f, -30.0f + -NS, NS).setUv(1.0f, 1.0f);
                bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, -100.0f, -30.0f + -NS, -NS).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder_earth_sky.buildOrThrow());
                if (playerEyeLevel >= 450.0f) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    RenderSystem.setShaderColor((float)earth_sky_planet_brightness, (float)earth_sky_planet_brightness, (float)earth_sky_planet_brightness, (float)earth_sky_planet_brightness);
                }
                float VF = 2.0f;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)VENUS_FAR);
                bufferbuilder_earth_sky = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, 100.0f, -40.0f + VF, 50.0f + VF).setUv(0.0f, 0.0f);
                bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, 100.0f, -39.4f + VF, 50.0f + -VF).setUv(1.0f, 0.0f);
                bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, 100.0f, -39.4f + -VF, 50.0f + -VF).setUv(1.0f, -1.0f);
                bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, 100.0f, -40.0f + -VF, 50.0f + VF).setUv(0.0f, -1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder_earth_sky.buildOrThrow());
                float MVF = 1.0f;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)MARS_VERY_FAR);
                bufferbuilder_earth_sky = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, -59.25f, -30.0f + MVF, -80.0f + -MVF).setUv(0.0f, 0.0f);
                bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, -60.0f, -29.65f + MVF, -80.0f + MVF).setUv(1.0f, 0.0f);
                bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, -60.0f, -29.65f + -MVF, -80.0f + MVF).setUv(1.0f, -1.0f);
                bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, -59.25f, -30.0f + -MVF, -80.0f + -MVF).setUv(0.0f, -1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder_earth_sky.buildOrThrow());
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                float f11 = 1.0f - this.level.getRainLevel(pPartialTick);
                if (playerEyeLevel > 400.0f) {
                    f11 += (playerEyeLevel - 400.0f) / 200.0f;
                    f11 = Mth.clamp((float)f11, (float)0.0f, (float)1.0f);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
                float f12 = 30.0f;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BARE_SUN);
                bufferbuilder3 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder3.addVertex(matrix4f3, -f12, 100.0f, -f12).setUv(0.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, f12, 100.0f, -f12).setUv(1.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, f12, 100.0f, f12).setUv(1.0f, 1.0f);
                bufferbuilder3.addVertex(matrix4f3, -f12, 100.0f, f12).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder3.buildOrThrow());
                f12 = 20.0f;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_LOC);
                int k = this.level.getMoonPhase();
                int l = k % 4;
                int i1 = k / 4 % 2;
                float f13 = (float)(l + 0) / 4.0f;
                float f14 = (float)(i1 + 0) / 2.0f;
                float f15 = (float)(l + 1) / 4.0f;
                float f16 = (float)(i1 + 1) / 2.0f;
                bufferbuilder3 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder3.addVertex(matrix4f3, -f12, -100.0f, f12).setUv(f15, f16);
                bufferbuilder3.addVertex(matrix4f3, f12, -100.0f, f12).setUv(f13, f16);
                bufferbuilder3.addVertex(matrix4f3, f12, -100.0f, -f12).setUv(f13, f14);
                bufferbuilder3.addVertex(matrix4f3, -f12, -100.0f, -f12).setUv(f15, f14);
                BufferUploader.drawWithShader((MeshData)bufferbuilder3.buildOrThrow());
                RenderSystem.enableDepthTest();
                pPoseStack.popPose();
                float earth_alpha = (playerEyeLevel - 450.0f) / 300.0f;
                float earth_dist = (playerEyeLevel - 450.0f) / 10.0f;
                if (playerEyeLevel > 450.0f) {
                    if (earth_alpha >= 1.0f) {
                        RenderSystem.disableBlend();
                    } else {
                        RenderSystem.enableBlend();
                    }
                    float EC = 2000.0f;
                    pPoseStack.pushPose();
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(0.0f));
                    Matrix4f matrix4f2 = pPoseStack.last().pose();
                    BufferBuilder bufferbuilder2 = null;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)earth_alpha);
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    RenderSystem.setShader(GameRenderer::getPositionTexShader);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)EARTH_CLOSE);
                    bufferbuilder2 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                    bufferbuilder2.addVertex(matrix4f2, EC, -100.0f - earth_dist, -EC).setUv(0.0f, 0.0f);
                    bufferbuilder2.addVertex(matrix4f2, -EC, -100.0f - earth_dist, -EC).setUv(1.0f, 0.0f);
                    bufferbuilder2.addVertex(matrix4f2, -EC, -100.0f - earth_dist, EC).setUv(1.0f, -1.0f);
                    bufferbuilder2.addVertex(matrix4f2, EC, -100.0f - earth_dist, EC).setUv(0.0f, -1.0f);
                    BufferUploader.drawWithShader((MeshData)bufferbuilder2.buildOrThrow());
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableBlend();
                pPoseStack.popPose();
            }
            if (player_dim == NorthstarDimensions.VENUS_DIM_KEY) {
                info.cancel();
                runnable.run();
                BufferBuilder bufferbuilder = null;
                float time = this.level.getTimeOfDay(pPartialTick);
                float skydarken = Mth.cos((float)(time * ((float)Math.PI * 2))) * 2.0f + 0.5f;
                Vec3 skycolor = new Vec3(1.0, (double)0.874f, (double)0.336f);
                skydarken = Mth.clamp((float)skydarken, (float)0.125f, (float)1.0f);
                float playerEyeLevel3 = (float)this.minecraft.player.getEyePosition((float)pPartialTick).y;
                float f4 = (float)skycolor.x * skydarken;
                float f12 = (float)skycolor.y * skydarken;
                float f22 = (float)skycolor.z * skydarken;
                if (playerEyeLevel3 > 600.0f) {
                    f4 = (float)(skycolor.x - (double)((playerEyeLevel3 - 600.0f) / 300.0f));
                    f12 = (float)(skycolor.y - (double)((playerEyeLevel3 - 600.0f) / 300.0f));
                    f22 = (float)(skycolor.z - (double)((playerEyeLevel3 - 600.0f) / 300.0f));
                    this.f_alpha = 1.0f - (playerEyeLevel3 - 600.0f) / 300.0f;
                    if (this.f_alpha < 0.0f) {
                        this.f_alpha = 0.0f;
                    }
                } else {
                    this.f_alpha = 1.0f;
                }
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)f4, (float)f12, (float)f22, (float)this.f_alpha);
                ShaderInstance shaderinstance2 = RenderSystem.getShader();
                this.skyBuffer.bind();
                this.skyBuffer.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, shaderinstance2);
                VertexBuffer.unbind();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                float SUN = 30.0f;
                if (!(rain_det <= 0.0f)) {
                    if ((double)this.sc > 0.45) {
                        this.sc = (float)((double)this.sc - 0.01);
                    }
                } else if (!(this.sc <= 1.0f)) {
                    this.sc = (float)((double)this.sc + 0.01);
                }
                RenderSystem.setShaderColor((float)this.sc, (float)this.sc, (float)this.sc, (float)1.0f);
                VertexBuffer.unbind();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                float[] afloat = this.level.effects().getSunriseColor(this.level.getTimeOfDay(pPartialTick), pPartialTick);
                if (afloat != null) {
                    RenderSystem.setShader(GameRenderer::getPositionColorShader);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    pPoseStack.pushPose();
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    float f33 = Mth.sin((float)this.level.getSunAngle(pPartialTick)) < 0.0f ? 180.0f : 0.0f;
                    pPoseStack.mulPose(Axis.ZP.rotationDegrees(f33));
                    pPoseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                    float f42 = afloat[0];
                    float f5 = afloat[1];
                    float f6 = afloat[2];
                    Matrix4f matrix4f = pPoseStack.last().pose();
                    bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
                    bufferbuilder.addVertex(matrix4f, 0.0f, 100.0f, 0.0f).setColor(f42, f5, f6, afloat[3]);
                    for (int j = 0; j <= 16; ++j) {
                        float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                        float f8 = Mth.sin((float)f7);
                        float f9 = Mth.cos((float)f7);
                        bufferbuilder.addVertex(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).setColor(afloat[0], afloat[1], afloat[2], 0.0f);
                    }
                    BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                    pPoseStack.popPose();
                }
                pPoseStack.pushPose();
                pPoseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                pPoseStack.mulPose(Axis.XP.rotationDegrees(this.level.getTimeOfDay(pPartialTick) * 360.0f));
                Matrix4f matrix4f1 = pPoseStack.last().pose();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BLURRED_SUN);
                bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(matrix4f1, SUN, 100.0f, SUN).setUv(0.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, -SUN, 100.0f, SUN).setUv(1.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, -SUN, 100.0f, -SUN).setUv(1.0f, 1.0f);
                bufferbuilder.addVertex(matrix4f1, SUN, 100.0f, -SUN).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                float sun_alpha = (playerEyeLevel3 - 600.0f) / 300.0f;
                sun_alpha = Mth.clamp((float)sun_alpha, (float)0.0f, (float)1.0f);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)sun_alpha);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BARE_SUN);
                bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(matrix4f1, SUN, 100.0f, SUN).setUv(0.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, -SUN, 100.0f, SUN).setUv(1.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, -SUN, 100.0f, -SUN).setUv(1.0f, 1.0f);
                bufferbuilder.addVertex(matrix4f1, SUN, 100.0f, -SUN).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                float f11 = 0.5f - this.level.getRainLevel(pPartialTick);
                float f10 = this.level.getStarBrightness(pPartialTick) * f11;
                float starHeight = (playerEyeLevel3 - 600.0f) / 300.0f;
                if (!(playerEyeLevel3 <= 600.0f)) {
                    f10 += starHeight;
                }
                float starBrightness3 = (f10 = Mth.clamp((float)f10, (float)0.0f, (float)2.0f)) > 0.0f ? (playerEyeLevel3 - 650.0f) / 100.0f : (playerEyeLevel3 - 675.0f) / 200.0f;
                float starBrightness2 = f10 > 0.0f ? (playerEyeLevel3 - 750.0f) / 200.0f : (playerEyeLevel3 - 750.0f) / 200.0f;
                float starBrightness32 = f10 > 0.0f ? (playerEyeLevel3 - 850.0f) / 300.0f : (playerEyeLevel3 - 850.0f) / 200.0f;
                starBrightness2 = Mth.clamp((float)starBrightness2, (float)0.0f, (float)0.67f);
                starBrightness32 = Mth.clamp((float)starBrightness2, (float)0.0f, (float)0.33f);
                if (f10 > 0.0f) {
                    RenderSystem.setShaderColor((float)starBrightness3, (float)starBrightness3, (float)starBrightness3, (float)starBrightness3);
                    FogRenderer.setupNoFog();
                    this.starBuffer.bind();
                    this.starBuffer.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    RenderSystem.setShaderColor((float)starBrightness3, (float)starBrightness3, (float)starBrightness3, (float)starBrightness2);
                    this.starBuffer2.bind();
                    this.starBuffer2.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    RenderSystem.setShaderColor((float)starBrightness3, (float)starBrightness3, (float)starBrightness3, (float)starBrightness32);
                    this.starBuffer3.bind();
                    this.starBuffer3.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    runnable.run();
                    runnable.run();
                }
                float planetBrightness = Mth.clamp((float)starBrightness3, (float)0.0f, (float)1.0f);
                RenderSystem.setShaderColor((float)planetBrightness, (float)planetBrightness, (float)planetBrightness, (float)planetBrightness);
                float EF = 3.0f;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)EARTH_FAR);
                bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(matrix4f1, 100.0f, -40.0f + EF, 50.0f + EF).setUv(0.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, 100.0f, -39.0f + EF, 50.0f + -EF).setUv(1.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, 100.0f, -39.0f + -EF, 50.0f + -EF).setUv(1.0f, -1.0f);
                bufferbuilder.addVertex(matrix4f1, 100.0f, -40.0f + -EF, 50.0f + EF).setUv(0.0f, -1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                float NS = 2.0f;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)NORTHERN_STAR);
                bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(matrix4f1, -100.0f, -30.0f + NS, -NS).setUv(0.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, -100.0f, -30.0f + NS, NS).setUv(1.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, -100.0f, -30.0f + -NS, NS).setUv(1.0f, 1.0f);
                bufferbuilder.addVertex(matrix4f1, -100.0f, -30.0f + -NS, -NS).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                float MVF = 1.0f;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)MARS_VERY_FAR);
                bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(matrix4f1, -59.25f, -30.0f + MVF, -80.0f + -MVF).setUv(0.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, -60.0f, -29.65f + MVF, -80.0f + MVF).setUv(1.0f, 0.0f);
                bufferbuilder.addVertex(matrix4f1, -60.0f, -29.65f + -MVF, -80.0f + MVF).setUv(1.0f, -1.0f);
                bufferbuilder.addVertex(matrix4f1, -59.25f, -30.0f + -MVF, -80.0f + -MVF).setUv(0.0f, -1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                RenderSystem.depthMask((boolean)true);
                pPoseStack.popPose();
                pPoseStack.pushPose();
                pPoseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                pPoseStack.mulPose(Axis.XP.rotationDegrees(0.0f));
                float venus_alpha = (playerEyeLevel3 - 600.0f) / 150.0f;
                float venus_dist = (playerEyeLevel3 - 600.0f) / 10.0f;
                if (playerEyeLevel3 > 600.0f) {
                    float VC = 2000.0f;
                    if (playerEyeLevel3 > 750.0f) {
                        RenderSystem.disableBlend();
                    } else {
                        RenderSystem.enableBlend();
                    }
                    Matrix4f matrix4f2 = pPoseStack.last().pose();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)venus_alpha);
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    RenderSystem.setShader(GameRenderer::getPositionTexShader);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)VENUS_CLOSE);
                    bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                    bufferbuilder.addVertex(matrix4f2, VC, -100.0f - venus_dist, -VC).setUv(0.0f, 0.0f);
                    bufferbuilder.addVertex(matrix4f2, -VC, -100.0f - venus_dist, -VC).setUv(1.0f, 0.0f);
                    bufferbuilder.addVertex(matrix4f2, -VC, -100.0f - venus_dist, VC).setUv(1.0f, 1.0f);
                    bufferbuilder.addVertex(matrix4f2, VC, -100.0f - venus_dist, VC).setUv(0.0f, 1.0f);
                    BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableBlend();
                pPoseStack.popPose();
            }
            if (player_dim == NorthstarDimensions.MOON_DIM_KEY) {
                float playerEyeLevel4 = (float)this.minecraft.player.getEyePosition((float)pPartialTick).y;
                info.cancel();
                runnable.run();
                BufferBuilder bufferbuilder3 = null;
                f = 0.0f;
                float f13 = 0.0f;
                float f23 = 0.0f;
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)f, (float)f13, (float)f23, (float)this.f_alpha);
                ShaderInstance shaderinstance3 = RenderSystem.getShader();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                this.skyBuffer.bind();
                this.skyBuffer.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, shaderinstance3);
                VertexBuffer.unbind();
                pPoseStack.pushPose();
                pPoseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                pPoseStack.mulPose(Axis.XP.rotationDegrees(this.level.getTimeOfDay(pPartialTick) * 360.0f));
                Matrix4f matrix4f3 = pPoseStack.last().pose();
                float f10 = 2.0f;
                starBrightness = f10 > 0.0f ? -(f10 - playerEyeLevel4 - 300.0f) / 100.0f : (playerEyeLevel4 - 450.0f) / 200.0f;
                if (starBrightness > 0.0f) {
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)starBrightness);
                    FogRenderer.setupNoFog();
                    this.starBuffer.bind();
                    this.starBuffer.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)0.67f);
                    this.starBuffer2.bind();
                    this.starBuffer2.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)0.33f);
                    this.starBuffer3.bind();
                    this.starBuffer3.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    runnable.run();
                }
                float NS = 2.0f;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)NORTHERN_STAR);
                bufferbuilder3 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder3.addVertex(matrix4f3, -100.0f, -30.0f + NS, -NS).setUv(0.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, -100.0f, -30.0f + NS, NS).setUv(1.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, -100.0f, -30.0f + -NS, NS).setUv(1.0f, 1.0f);
                bufferbuilder3.addVertex(matrix4f3, -100.0f, -30.0f + -NS, -NS).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder3.buildOrThrow());
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int VF = 2;
                int MVF = 1;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)VENUS_FAR);
                bufferbuilder3 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder3.addVertex(matrix4f3, 100.0f, -40.0f + (float)VF, (float)(50 + VF)).setUv(0.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, 100.0f, -39.4f + (float)VF, (float)(50 + -VF)).setUv(1.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, 100.0f, -39.4f + (float)(-VF), (float)(50 + -VF)).setUv(1.0f, -1.0f);
                bufferbuilder3.addVertex(matrix4f3, 100.0f, -40.0f + (float)(-VF), (float)(50 + VF)).setUv(0.0f, -1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder3.buildOrThrow());
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)MARS_VERY_FAR);
                bufferbuilder3 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder3.addVertex(matrix4f3, -59.25f, -30.0f + (float)MVF, (float)(-80 + -MVF)).setUv(0.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, -60.0f, -29.65f + (float)MVF, (float)(-80 + MVF)).setUv(1.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, -60.0f, -29.65f + (float)(-MVF), (float)(-80 + MVF)).setUv(1.0f, -1.0f);
                bufferbuilder3.addVertex(matrix4f3, -59.25f, -30.0f + (float)(-MVF), (float)(-80 + -MVF)).setUv(0.0f, -1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder3.buildOrThrow());
                pPoseStack.popPose();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                float f11 = 1.0f - this.level.getRainLevel(pPartialTick);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float f12 = 30.0f;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BARE_SUN);
                bufferbuilder3 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder3.addVertex(matrix4f3, -f12, 100.0f, -f12).setUv(0.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, f12, 100.0f, -f12).setUv(1.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, f12, 100.0f, f12).setUv(1.0f, 1.0f);
                bufferbuilder3.addVertex(matrix4f3, -f12, 100.0f, f12).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder3.buildOrThrow());
                RenderSystem.disableBlend();
                pPoseStack.pushPose();
                pPoseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                pPoseStack.mulPose(Axis.XP.rotationDegrees(-135.0f));
                Matrix4f matrix4f2 = pPoseStack.last().pose();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                float earth_sky_dist = 35.0f;
                float ECS = 45.0f;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)EARTH_CLOSE);
                bufferbuilder3 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder3.addVertex(matrix4f2, ECS, -100.0f - earth_sky_dist, -ECS).setUv(0.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f2, -ECS, -100.0f - earth_sky_dist, -ECS).setUv(1.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f2, -ECS, -100.0f - earth_sky_dist, ECS).setUv(1.0f, -1.0f);
                bufferbuilder3.addVertex(matrix4f2, ECS, -100.0f - earth_sky_dist, ECS).setUv(0.0f, -1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder3.buildOrThrow());
                pPoseStack.popPose();
                RenderSystem.depthMask((boolean)true);
                f12 = 20.0f;
                float earth_alpha = (playerEyeLevel4 - 450.0f) / 300.0f;
                float earth_dist = (playerEyeLevel4 - 450.0f) / 10.0f;
                if (playerEyeLevel4 > 450.0f) {
                    if (earth_alpha >= 1.0f) {
                        RenderSystem.disableBlend();
                    } else {
                        RenderSystem.enableBlend();
                    }
                    float EC = 2000.0f;
                    pPoseStack.pushPose();
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(0.0f));
                    matrix4f2 = pPoseStack.last().pose();
                    BufferBuilder bufferbuilder2 = null;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)earth_alpha);
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    RenderSystem.setShader(GameRenderer::getPositionTexShader);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_CLOSE);
                    bufferbuilder2 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                    bufferbuilder2.addVertex(matrix4f2, EC, -100.0f - earth_dist, -EC).setUv(0.0f, 0.0f);
                    bufferbuilder2.addVertex(matrix4f2, -EC, -100.0f - earth_dist, -EC).setUv(1.0f, 0.0f);
                    bufferbuilder2.addVertex(matrix4f2, -EC, -100.0f - earth_dist, EC).setUv(1.0f, -1.0f);
                    bufferbuilder2.addVertex(matrix4f2, EC, -100.0f - earth_dist, EC).setUv(0.0f, -1.0f);
                    BufferUploader.drawWithShader((MeshData)bufferbuilder2.buildOrThrow());
                    pPoseStack.popPose();
                    RenderSystem.depthMask((boolean)true);
                }
                RenderSystem.depthMask((boolean)true);
            }
            if (player_dim == null) {
                float playerEyeLevel5 = (float)this.minecraft.player.getEyePosition((float)pPartialTick).y;
                info.cancel();
                runnable.run();
                float f5 = 0.0f;
                float f14 = 0.0f;
                float f24 = 0.0f;
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)f5, (float)f14, (float)f24, (float)this.f_alpha);
                ShaderInstance shaderinstance4 = RenderSystem.getShader();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                this.skyBuffer.bind();
                this.skyBuffer.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, shaderinstance4);
                VertexBuffer.unbind();
                pPoseStack.pushPose();
                pPoseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                pPoseStack.mulPose(Axis.XP.rotationDegrees(this.level.getTimeOfDay(pPartialTick) * 360.0f));
                float f10 = 2.0f;
                float starBrightness4 = f10 > 0.0f ? -(f10 - playerEyeLevel5 - 300.0f) / 100.0f : (playerEyeLevel5 - 450.0f) / 200.0f;
                if (starBrightness4 > 0.0f) {
                    RenderSystem.setShaderColor((float)starBrightness4, (float)starBrightness4, (float)starBrightness4, (float)starBrightness4);
                    FogRenderer.setupNoFog();
                    this.starBuffer.bind();
                    this.starBuffer.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    RenderSystem.setShaderColor((float)starBrightness4, (float)starBrightness4, (float)starBrightness4, (float)0.67f);
                    this.starBuffer2.bind();
                    this.starBuffer2.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    RenderSystem.setShaderColor((float)starBrightness4, (float)starBrightness4, (float)starBrightness4, (float)0.33f);
                    this.starBuffer3.bind();
                    this.starBuffer3.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    runnable.run();
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (player_dim == NorthstarDimensions.EARTH_ORBIT_DIM_KEY) {
                float playerEyeLevel6 = (float)this.minecraft.player.getEyePosition((float)pPartialTick).y;
                info.cancel();
                runnable.run();
                BufferBuilder bufferbuilder3 = null;
                f = 0.0f;
                float f15 = 0.0f;
                float f25 = 0.0f;
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)f, (float)f15, (float)f25, (float)this.f_alpha);
                ShaderInstance shaderinstance5 = RenderSystem.getShader();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                this.skyBuffer.bind();
                this.skyBuffer.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, shaderinstance5);
                VertexBuffer.unbind();
                pPoseStack.pushPose();
                pPoseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                pPoseStack.mulPose(Axis.XP.rotationDegrees(this.level.getTimeOfDay(pPartialTick) * 360.0f));
                Matrix4f matrix4f3 = pPoseStack.last().pose();
                float f10 = 2.0f;
                starBrightness = f10 > 0.0f ? -(f10 - playerEyeLevel6 - 300.0f) / 100.0f : (playerEyeLevel6 - 450.0f) / 200.0f;
                if (starBrightness > 0.0f) {
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)starBrightness);
                    FogRenderer.setupNoFog();
                    this.starBuffer.bind();
                    this.starBuffer.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)0.67f);
                    this.starBuffer2.bind();
                    this.starBuffer2.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)0.33f);
                    this.starBuffer3.bind();
                    this.starBuffer3.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    runnable.run();
                }
                float NS = 2.0f;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)NORTHERN_STAR);
                bufferbuilder3 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder3.addVertex(matrix4f3, -100.0f, -30.0f + NS, -NS).setUv(0.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, -100.0f, -30.0f + NS, NS).setUv(1.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, -100.0f, -30.0f + -NS, NS).setUv(1.0f, 1.0f);
                bufferbuilder3.addVertex(matrix4f3, -100.0f, -30.0f + -NS, -NS).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder3.buildOrThrow());
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int VF = 2;
                int MVF = 1;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)VENUS_FAR);
                bufferbuilder3 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder3.addVertex(matrix4f3, 100.0f, -40.0f + (float)VF, (float)(50 + VF)).setUv(0.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, 100.0f, -39.4f + (float)VF, (float)(50 + -VF)).setUv(1.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, 100.0f, -39.4f + (float)(-VF), (float)(50 + -VF)).setUv(1.0f, -1.0f);
                bufferbuilder3.addVertex(matrix4f3, 100.0f, -40.0f + (float)(-VF), (float)(50 + VF)).setUv(0.0f, -1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder3.buildOrThrow());
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)MARS_VERY_FAR);
                bufferbuilder3 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder3.addVertex(matrix4f3, -59.25f, -30.0f + (float)MVF, (float)(-80 + -MVF)).setUv(0.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, -60.0f, -29.65f + (float)MVF, (float)(-80 + MVF)).setUv(1.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, -60.0f, -29.65f + (float)(-MVF), (float)(-80 + MVF)).setUv(1.0f, -1.0f);
                bufferbuilder3.addVertex(matrix4f3, -59.25f, -30.0f + (float)(-MVF), (float)(-80 + -MVF)).setUv(0.0f, -1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder3.buildOrThrow());
                pPoseStack.popPose();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                float f11 = 1.0f - this.level.getRainLevel(pPartialTick);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
                float f12 = 30.0f;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BARE_SUN);
                bufferbuilder3 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder3.addVertex(matrix4f3, -f12, 100.0f, -f12).setUv(0.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, f12, 100.0f, -f12).setUv(1.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, f12, 100.0f, f12).setUv(1.0f, 1.0f);
                bufferbuilder3.addVertex(matrix4f3, -f12, 100.0f, f12).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder3.buildOrThrow());
                RenderSystem.disableBlend();
                f12 = 20.0f;
                float earth_dist = 175.0f;
                float EC = 2000.0f;
                Matrix4f matrix4f2 = pPoseStack.last().pose();
                pPoseStack.pushPose();
                pPoseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                pPoseStack.mulPose(Axis.XP.rotationDegrees(0.0f));
                matrix4f2 = pPoseStack.last().pose();
                BufferBuilder bufferbuilder2 = null;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)EARTH_CLOSE);
                bufferbuilder2 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder2.addVertex(matrix4f2, EC, -100.0f - earth_dist, -EC).setUv(0.0f, 0.0f);
                bufferbuilder2.addVertex(matrix4f2, -EC, -100.0f - earth_dist, -EC).setUv(1.0f, 0.0f);
                bufferbuilder2.addVertex(matrix4f2, -EC, -100.0f - earth_dist, EC).setUv(1.0f, -1.0f);
                bufferbuilder2.addVertex(matrix4f2, EC, -100.0f - earth_dist, EC).setUv(0.0f, -1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder2.buildOrThrow());
                pPoseStack.popPose();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.depthMask((boolean)true);
            }
            if (player_dim == NorthstarDimensions.MERCURY_DIM_KEY) {
                float playerEyeLevel7 = (float)this.minecraft.player.getEyePosition((float)pPartialTick).y;
                info.cancel();
                runnable.run();
                BufferBuilder bufferbuilder3 = null;
                f = 0.0f;
                float f16 = 0.0f;
                float f26 = 0.0f;
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)f, (float)f16, (float)f26, (float)this.f_alpha);
                ShaderInstance shaderinstance6 = RenderSystem.getShader();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                this.skyBuffer.bind();
                this.skyBuffer.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, shaderinstance6);
                VertexBuffer.unbind();
                pPoseStack.pushPose();
                pPoseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                pPoseStack.mulPose(Axis.XP.rotationDegrees(this.level.getTimeOfDay(pPartialTick) * 360.0f));
                Matrix4f matrix4f3 = pPoseStack.last().pose();
                float f10 = 2.0f;
                starBrightness = f10 > 0.0f ? -(f10 - playerEyeLevel7 - 300.0f) / 100.0f : (playerEyeLevel7 - 450.0f) / 200.0f;
                if (starBrightness > 0.0f) {
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)starBrightness);
                    FogRenderer.setupNoFog();
                    this.starBuffer.bind();
                    this.starBuffer.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)0.67f);
                    this.starBuffer2.bind();
                    this.starBuffer2.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)0.33f);
                    this.starBuffer3.bind();
                    this.starBuffer3.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    runnable.run();
                }
                float NS = 2.0f;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)NORTHERN_STAR);
                bufferbuilder3 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder3.addVertex(matrix4f3, -100.0f, -30.0f + NS, -NS).setUv(0.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, -100.0f, -30.0f + NS, NS).setUv(1.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, -100.0f, -30.0f + -NS, NS).setUv(1.0f, 1.0f);
                bufferbuilder3.addVertex(matrix4f3, -100.0f, -30.0f + -NS, -NS).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder3.buildOrThrow());
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int VF = 2;
                int EF = 2;
                int SUN = 80;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)VENUS_FAR);
                bufferbuilder3 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder3.addVertex(matrix4f3, 100.0f, -40.0f + (float)VF, (float)(50 + VF)).setUv(0.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, 100.0f, -39.4f + (float)VF, (float)(50 + -VF)).setUv(1.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, 100.0f, -39.4f + (float)(-VF), (float)(50 + -VF)).setUv(1.0f, -1.0f);
                bufferbuilder3.addVertex(matrix4f3, 100.0f, -40.0f + (float)(-VF), (float)(50 + VF)).setUv(0.0f, -1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder3.buildOrThrow());
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)EARTH_FAR);
                bufferbuilder3 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder3.addVertex(matrix4f3, -58.0f, -30.0f + (float)EF, (float)(-80 + -EF)).setUv(0.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, -60.0f, -29.65f + (float)EF, (float)(-80 + EF)).setUv(1.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, -60.0f, -29.65f + (float)(-EF), (float)(-80 + EF)).setUv(1.0f, -1.0f);
                bufferbuilder3.addVertex(matrix4f3, -58.0f, -30.0f + (float)(-EF), (float)(-80 + -EF)).setUv(0.0f, -1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder3.buildOrThrow());
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BARE_SUN);
                bufferbuilder3 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder3.addVertex(matrix4f3, (float)SUN, 100.0f, (float)SUN).setUv(0.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, (float)(-SUN), 100.0f, (float)SUN).setUv(1.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, (float)(-SUN), 100.0f, (float)(-SUN)).setUv(1.0f, 1.0f);
                bufferbuilder3.addVertex(matrix4f3, (float)SUN, 100.0f, (float)(-SUN)).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder3.buildOrThrow());
                pPoseStack.popPose();
                RenderSystem.depthMask((boolean)true);
                float f11 = 1.0f - this.level.getRainLevel(pPartialTick);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
                float f12 = 30.0f;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BARE_SUN);
                bufferbuilder3 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder3.addVertex(matrix4f3, -f12, 100.0f, -f12).setUv(0.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, f12, 100.0f, -f12).setUv(1.0f, 0.0f);
                bufferbuilder3.addVertex(matrix4f3, f12, 100.0f, f12).setUv(1.0f, 1.0f);
                bufferbuilder3.addVertex(matrix4f3, -f12, 100.0f, f12).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)bufferbuilder3.buildOrThrow());
                RenderSystem.disableBlend();
                Matrix4f matrix4f2 = pPoseStack.last().pose();
                f12 = 20.0f;
                float earth_alpha = (playerEyeLevel7 - 450.0f) / 300.0f;
                float earth_dist = (playerEyeLevel7 - 450.0f) / 10.0f;
                if (playerEyeLevel7 > 450.0f) {
                    if (earth_alpha >= 1.0f) {
                        RenderSystem.disableBlend();
                    } else {
                        RenderSystem.enableBlend();
                    }
                    float EC = 2000.0f;
                    pPoseStack.pushPose();
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(0.0f));
                    matrix4f2 = pPoseStack.last().pose();
                    BufferBuilder bufferbuilder2 = null;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)earth_alpha);
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    RenderSystem.setShader(GameRenderer::getPositionTexShader);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)MERCURY_CLOSE);
                    bufferbuilder2 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                    bufferbuilder2.addVertex(matrix4f2, EC, -100.0f - earth_dist, -EC).setUv(0.0f, 0.0f);
                    bufferbuilder2.addVertex(matrix4f2, -EC, -100.0f - earth_dist, -EC).setUv(1.0f, 0.0f);
                    bufferbuilder2.addVertex(matrix4f2, -EC, -100.0f - earth_dist, EC).setUv(1.0f, -1.0f);
                    bufferbuilder2.addVertex(matrix4f2, EC, -100.0f - earth_dist, EC).setUv(0.0f, -1.0f);
                    BufferUploader.drawWithShader((MeshData)bufferbuilder2.buildOrThrow());
                    pPoseStack.popPose();
                    RenderSystem.depthMask((boolean)true);
                }
                RenderSystem.depthMask((boolean)true);
            }
        }
    }

    @Inject(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, at={@At(value="TAIL")}, cancellable=true)
    private void renderSky2(Matrix4f frustumMatrix, Matrix4f projectionMatrix, float pPartialTick, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo ci) {
        if (this.minecraft == null) {
            return;
        }
        ResourceKey player_dim = Minecraft.getInstance().level.dimension();
        if (player_dim != Level.OVERWORLD) {
            return;
        }
        float playerEyeLevel = (float)this.minecraft.player.getEyePosition((float)pPartialTick).y;
        PoseStack pPoseStack = new PoseStack();
        pPoseStack.mulPose(frustumMatrix);
        pPoseStack.pushPose();
        pPoseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        pPoseStack.mulPose(Axis.XP.rotationDegrees(this.level.getTimeOfDay(pPartialTick) * 360.0f));
        Matrix4f matrix4f_earth_sky = pPoseStack.last().pose();
        float earth_sky_planet_brightness = (float)((double)this.level.getStarBrightness(pPartialTick) * 1.5) * (float)(!this.level.isRaining() || !(playerEyeLevel < 450.0f) ? 1 : 0);
        float northstar_brightness = earth_sky_planet_brightness * 2.0f;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float NS = 2.0f;
        RenderSystem.setShaderColor((float)northstar_brightness, (float)northstar_brightness, (float)northstar_brightness, (float)northstar_brightness);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)NORTHERN_STAR);
        BufferBuilder bufferbuilder_earth_sky = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, -100.0f, -30.0f + NS, -NS).setUv(0.0f, 0.0f);
        bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, -100.0f, -30.0f + NS, NS).setUv(1.0f, 0.0f);
        bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, -100.0f, -30.0f + -NS, NS).setUv(1.0f, 1.0f);
        bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, -100.0f, -30.0f + -NS, -NS).setUv(0.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder_earth_sky.buildOrThrow());
        if (playerEyeLevel >= 450.0f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)earth_sky_planet_brightness, (float)earth_sky_planet_brightness, (float)earth_sky_planet_brightness, (float)earth_sky_planet_brightness);
        }
        float VF = 2.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)VENUS_FAR);
        bufferbuilder_earth_sky = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, 100.0f, -40.0f + VF, 50.0f + VF).setUv(0.0f, 0.0f);
        bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, 100.0f, -39.4f + VF, 50.0f + -VF).setUv(1.0f, 0.0f);
        bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, 100.0f, -39.4f + -VF, 50.0f + -VF).setUv(1.0f, -1.0f);
        bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, 100.0f, -40.0f + -VF, 50.0f + VF).setUv(0.0f, -1.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder_earth_sky.buildOrThrow());
        float MVF = 1.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MARS_VERY_FAR);
        bufferbuilder_earth_sky = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, -59.25f, -30.0f + MVF, -80.0f + -MVF).setUv(0.0f, 0.0f);
        bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, -60.0f, -29.65f + MVF, -80.0f + MVF).setUv(1.0f, 0.0f);
        bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, -60.0f, -29.65f + -MVF, -80.0f + MVF).setUv(1.0f, -1.0f);
        bufferbuilder_earth_sky.addVertex(matrix4f_earth_sky, -59.25f, -30.0f + -MVF, -80.0f + -MVF).setUv(0.0f, -1.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder_earth_sky.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        pPoseStack.popPose();
    }

    @Inject(method={"renderClouds(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FDDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderClouds(PoseStack poseStack, Matrix4f frustumMatrix, Matrix4f projectionMatrix, float partialTick, double camX, double camY, double camZ, CallbackInfo info) {
        ResourceKey player_dim = Minecraft.getInstance().level.dimension();
        if (this.minecraft != null) {
            float playerEyeLevel = (float)this.minecraft.player.getEyePosition((float)partialTick).y;
            if (player_dim == NorthstarDimensions.MARS_DIM_KEY) {
                info.cancel();
            }
            if (player_dim == NorthstarDimensions.MOON_DIM_KEY) {
                info.cancel();
            }
            if (player_dim == NorthstarDimensions.MERCURY_DIM_KEY) {
                info.cancel();
            }
            if (player_dim == NorthstarDimensions.EARTH_ORBIT_DIM_KEY) {
                info.cancel();
            }
            if (player_dim == Level.OVERWORLD && playerEyeLevel > 500.0f) {
                info.cancel();
            } else if (player_dim == NorthstarDimensions.VENUS_DIM_KEY && playerEyeLevel > 500.0f) {
                info.cancel();
            }
        }
    }

    private MeshData buildClouds(float pX, float pY, float pZ, Vec3 pCloudColor, float offset) {
        float f3 = (float)Mth.floor((float)pX) * 0.00390625f;
        float f4 = (float)Mth.floor((float)pZ) * 0.00390625f;
        float f5 = (float)pCloudColor.x;
        float f6 = (float)pCloudColor.y;
        float f7 = (float)pCloudColor.z;
        float f8 = f5 * 0.9f;
        float f9 = f6 * 0.9f;
        float f10 = f7 * 0.9f;
        float f11 = f5 * 0.7f;
        float f12 = f6 * 0.7f;
        float f13 = f7 * 0.7f;
        float f14 = f5 * 0.8f;
        float f15 = f6 * 0.8f;
        float f16 = f7 * 0.8f;
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        BufferBuilder pBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR_NORMAL);
        float f17 = (float)Math.floor(pY / 4.0f) * 4.0f;
        if (this.prevCloudsType == CloudStatus.FANCY) {
            for (int k = -3; k <= 4; ++k) {
                for (int l = -3; l <= 4; ++l) {
                    float f18 = k * 8;
                    float f19 = l * 8;
                    if (f17 > -5.0f) {
                        pBuilder.addVertex(f18 + 0.0f, f17 + 0.0f, f19 + 8.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f11, f12, f13, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                        pBuilder.addVertex(f18 + 8.0f, f17 + 0.0f, f19 + 8.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f11, f12, f13, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                        pBuilder.addVertex(f18 + 8.0f, f17 + 0.0f, f19 + 0.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f11, f12, f13, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                        pBuilder.addVertex(f18 + 0.0f, f17 + 0.0f, f19 + 0.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f11, f12, f13, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                    }
                    if (f17 <= 5.0f) {
                        pBuilder.addVertex(f18 + 0.0f, f17 + 4.0f - 9.765625E-4f, f19 + 8.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                        pBuilder.addVertex(f18 + 8.0f, f17 + 4.0f - 9.765625E-4f, f19 + 8.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                        pBuilder.addVertex(f18 + 8.0f, f17 + 4.0f - 9.765625E-4f, f19 + 0.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                        pBuilder.addVertex(f18 + 0.0f, f17 + 4.0f - 9.765625E-4f, f19 + 0.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                    }
                    if (k > -1) {
                        for (int i1 = 0; i1 < 8; ++i1) {
                            pBuilder.addVertex(f18 + (float)i1 + 0.0f, f17 + 0.0f, f19 + 8.0f).setUv((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                            pBuilder.addVertex(f18 + (float)i1 + 0.0f, f17 + 4.0f, f19 + 8.0f).setUv((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                            pBuilder.addVertex(f18 + (float)i1 + 0.0f, f17 + 4.0f, f19 + 0.0f).setUv((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                            pBuilder.addVertex(f18 + (float)i1 + 0.0f, f17 + 0.0f, f19 + 0.0f).setUv((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                        }
                    }
                    if (k <= 1) {
                        for (int j2 = 0; j2 < 8; ++j2) {
                            pBuilder.addVertex(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 0.0f, f19 + 8.0f).setUv((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                            pBuilder.addVertex(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 4.0f, f19 + 8.0f).setUv((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                            pBuilder.addVertex(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 4.0f, f19 + 0.0f).setUv((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                            pBuilder.addVertex(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 0.0f, f19 + 0.0f).setUv((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                        }
                    }
                    if (l > -1) {
                        for (int k2 = 0; k2 < 8; ++k2) {
                            pBuilder.addVertex(f18 + 0.0f, f17 + 4.0f, f19 + (float)k2 + 0.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                            pBuilder.addVertex(f18 + 8.0f, f17 + 4.0f, f19 + (float)k2 + 0.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                            pBuilder.addVertex(f18 + 8.0f, f17 + 0.0f, f19 + (float)k2 + 0.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                            pBuilder.addVertex(f18 + 0.0f, f17 + 0.0f, f19 + (float)k2 + 0.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                        }
                    }
                    if (l > 1) continue;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        pBuilder.addVertex(f18 + 0.0f, f17 + 4.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                        pBuilder.addVertex(f18 + 8.0f, f17 + 4.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                        pBuilder.addVertex(f18 + 8.0f, f17 + 0.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                        pBuilder.addVertex(f18 + 0.0f, f17 + 0.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                    }
                }
            }
        } else {
            for (int l1 = -32; l1 < 32; l1 += 32) {
                for (int i2 = -32; i2 < 32; i2 += 32) {
                    pBuilder.addVertex((float)(l1 + 0), f17, (float)(i2 + 32)).setUv((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                    pBuilder.addVertex((float)(l1 + 32), f17, (float)(i2 + 32)).setUv((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                    pBuilder.addVertex((float)(l1 + 32), f17, (float)(i2 + 0)).setUv((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                    pBuilder.addVertex((float)(l1 + 0), f17, (float)(i2 + 0)).setUv((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                }
            }
        }
        return pBuilder.build();
    }
}

