/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.entity;

import com.lightning.northstar.accessor.NorthstarServerPlayer;
import com.lightning.northstar.network.packet.RelativeTeleportPacket;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mixin(value={ServerPlayer.class})
public class ServerPlayerMixin
implements NorthstarServerPlayer {
    @Unique
    private Entity northstar$relativeEntity;
    @Unique
    private int northstar$relativeTicks;

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void northstar$tick(CallbackInfo ci) {
        if (this.northstar$relativeEntity != null && --this.northstar$relativeTicks <= 0) {
            this.northstar$relativeEntity = null;
        }
    }

    @Inject(method={"dismountTo(DDD)V"}, at={@At(value="TAIL")})
    private void northstar$dismountRelative(double x, double y, double z, CallbackInfo ci) {
        ServerPlayer self = (ServerPlayer)this;
        if (this.northstar$relativeEntity != null) {
            Vec3 relativePosition = this.northstar$relativeEntity.position().subtract(x, y, z);
            CatnipServices.NETWORK.sendToClient(self, (CustomPacketPayload)new RelativeTeleportPacket(this.northstar$relativeEntity.getId(), relativePosition));
        }
    }

    @Override
    @Nullable
    public Entity northstar$getRelativeEntity() {
        return this.northstar$relativeEntity;
    }

    @Override
    public void northstar$setPositionRelativeTo(Entity other) {
        this.northstar$relativeEntity = other;
        this.northstar$relativeTicks = 2;
    }
}

