/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.particle;

import com.lightning.northstar.particle.NorthstarParticles;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class RocketFlameLandingParticle
extends SimpleAnimatedParticle {
    protected RocketFlameLandingParticle(SimpleParticleType data, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprite) {
        super(world, x, y, z, sprite, world.random.nextFloat() * 45.0f);
        this.quadSize *= 0.75f;
        this.lifetime = 20;
        this.scale(6.0f);
        this.setSize(0.25f, 0.25f);
        double x_off = (double)(this.random.nextInt(2) * (this.random.nextBoolean() ? -1 : 1)) * 0.01;
        double z_off = (double)(this.random.nextInt(2) * (this.random.nextBoolean() ? -1 : 1)) * 0.01;
        this.xd += x_off;
        this.yd += 0.02;
        this.zd += z_off;
        this.hasPhysics = true;
        this.setSprite(this.sprites.get(7, 8));
        Vec3 offset = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)world.random, (float)0.15f);
        this.setPos(x + offset.x, y + offset.y - 0.3, z + offset.z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setAlpha(0.6f);
    }

    public float getQuadSize(float scaleFactor) {
        float f = ((float)this.age + scaleFactor) / (float)this.lifetime;
        return this.quadSize * (1.0f - f * f * 0.5f);
    }

    public int getLightColor(float partialTick) {
        return NorthstarParticles.getLight(super.getLightColor(partialTick), partialTick, this.age, this.lifetime);
    }
}

