/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.particle;

import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SulfurPoofParticle
extends SimpleAnimatedParticle {
    protected SulfurPoofParticle(SimpleParticleType data, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprite) {
        super(world, x, y, z, sprite, -3.0f + world.random.nextFloat());
        this.quadSize *= 0.75f;
        this.lifetime = 40;
        this.scale(15.0f);
        this.setSize(6.0f, 6.0f);
        this.setBoundingBox(new AABB(0.1, 0.1, 0.1, -0.1, -0.1, -0.1));
        double x_off = (double)(this.random.nextInt(2) * (this.random.nextBoolean() ? -1 : 1)) * 0.1;
        double z_off = (double)(this.random.nextInt(2) * (this.random.nextBoolean() ? -1 : 1)) * 0.1;
        this.xd += x_off;
        this.yd += 0.02;
        this.zd += z_off;
        this.hasPhysics = true;
        this.setSprite(this.sprites.get(7, 8));
        Vec3 offset = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)world.random, (float)0.0f);
        this.setPos(x + offset.x, y + offset.y, z + offset.z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setAlpha(0.6f);
    }

    public float getQuadSize(float pScaleFactor) {
        float f = ((float)this.age + pScaleFactor) / (float)this.lifetime;
        return this.quadSize * (1.0f - f * f * 0.5f);
    }

    public int getLightColor(float partialTick) {
        BlockPos blockpos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        return this.level.isLoaded(blockpos) ? LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)blockpos) : 0;
    }
}

