/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.MultifaceGrowthConfiguration;

public class MultifaceGrowthCustomFeature
extends Feature<MultifaceGrowthConfiguration> {
    public MultifaceGrowthCustomFeature(Codec<MultifaceGrowthConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<MultifaceGrowthConfiguration> pContext) {
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos blockpos = pContext.origin();
        RandomSource randomsource = pContext.random();
        MultifaceGrowthConfiguration multifacegrowthconfiguration = (MultifaceGrowthConfiguration)pContext.config();
        List list = multifacegrowthconfiguration.getShuffledDirections(randomsource);
        if (MultifaceGrowthCustomFeature.placeGrowthIfPossible(worldgenlevel, blockpos, worldgenlevel.getBlockState(blockpos), multifacegrowthconfiguration, randomsource, list)) {
            return true;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = blockpos.mutable();
        block0: for (Direction direction : list) {
            blockpos$mutableblockpos.set((Vec3i)blockpos);
            List list1 = multifacegrowthconfiguration.getShuffledDirectionsExcept(randomsource, direction.getOpposite());
            for (int i = 0; i < multifacegrowthconfiguration.searchRange; ++i) {
                blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, direction);
                BlockState blockstate = worldgenlevel.getBlockState((BlockPos)blockpos$mutableblockpos);
                if (!blockstate.is((Block)multifacegrowthconfiguration.placeBlock)) continue block0;
                if (!MultifaceGrowthCustomFeature.placeGrowthIfPossible(worldgenlevel, (BlockPos)blockpos$mutableblockpos, blockstate, multifacegrowthconfiguration, randomsource, list1)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean placeGrowthIfPossible(WorldGenLevel level, BlockPos pos, BlockState state, MultifaceGrowthConfiguration config, RandomSource rando, List<Direction> directions) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        int radius = rando.nextIntBetweenInclusive(3, 7);
        for (BlockPos blockpos1 : BlockPos.betweenClosed((BlockPos)pos.offset(-radius, -radius / 2, -radius), (BlockPos)pos.offset(radius, radius / 2, radius))) {
            int difX = blockpos1.getX() - pos.getX();
            int difZ = blockpos1.getZ() - pos.getZ();
            ArrayList<Direction> dirs = new ArrayList<Direction>();
            if (!((double)(difX * difX + difZ * difZ) <= (double)(radius * radius) - 0.1)) continue;
            for (Direction direction : Direction.values()) {
                BlockState blockstate1;
                BlockState blockstate = level.getBlockState((BlockPos)mutable.setWithOffset((Vec3i)blockpos1, direction));
                if (!blockstate.is(config.canBePlacedOn) || (blockstate1 = config.placeBlock.getStateForPlacement(state, (BlockGetter)level, blockpos1, direction)) == null) continue;
                dirs.add(direction);
            }
            BlockState blockstate = config.placeBlock.defaultBlockState();
            for (Direction direction2 : dirs) {
                blockstate = (BlockState)blockstate.setValue((Property)MultifaceBlock.getFaceProperty((Direction)direction2), (Comparable)Boolean.valueOf(true));
            }
            if (level.getBlockState(blockpos1).isAir()) {
                level.setBlock(blockpos1, blockstate, 8);
            }
            level.getChunk(blockpos1).markPosForPostprocessing(blockpos1);
        }
        return true;
    }
}

