/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features.trunkplacers;

import com.google.common.collect.Lists;
import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class RoofBloomTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<RoofBloomTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(i -> RoofBloomTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)i).and(i.group((App)BlockStateProvider.CODEC.fieldOf("cap_provider").forGetter(p -> p.capProvider), (App)IntProvider.POSITIVE_CODEC.fieldOf("extra_branch_steps").forGetter(p -> p.extraBranchSteps), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("can_grow_through").forGetter(p -> p.canGrowThrough))).apply((Applicative)i, RoofBloomTrunkPlacer::new));
    public final BlockStateProvider capProvider;
    private final IntProvider extraBranchSteps;
    private final HolderSet<Block> canGrowThrough;
    private BlockPos pos;
    private Direction trunkDir;

    public RoofBloomTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, BlockStateProvider capProvider, IntProvider extraBranchSteps, HolderSet<Block> canGrowThrough) {
        super(baseHeight, heightRandA, heightRandB);
        this.capProvider = capProvider;
        this.extraBranchSteps = extraBranchSteps;
        this.canGrowThrough = canGrowThrough;
    }

    protected TrunkPlacerType<?> type() {
        return TrunkPlacerType.DARK_OAK_TRUNK_PLACER;
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration pConfig) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        this.trunkDir = Direction.getRandom((RandomSource)pRandom);
        Direction dir = Direction.getRandom((RandomSource)pRandom);
        while (this.trunkDir == Direction.UP || this.trunkDir == Direction.DOWN) {
            this.trunkDir = dir = Direction.getRandom((RandomSource)pRandom);
        }
        for (int i = 0; i < pFreeTreeHeight; ++i) {
            int Xpos = pPos.getX();
            int Zpos = pPos.getZ();
            int j = pPos.getY() - i;
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos, j, Zpos), pConfig);
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos, j - 1, Zpos), pConfig);
        }
        BlockPos.MutableBlockPos thing = new BlockPos.MutableBlockPos();
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                if (Math.abs(x) + Math.abs(z) >= 3 || Math.abs(x) + Math.abs(z) >= 2) continue;
                this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(pPos.getX() + x, pPos.getY(), pPos.getZ() + z), pConfig);
            }
        }
        this.placeCap(pLevel, pBlockSetter, pRandom, pPos, pFreeTreeHeight, pConfig);
        BlockPos.MutableBlockPos blockpos$mutableblockpos2 = new BlockPos.MutableBlockPos();
        for (int i = 1; i < pFreeTreeHeight / 2; ++i) {
            int Xpos = pPos.getX();
            int Zpos = pPos.getZ();
            int j = pPos.getY() + (pFreeTreeHeight - i);
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.set(Xpos, j, Zpos), pConfig);
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.set(Xpos, j - 1, Zpos), pConfig);
            if (i == pFreeTreeHeight / 2 - 1) {
                this.pos = new BlockPos(Xpos, j, Zpos);
                BiConsumer<BlockPos, BlockState> biconsumer = (a, b) -> {
                    a = this.pos;
                    b = Blocks.SHROOMLIGHT.defaultBlockState();
                };
                this.placeLight(pLevel, biconsumer, pRandom, pFreeTreeHeight, pPos, pConfig);
            }
            if (i != 1) continue;
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.set(Xpos, j, Zpos), pConfig);
        }
        return list;
    }

    public void placeColumn(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos origin, int Xoff, int Zoff, int height, TreeConfiguration pConfig) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        blockpos$mutableblockpos.setX(origin.getX());
        blockpos$mutableblockpos.setZ(origin.getZ());
        for (int i = 0; i < height; ++i) {
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(origin.getX() - Xoff, origin.getY() + i, origin.getZ() - Zoff), pConfig);
        }
    }

    public void placeCap(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos origin, int treeHeight, TreeConfiguration pConfig) {
        BlockPos.MutableBlockPos thing = new BlockPos.MutableBlockPos();
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX(), origin.getY() - treeHeight, origin.getZ()), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() + 1, origin.getY() - treeHeight, origin.getZ()), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() + 1, origin.getY() - treeHeight, origin.getZ() + 1), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() + 1, origin.getY() - treeHeight, origin.getZ() - 1), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX(), origin.getY() - treeHeight, origin.getZ() + 1), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX(), origin.getY() - treeHeight, origin.getZ() - 1), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() - 1, origin.getY() - treeHeight, origin.getZ() + 1), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() - 1, origin.getY() - treeHeight, origin.getZ()), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() - 1, origin.getY() - treeHeight, origin.getZ() - 1), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() + 1, origin.getY() - treeHeight - 1, origin.getZ() + 1), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() + 1, origin.getY() - treeHeight - 1, origin.getZ() - 1), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() - 1, origin.getY() - treeHeight - 1, origin.getZ() + 1), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() - 1, origin.getY() - treeHeight - 1, origin.getZ() - 1), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() + 2, origin.getY() - treeHeight, origin.getZ()), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() + 2, origin.getY() - treeHeight - 1, origin.getZ()), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() - 2, origin.getY() - treeHeight, origin.getZ()), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() - 2, origin.getY() - treeHeight - 1, origin.getZ()), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX(), origin.getY() - treeHeight, origin.getZ() + 2), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX(), origin.getY() - treeHeight - 1, origin.getZ() + 2), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX(), origin.getY() - treeHeight, origin.getZ() - 2), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX(), origin.getY() - treeHeight - 1, origin.getZ() - 2), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() + 3, origin.getY() - treeHeight - 1, origin.getZ()), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() + 3, origin.getY() - treeHeight - 2, origin.getZ()), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() - 3, origin.getY() - treeHeight - 1, origin.getZ()), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX() - 3, origin.getY() - treeHeight - 2, origin.getZ()), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX(), origin.getY() - treeHeight - 1, origin.getZ() + 3), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX(), origin.getY() - treeHeight - 2, origin.getZ() + 3), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX(), origin.getY() - treeHeight - 1, origin.getZ() - 3), pConfig);
        this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX(), origin.getY() - treeHeight - 2, origin.getZ() - 3), pConfig);
        this.placeShroomLight(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX(), origin.getY() - treeHeight - 1, origin.getZ()), pConfig);
        this.placeShroomLight(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX(), origin.getY() - treeHeight - 2, origin.getZ()), pConfig);
        this.placeShroomLight(pLevel, pBlockSetter, pRandom, (BlockPos)thing.set(origin.getX(), origin.getY() - treeHeight - 3, origin.getZ()), pConfig);
    }

    public List<FoliagePlacer.FoliageAttachment> placeLight(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration pConfig) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos blockpos$mutableblockpos3 = new BlockPos.MutableBlockPos();
        boolean placed = this.placeShroomLight(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos3.set(pPos.getX(), pPos.getY() + 12, pPos.getZ()), pConfig);
        Northstar.LOGGER.debug("{}", (Object)placed);
        Northstar.LOGGER.debug("YOOOOOOOOOOOOOOOO, BIOLUMINESCENCE");
        Northstar.LOGGER.debug("{}X    {}Y    {}Z", new Object[]{pPos.getX(), pPos.getY() + 12, pPos.getZ()});
        return list;
    }

    protected boolean placeLog(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig) {
        return this.placeLog(pLevel, pBlockSetter, pRandom, pPos, pConfig, Function.identity());
    }

    protected boolean placeLog(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig, Function<BlockState, BlockState> pPropertySetter) {
        if (this.validTreePos(pLevel, pPos)) {
            pBlockSetter.accept(pPos, pPropertySetter.apply(pConfig.trunkProvider.getState(pRandom, pPos)));
            return true;
        }
        return false;
    }

    protected boolean placeShroomLight(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig) {
        return this.placeShroomLight2(pLevel, pBlockSetter, pRandom, pPos, pConfig, Function.identity());
    }

    protected boolean placeShroomLight2(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig, Function<BlockState, BlockState> pPropertySetter) {
        if (this.validTreePos(pLevel, pPos)) {
            pBlockSetter.accept(pPos, pPropertySetter.apply(Blocks.SHROOMLIGHT.defaultBlockState()));
            return true;
        }
        return false;
    }

    protected boolean placeCapBlock(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig) {
        return this.placeCapBlock2(pLevel, pBlockSetter, pRandom, pPos, pConfig, Function.identity());
    }

    protected boolean placeCapBlock2(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig, Function<BlockState, BlockState> pPropertySetter) {
        if (this.validTreePos(pLevel, pPos)) {
            pBlockSetter.accept(pPos, pPropertySetter.apply(this.capProvider.getState(pRandom, pPos)));
            return true;
        }
        return false;
    }

    protected boolean validTreePos(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.isStateAtPosition(pPos, state -> state.is(Blocks.AIR) || state.is((Block)NorthstarBlocks.BLOOM_FUNGUS.get()) || state.is((Block)NorthstarBlocks.VENUS_STONE.get()) || state.is((Block)NorthstarBlocks.VENUS_DEEP_STONE.get()));
    }
}

