/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.circuit_engraver;

import com.lightning.northstar.block.tech.circuit_engraver.EngravingBehaviour;
import com.lightning.northstar.block.tech.circuit_engraver.EngravingRecipe;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.item.NorthstarRecipeTypes;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class CircuitEngraverBlockEntity
extends KineticBlockEntity
implements EngravingBehaviour.EngravingBehaviourSpecifics {
    public EngravingBehaviour engravingBehaviour;
    private int sound;
    private static final RecipeWrapper engraverInv = new RecipeWrapper((IItemHandler)new ItemStackHandler(1));

    public CircuitEngraverBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        super.tick();
        if (this.engravingBehaviour.running && this.sound++ % 80 == 0 && this.level != null) {
            this.sound = 0;
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)NorthstarSounds.LASER_BURN.get(), SoundSource.BLOCKS, 0.5f, 0.5f);
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.engravingBehaviour = new EngravingBehaviour(this);
        behaviours.add((BlockEntityBehaviour)this.engravingBehaviour);
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.PRESS, AllAdvancements.COMPACTING, AllAdvancements.TRACK_CRAFTING});
    }

    @Override
    public boolean tryProcessInBasin(boolean simulate) {
        return false;
    }

    @Override
    public boolean tryProcessOnBelt(TransportedItemStack input, List<ItemStack> outputList, boolean simulate) {
        ItemStack created;
        Optional<RecipeHolder<EngravingRecipe>> recipe = this.getRecipe(input.stack);
        if (!recipe.isPresent()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        EngravingBehaviour.particleItems.add(input.stack);
        List outputs = RecipeApplier.applyRecipeOn((Level)this.level, (ItemStack)(this.canProcessInBulk() ? input.stack : input.stack.copyWithCount(1)), recipe.get());
        Iterator iterator = outputs.iterator();
        while (iterator.hasNext() && (created = (ItemStack)iterator.next()).isEmpty()) {
        }
        outputList.addAll(outputs);
        return true;
    }

    public float getRenderedHeadOffset(float partialTicks) {
        float offset = 0.0f;
        if (this.engravingBehaviour.running) {
            if (this.engravingBehaviour.runningTicks < 20) {
                int localTick = this.engravingBehaviour.runningTicks;
                float num = ((float)localTick + partialTicks) / 20.0f;
                num = (2.0f - Mth.cos((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            } else if (this.engravingBehaviour.runningTicks <= 20) {
                offset = 1.0f;
            } else {
                int localTick = 40 - this.engravingBehaviour.runningTicks;
                float num = ((float)localTick - partialTicks) / 20.0f;
                num = (2.0f - Mth.cos((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            }
        }
        return offset + 0.4375f;
    }

    public float getRenderedHeadRotationSpeed(float partialTicks) {
        float speed = this.getSpeed();
        if (this.engravingBehaviour.running) {
            if (this.engravingBehaviour.runningTicks < 15) {
                return speed;
            }
            if (this.engravingBehaviour.runningTicks <= 20) {
                return speed * 2.0f;
            }
            return speed;
        }
        return speed / 2.0f;
    }

    @Override
    public boolean tryProcessInWorld(ItemEntity itemEntity, boolean simulate) {
        ItemStack item = itemEntity.getItem();
        Optional<RecipeHolder<EngravingRecipe>> recipe = this.getRecipe(item);
        if (!recipe.isPresent()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        ItemStack itemCreated = ItemStack.EMPTY;
        EngravingBehaviour.particleItems.add(item);
        if (this.canProcessInBulk() || item.getCount() == 1) {
            RecipeApplier.applyRecipeOn((ItemEntity)itemEntity, (Recipe)recipe.get().value());
            itemCreated = itemEntity.getItem().copy();
        } else {
            for (ItemStack result : RecipeApplier.applyRecipeOn((Level)this.level, (ItemStack)item.copyWithCount(1), recipe.get())) {
                if (itemCreated.isEmpty()) {
                    itemCreated = result.copy();
                }
                ItemEntity created = new ItemEntity(this.level, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), result);
                created.setDefaultPickUpDelay();
                created.setDeltaMovement(VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)this.level.random, (float)0.05f));
                this.level.addFreshEntity((Entity)created);
            }
            item.shrink(1);
        }
        return true;
    }

    public Optional<RecipeHolder<EngravingRecipe>> getRecipe(ItemStack item) {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.level, (ItemStack)item, NorthstarRecipeTypes.ENGRAVING.getType(), EngravingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        return NorthstarRecipeTypes.ENGRAVING.find(engraverInv, this.level);
    }

    @Override
    public boolean canProcessInBulk() {
        return false;
    }

    @Override
    public void onPressingCompleted() {
    }

    @Override
    public int getParticleAmount() {
        return 15;
    }

    @Override
    public float getKineticSpeed() {
        return this.getSpeed();
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putBoolean("Running", this.engravingBehaviour.running);
        compound.putInt("Ticks", this.engravingBehaviour.runningTicks);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.engravingBehaviour.running = compound.getBoolean("Running");
        this.engravingBehaviour.runningTicks = compound.getInt("Ticks");
    }
}

