/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.circuit_engraver;

import com.lightning.northstar.block.tech.circuit_engraver.CircuitEngraverBlockEntity;
import com.lightning.northstar.content.NorthstarPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class CircuitEngraverRenderer
extends ShaftRenderer<CircuitEngraverBlockEntity> {
    public CircuitEngraverRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(CircuitEngraverBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
        float angle = time * be.getRenderedHeadRotationSpeed(partialTicks) / 10.0f % 360.0f / 180.0f * (float)Math.PI;
        SuperByteBuffer head = CachedBuffers.partial((PartialModel)NorthstarPartialModels.CIRCUIT_ENGRAVER_HEAD, (BlockState)be.getBlockState());
        CircuitEngraverRenderer.kineticRotationTransform((SuperByteBuffer)head, (KineticBlockEntity)be, (Direction.Axis)Direction.Axis.Y, (float)(angle * 0.5f), (int)light).renderInto(ms, buffer.getBuffer(RenderType.cutout()));
        if (be.engravingBehaviour.running) {
            ms.pushPose();
            ms.translate(0.0f, -0.16f, 0.0f);
            SuperByteBuffer laser = CachedBuffers.partial((PartialModel)NorthstarPartialModels.CIRCUIT_ENGRAVER_LASER, (BlockState)be.getBlockState());
            CircuitEngraverRenderer.kineticRotationTransform((SuperByteBuffer)laser, (KineticBlockEntity)be, (Direction.Axis)Direction.Axis.Y, (float)(angle / 1.5f), (int)light).renderInto(ms, buffer.getBuffer(RenderType.cutout()));
            ms.popPose();
        }
    }
}

