/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.circuit_engraver;

import com.lightning.northstar.block.tech.circuit_engraver.BeltEngravingCallback;
import com.lightning.northstar.content.NorthstarSounds;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.AABB;

public class EngravingBehaviour
extends BeltProcessingBehaviour {
    public static final int CYCLE = 5280;
    public static final int ENTITY_SCAN = 10;
    public static List<ItemStack> particleItems = new ArrayList<ItemStack>();
    public EngravingBehaviourSpecifics specifics;
    public int prevRunningTicks;
    public int runningTicks;
    public boolean running;
    public boolean finished;
    public Mode mode;
    int entityScanCooldown;

    public <T extends SmartBlockEntity> EngravingBehaviour(T be) {
        super(be);
        this.specifics = (EngravingBehaviourSpecifics)be;
        this.mode = Mode.WORLD;
        this.entityScanCooldown = 10;
        this.whenItemEnters((s, i) -> BeltEngravingCallback.onItemReceived(s, i, this));
        this.whileItemHeld((s, i) -> BeltEngravingCallback.whenItemHeld(s, i, this));
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(nbt, registries, clientPacket);
        this.running = nbt.getBoolean("Running");
        this.mode = Mode.values()[nbt.getInt("Mode")];
        this.finished = nbt.getBoolean("Finished");
        this.prevRunningTicks = this.runningTicks = nbt.getInt("Ticks");
        if (clientPacket) {
            NBTHelper.iterateCompoundList((ListTag)nbt.getList("ParticleItems", 10), c -> particleItems.add(ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)c)));
        }
    }

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(nbt, registries, clientPacket);
        nbt.putBoolean("Running", this.running);
        nbt.putInt("Mode", this.mode.ordinal());
        nbt.putBoolean("Finished", this.finished);
        nbt.putInt("Ticks", this.runningTicks);
        if (clientPacket) {
            nbt.put("ParticleItems", (Tag)NBTHelper.writeCompoundList(particleItems, item -> (CompoundTag)item.saveOptional(registries)));
            particleItems.clear();
        }
    }

    public void start(Mode mode) {
        this.mode = mode;
        this.running = true;
        this.prevRunningTicks = 0;
        this.runningTicks = 0;
        particleItems.clear();
        this.blockEntity.sendData();
    }

    public boolean inWorld() {
        return this.mode == Mode.WORLD;
    }

    public void tick() {
        super.tick();
        Level level = this.getWorld();
        BlockPos worldPosition = this.getPos();
        if (this.specifics.getKineticSpeed() == 0.0f) {
            this.running = false;
            return;
        }
        if (!this.running || level == null) {
            if (level != null && !level.isClientSide) {
                if (this.entityScanCooldown > 0) {
                    --this.entityScanCooldown;
                }
                if (this.entityScanCooldown <= 0) {
                    this.entityScanCooldown = 10;
                    if (BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)worldPosition.below(2), (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE) != null) {
                        return;
                    }
                    if (AllBlocks.BASIN.has(level.getBlockState(worldPosition.below(2)))) {
                        return;
                    }
                    for (ItemEntity itemEntity : level.getEntitiesOfClass(ItemEntity.class, new AABB(worldPosition.below()).deflate(0.125))) {
                        if (!itemEntity.isAlive() || !itemEntity.onGround() || !this.specifics.tryProcessInWorld(itemEntity, true)) continue;
                        this.start(Mode.WORLD);
                        return;
                    }
                }
            }
            return;
        }
        if (level.isClientSide && this.runningTicks == -2640) {
            this.prevRunningTicks = 2640;
            return;
        }
        if (this.runningTicks == 2640 && this.specifics.getKineticSpeed() != 0.0f) {
            if (this.inWorld()) {
                this.applyInWorld();
            }
            if (level.getBlockState(worldPosition.below(2)).getSoundType() == SoundType.WOOL) {
                level.playLocalSound((double)worldPosition.getX(), (double)worldPosition.getY(), (double)worldPosition.getZ(), (SoundEvent)NorthstarSounds.LASER_BURN.get(), SoundSource.BLOCKS, 0.5f, 0.75f + Math.abs(this.specifics.getKineticSpeed()), false);
            } else {
                level.playLocalSound((double)worldPosition.getX(), (double)worldPosition.getY(), (double)worldPosition.getZ(), (SoundEvent)NorthstarSounds.LASER_BURN.get(), SoundSource.BLOCKS, 0.5f, 0.75f + Math.abs(this.specifics.getKineticSpeed()), false);
            }
            if (!level.isClientSide) {
                this.blockEntity.sendData();
            }
        }
        if (!level.isClientSide && this.runningTicks > 5280) {
            this.finished = true;
            this.running = false;
            particleItems.clear();
            this.specifics.onPressingCompleted();
            this.blockEntity.sendData();
            return;
        }
        this.prevRunningTicks = this.runningTicks;
        this.runningTicks += this.getRunningTickSpeed();
        if (this.prevRunningTicks < 2640 && this.runningTicks >= 2640) {
            this.runningTicks = 2640;
            if (level.isClientSide && !this.blockEntity.isVirtual()) {
                this.runningTicks = -2640;
            }
        }
    }

    protected void applyInWorld() {
        Level level = this.getWorld();
        BlockPos worldPosition = this.getPos();
        AABB bb = new AABB(worldPosition.below(1));
        boolean bulk = this.specifics.canProcessInBulk();
        particleItems.clear();
        if (level.isClientSide) {
            return;
        }
        for (Entity entity : level.getEntities(null, bb)) {
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            if (!entity.isAlive() || !entity.onGround()) continue;
            this.entityScanCooldown = 0;
            if (this.specifics.tryProcessInWorld(itemEntity, false)) {
                this.blockEntity.sendData();
            }
            if (bulk) continue;
            break;
        }
    }

    public int getRunningTickSpeed() {
        float speed = this.specifics.getKineticSpeed();
        if (speed == 0.0f) {
            return 0;
        }
        return (int)Mth.lerp((float)Mth.clamp((float)(Math.abs(speed) / 512.0f), (float)0.0f, (float)1.0f), (float)1.0f, (float)60.0f);
    }

    public static interface EngravingBehaviourSpecifics {
        public boolean tryProcessInBasin(boolean var1);

        public boolean tryProcessOnBelt(TransportedItemStack var1, List<ItemStack> var2, boolean var3);

        public boolean tryProcessInWorld(ItemEntity var1, boolean var2);

        public boolean canProcessInBulk();

        public void onPressingCompleted();

        public int getParticleAmount();

        public float getKineticSpeed();
    }

    public static enum Mode {
        WORLD(1.0f),
        BELT(1.1875f),
        BASIN(1.375f);

        public final float headOffset;

        private Mode(float headOffset) {
            this.headOffset = headOffset;
        }
    }
}

