/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.combustion_engine;

import com.lightning.northstar.block.tech.combustion_engine.CombustionEngineBlock;
import com.lightning.northstar.block.tech.combustion_engine.EngineHumSound;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.data.FuelType;
import com.lightning.northstar.world.NorthstarOxygen;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class CombustionEngineBlockEntity
extends GeneratingKineticBlockEntity
implements IHaveGoggleInformation {
    public ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    public SmartFluidTankBehaviour tank;
    protected float generatorSpeed;
    protected Fluid lastFluid;
    protected FuelType fuelType;
    @OnlyIn(value=Dist.CLIENT)
    protected EngineHumSound sound;

    public CombustionEngineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)NorthstarBlockEntityTypes.COMBUSTION_ENGINE.get(), (be, face) -> {
            if (face == be.getBlockState().getValue(CombustionEngineBlock.HORIZONTAL_FACING)) {
                return be.tank.getCapability();
            }
            return null;
        });
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
        ValueBoxTransform.Sided slot = new ValueBoxTransform.Sided(this){

            protected boolean isSideActive(BlockState state, Direction direction) {
                return direction == Direction.UP;
            }

            public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
                return VecHelper.voxelSpace((double)8.0, (double)12.0, (double)8.0);
            }

            protected Vec3 getSouthLocation() {
                return Vec3.ZERO;
            }
        };
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)CreateLang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)slot);
        this.movementDirection.withCallback($ -> {
            this.reActivateSource = true;
        });
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
    }

    public void tick() {
        FuelType fuel;
        super.tick();
        FluidStack fluid = this.tank.getPrimaryHandler().getFluid();
        if (!fluid.getFluid().equals(this.lastFluid)) {
            this.lastFluid = fluid.getFluid();
            this.fuelType = FuelType.getFuelType(this.level.registryAccess(), this.lastFluid);
        }
        if ((fuel = this.fuelType) == null) {
            this.setGeneratorSpeed(0.0f);
            return;
        }
        if (!NorthstarOxygen.hasOxygen(this.level, (Vec3i)this.worldPosition)) {
            this.setGeneratorSpeed(0.0f);
            return;
        }
        if (fluid.getAmount() < fuel.combustionEngineEfficiency()) {
            this.setGeneratorSpeed(0.0f);
        } else if (this.generatorSpeed == 0.0f) {
            this.setGeneratorSpeed(fuel.combustionEngineRpm());
        }
        this.tank.getPrimaryHandler().drain(fuel.combustionEngineEfficiency(), IFluidHandler.FluidAction.EXECUTE);
    }

    private void setGeneratorSpeed(float generatorSpeed) {
        if (this.generatorSpeed != generatorSpeed) {
            this.generatorSpeed = generatorSpeed;
            this.updateGeneratedRotation();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.sound == null || this.sound.isStopped()) {
            this.sound = new EngineHumSound(this);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)this.sound);
        }
    }

    protected boolean isNoisy() {
        return false;
    }

    public float getGeneratedSpeed() {
        return this.generatorSpeed * (float)(this.movementDirection.getValue() == 1 ? 1 : -1);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        FluidStack fluidStack = this.tank.getPrimaryHandler().getFluidInTank(0);
        if (!fluidStack.getFluid().getFluidType().isAir()) {
            CreateLang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip);
        } else {
            CreateLang.translate((String)"gui.goggles.empty", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        }
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        CreateLang.builder().add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)this.tank.getPrimaryHandler().getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.generatorSpeed = compound.getFloat("GeneratorSpeed");
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putFloat("GeneratorSpeed", this.generatorSpeed);
    }
}

