/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.electrolysis_machine;

import com.lightning.northstar.block.tech.electrolysis_machine.ElectrolysisMachineBlock;
import com.lightning.northstar.block.tech.electrolysis_machine.ElectrolysisRecipe;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.item.NorthstarRecipeTypes;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;

public class ElectrolysisMachineBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    public static final BehaviourType<SmartFluidTankBehaviour> OUTPUT1 = new BehaviourType("Output1");
    public static final BehaviourType<SmartFluidTankBehaviour> OUTPUT2 = new BehaviourType("Output2");
    private static final Object ELECTROLYSIS_RECIPE_KEY = new Object();
    protected SmartFluidTankBehaviour inputTank;
    protected SmartFluidTankBehaviour outputTankL;
    protected SmartFluidTankBehaviour outputTankR;
    protected float processingTime;
    protected Recipe<?> currentRecipe;

    public ElectrolysisMachineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)NorthstarBlockEntityTypes.ELECTROLYSIS_MACHINE.get(), (be, face) -> {
            if (face == Direction.UP) {
                return be.inputTank.getCapability();
            }
            if (face == ((Direction)be.getBlockState().getValue(ElectrolysisMachineBlock.HORIZONTAL_FACING)).getClockWise()) {
                return be.outputTankL.getCapability();
            }
            if (face == ((Direction)be.getBlockState().getValue(ElectrolysisMachineBlock.HORIZONTAL_FACING)).getCounterClockWise()) {
                return be.outputTankR.getCapability();
            }
            return null;
        });
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 1, 1000, true);
        this.outputTankL = new SmartFluidTankBehaviour(OUTPUT1, (SmartBlockEntity)this, 1, 1000, true).forbidInsertion();
        this.outputTankR = new SmartFluidTankBehaviour(OUTPUT2, (SmartBlockEntity)this, 1, 1000, true).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        behaviours.add((BlockEntityBehaviour)this.outputTankL);
        behaviours.add((BlockEntityBehaviour)this.outputTankR);
    }

    public void tick() {
        super.tick();
        if (!ElectrolysisRecipe.match(this, this.currentRecipe)) {
            this.currentRecipe = RecipeFinder.get((Object)ELECTROLYSIS_RECIPE_KEY, (Level)this.level, this::matchStaticFilters).stream().filter(r -> ElectrolysisRecipe.match(this, r.value())).findFirst().map(RecipeHolder::value).orElse(null);
        }
        if (this.currentRecipe == null) {
            return;
        }
        this.processingTime += Math.abs(this.speed);
        int toProcess = (int)(this.processingTime / 256.0f);
        this.processingTime %= 256.0f;
        for (int i = 0; i < toProcess && ElectrolysisRecipe.apply(this, this.currentRecipe, false); ++i) {
        }
    }

    protected boolean matchStaticFilters(RecipeHolder<? extends Recipe<?>> recipe) {
        return recipe.value().getType() == NorthstarRecipeTypes.ELECTROLYSIS.getType();
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putFloat("ProcessingTime", this.processingTime);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.processingTime = compound.getFloat("ProcessingTime");
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (super.addToGoggleTooltip(tooltip, isPlayerSneaking)) {
            tooltip.add((Component)Component.empty());
        }
        CreateLang.translate((String)"gui.goggles.electrolysis_machine", (Object[])new Object[0]).forGoggles(tooltip);
        this.addTankToolTip(tooltip, "gui.goggles.electrolysis_input", this.inputTank);
        this.addTankToolTip(tooltip, "gui.goggles.electrolysis_orange_port", this.outputTankL);
        this.addTankToolTip(tooltip, "gui.goggles.electrolysis_blue_port", this.outputTankR);
        return true;
    }

    private void addTankToolTip(List<Component> tooltip, String color, SmartFluidTankBehaviour tank) {
        FluidStack fluidStack = tank.getPrimaryHandler().getFluidInTank(0);
        if (!fluidStack.getFluid().getFluidType().isAir()) {
            CreateLang.translate((String)color, (Object[])new Object[0]).add(CreateLang.fluidName((FluidStack)fluidStack)).style(ChatFormatting.GRAY).forGoggles(tooltip);
        } else {
            CreateLang.translate((String)color, (Object[])new Object[0]).add(CreateLang.translate((String)"gui.goggles.empty", (Object[])new Object[0])).style(ChatFormatting.GRAY).forGoggles(tooltip);
        }
        Lang.builder((String)"northstar").add(CreateLang.number((double)fluidStack.getAmount()).add(CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0])).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)tank.getPrimaryHandler().getTankCapacity(0)).add(CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0])).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
    }

    public float getTotalFluidUnits(float partialTicks) {
        int renderedFluids = 0;
        float totalUnits = 0.0f;
        SmartFluidTankBehaviour behaviour = this.inputTank;
        if (behaviour == null) {
            return 0.0f;
        }
        for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
            float units;
            if (tankSegment.getRenderedFluid().isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
            totalUnits += units;
            ++renderedFluids;
        }
        if (renderedFluids == 0) {
            return 0.0f;
        }
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        return totalUnits;
    }
}

