/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.oxygen_filler;

import com.lightning.northstar.block.tech.oxygen_filler.OxygenFillerBlock;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.content.NorthstarDataComponents;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.world.NorthstarOxygen;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.particle.AirParticleData;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class OxygenFillerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public int airLevel;
    public int airTimer;
    private boolean hasStopped = false;
    private int audioTick = 0;
    protected IItemHandlerModifiable itemCapability;
    SmartFluidTankBehaviour tank;
    public Container container = new SimpleContainer(this, 1){

        public void setChanged() {
            super.setChanged();
        }
    };
    protected ItemStackHandler inventory = new ItemStackHandler();

    public OxygenFillerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.itemCapability = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory});
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)NorthstarBlockEntityTypes.OXYGEN_FILLER.get(), (be, face) -> {
            if (face == ((Direction)be.getBlockState().getValue(OxygenFillerBlock.HORIZONTAL_FACING)).getOpposite()) {
                return be.tank.getCapability();
            }
            return null;
        });
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public ItemStackHandler getInventoryOfBlock() {
        return this.inventory;
    }

    public void tick() {
        super.tick();
        ItemStack item = this.container.getItem(0);
        Fluid fluid = this.tank.getPrimaryHandler().getFluid().getFluid();
        int increment = 2;
        if (item.is(NorthstarTags.NorthstarItemTags.OXYGEN_SOURCES.tag) && NorthstarOxygen.isOxygen(fluid)) {
            int currentOxy;
            int n = currentOxy = item.has(NorthstarDataComponents.OXYGEN) ? (Integer)item.get(NorthstarDataComponents.OXYGEN) : 0;
            while (currentOxy + increment > 1800) {
                --increment;
            }
            if ((increment = Math.max(increment, 0)) == 0 && !this.hasStopped) {
                AllSoundEvents.CONFIRM.playAt(this.level, (Vec3i)this.worldPosition, 0.4f, 0.0f, true);
                this.hasStopped = true;
            } else if (increment != 0) {
                this.hasStopped = false;
                ++this.audioTick;
                if (this.level.isClientSide) {
                    if (this.audioTick % 13 == 0) {
                        BlockPos pos = this.getBlockPos();
                        this.level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)NorthstarSounds.AIRFLOW.get(), SoundSource.BLOCKS, 0.5f, 0.0f, false);
                    }
                    Vec3 centerOf = VecHelper.getCenterOf((Vec3i)this.worldPosition);
                    Vec3 v = VecHelper.offsetRandomly((Vec3)centerOf, (RandomSource)this.level.random, (float)0.65f);
                    Vec3 m = centerOf.subtract(v);
                    if (this.level.random.nextBoolean()) {
                        this.level.addParticle((ParticleOptions)new AirParticleData(1.0f, 0.05f), v.x, v.y, v.z, m.x, m.y, m.z);
                    }
                }
            }
            int newOxyAmount = Mth.clamp((int)increment, (int)0, (int)this.tank.getPrimaryHandler().getFluidAmount());
            int newoxy = currentOxy + newOxyAmount;
            item.set(NorthstarDataComponents.OXYGEN, (Object)newoxy);
            this.tank.getPrimaryHandler().drain(new FluidStack(fluid, newOxyAmount), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.putInt("Air", this.airLevel);
        tag.putInt("Timer", this.airTimer);
        tag.put("item", this.container.getItem(0).saveOptional(registries));
    }

    public void writeSafe(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeSafe(tag, registries);
        tag.put("item", this.container.getItem(0).saveOptional(registries));
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.airLevel = tag.getInt("Air");
        this.airTimer = tag.getInt("Timer");
        this.container.setItem(0, ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("item")));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        CreateLang.translate((String)"gui.goggles.oxygen_filler", (Object[])new Object[0]).forGoggles(tooltip);
        FluidStack fluidStack = this.tank.getPrimaryHandler().getFluidInTank(0);
        if (!fluidStack.getFluid().getFluidType().isAir()) {
            CreateLang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip);
        } else {
            CreateLang.translate((String)"gui.goggles.empty", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        }
        CreateLang.builder().add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)this.tank.getPrimaryHandler().getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        ItemStack itemStack = this.container.getItem(0);
        if (!itemStack.isEmpty()) {
            int currentOxy;
            CreateLang.builder().add(CreateLang.number((double)itemStack.getCount()).style(ChatFormatting.GRAY)).text(ChatFormatting.DARK_GRAY, "x ").add(CreateLang.itemName((ItemStack)itemStack).style(ChatFormatting.GRAY)).forGoggles(tooltip, 1);
            int n = currentOxy = itemStack.has(NorthstarDataComponents.OXYGEN) ? (Integer)itemStack.get(NorthstarDataComponents.OXYGEN) : 0;
            if (currentOxy != 0) {
                CreateLang.builder().add(CreateLang.number((double)currentOxy).style(ChatFormatting.GRAY)).add(mb).style(ChatFormatting.GRAY).forGoggles(tooltip, 2);
            }
        }
        return true;
    }
}

