/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.solar_panel;

import com.lightning.northstar.block.tech.solar_panel.SolarPanelBlock;
import com.lightning.northstar.block.tech.solar_panel.SolarPanelBlockEntity;
import com.lightning.northstar.content.NorthstarPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SolarPanelRenderer
extends ShaftRenderer<SolarPanelBlockEntity> {
    public SolarPanelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(SolarPanelBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        boolean south;
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        BlockState state = be.getBlockState();
        boolean north = (Boolean)state.getValue((Property)SolarPanelBlock.NORTH) == false;
        boolean bl = south = (Boolean)state.getValue((Property)SolarPanelBlock.SOUTH) == false;
        PartialModel model = north && south ? NorthstarPartialModels.SOLAR_PANEL_FULL : (north ? NorthstarPartialModels.SOLAR_PANEL_NORTH : (south ? NorthstarPartialModels.SOLAR_PANEL_SOUTH : NorthstarPartialModels.SOLAR_PANEL_SLIM));
        float angle = Mth.clamp((float)AngleHelper.wrapAngle180((float)(be.getLevel().getTimeOfDay(partialTicks) * 360.0f)), (float)-45.0f, (float)45.0f);
        be.targetAngle.chase((double)angle, 0.2, LerpedFloat.Chaser.EXP);
        ms.pushPose();
        ((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).translate(0.0f, 0.25f, 0.0f).center()).rotateZDegrees(be.targetAngle.getValue(partialTicks))).uncenter();
        CachedBuffers.partial((PartialModel)model, (BlockState)state).light(light).renderInto(ms, buffer.getBuffer(RenderType.solid()));
        ms.popPose();
    }
}

