/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.temperature_regulator;

import com.lightning.northstar.block.tech.temperature_regulator.MovingTemperatureRegulator;
import com.lightning.northstar.client.renderer.block.SpinningBlockRenderer;
import com.lightning.northstar.content.NorthstarPartialModels;
import com.lightning.northstar.world.NorthstarTemperature;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TemperatureRegulatorMovementBehaviour
implements MovementBehaviour {
    public void stopMoving(MovementContext context) {
        Object object = context.temporaryData;
        if (object instanceof MovingTemperatureRegulator) {
            MovingTemperatureRegulator regulator = (MovingTemperatureRegulator)object;
            context.world.northstar$temperature().unregisterSealer(regulator);
            context.temporaryData = null;
        }
    }

    public void tick(MovementContext context) {
        Object object = context.temporaryData;
        if (object instanceof MovingTemperatureRegulator) {
            MovingTemperatureRegulator regulator = (MovingTemperatureRegulator)object;
            regulator.tick(context);
        } else {
            MovingTemperatureRegulator regulator = new MovingTemperatureRegulator(context);
            context.temporaryData = regulator;
            context.world.northstar$temperature().registerSealer(regulator);
            regulator.tick(context);
        }
    }

    public boolean disableBlockEntityRendering() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        float rpm = 0.0f;
        boolean warm = false;
        Object object = context.temporaryData;
        if (object instanceof MovingTemperatureRegulator) {
            MovingTemperatureRegulator regulator = (MovingTemperatureRegulator)object;
            if (regulator.active) {
                rpm = 128.0f;
            }
            warm = regulator.regulator.temperature >= NorthstarTemperature.getBaseTemperature(context.world, context.contraption.entity.blockPosition());
            regulator.regulator.sealer.getVisualizer().render(matrices.getModelViewProjection(), buffer);
        }
        PartialModel model = warm ? NorthstarPartialModels.WARM_SPINNY : NorthstarPartialModels.COLD_SPINNY;
        SpinningBlockRenderer.renderInContraption(context, renderWorld, matrices, buffer, model, rpm);
    }
}

