/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.contraption.rocket;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.tech.computer_rack.TargetingComputerRackBlockEntity;
import com.lightning.northstar.block.tech.jet_engine.JetEngineBlock;
import com.lightning.northstar.block.tech.rocket_station.RocketStationBlockEntity;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarContraptionTypes;
import com.lightning.northstar.content.NorthstarDataComponents;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.data.FuelType;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.contraption.ContraptionType;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageWrapper;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import com.simibubi.create.content.contraptions.minecart.TrainCargoManager;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.tuple.Pair;

public class RocketContraption
extends TranslatingContraption {
    public int fuelCost = 0;
    public int fuelReturnCost = 0;
    public int weightCost = 0;
    public int heatShielding = 0;
    public int blockCount = 0;
    private boolean rocket_station = false;
    public boolean hasControls = false;
    public boolean hasInterplanetaryNavigation = false;
    public boolean hasAutoLander = false;
    public boolean isUsingTicket;
    private float fuelAmount = 0.0f;
    private int jet_engines = 0;
    private int visual_jet_engines = 0;
    public float computingPower = 0.0f;
    private List<BlockPos> assembledJets = new ArrayList<BlockPos>();
    public String name = "Rocket";
    public Player owner;
    public BlockPos localControlsPos;
    public ResourceKey<Level> dest = null;

    public RocketContraption() {
        this.storage = new TrainCargoManager();
    }

    public boolean assemble(Level world, BlockPos pos) throws AssemblyException {
        if (!this.searchMovedStructure(world, pos, null)) {
            return false;
        }
        System.out.print(this.blocks.size());
        this.startMoving(world);
        return true;
    }

    public void burnFuel(Level level) {
        MountedFluidStorageWrapper tanks = this.storage.getFluids();
        float fuelToBurn = (float)this.weightCost + (float)this.fuelCost * (1.0f - this.computingPower);
        for (int slot = 0; slot < tanks.getTanks(); ++slot) {
            FluidStack stack = tanks.getFluidInTank(slot);
            FuelType fuel = FuelType.getFuelType(level.registryAccess(), stack.getFluid());
            if (fuel == null || !((float)stack.getAmount() >= fuel.rocketMultiplier())) continue;
            float toBurn = Math.min(fuelToBurn / fuel.rocketMultiplier(), (float)stack.getAmount());
            stack.shrink((int)toBurn);
            fuelToBurn -= toBurn;
            if (!(fuelToBurn < 1.0f)) continue;
            return;
        }
    }

    protected Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture(Level world, BlockPos pos) {
        TargetingComputerRackBlockEntity crbe;
        BlockEntity ent;
        BlockState blockState = world.getBlockState(pos);
        if (NorthstarBlocks.ROCKET_STATION.has(blockState)) {
            this.rocket_station = true;
            ent = world.getBlockEntity(pos);
            if (ent instanceof RocketStationBlockEntity) {
                RocketStationBlockEntity rsbe = (RocketStationBlockEntity)ent;
                this.name = rsbe.name;
                if (rsbe.container.getItem(0).is((Item)NorthstarItems.RETURN_TICKET.get()) && rsbe.container.getItem(0).has(NorthstarDataComponents.PLANET)) {
                    if (NorthstarPlanets.getPlanetDimension((String)rsbe.container.getItem(0).get(NorthstarDataComponents.PLANET)) == this.dest) {
                        this.isUsingTicket = true;
                    }
                    this.isUsingTicket = true;
                }
            }
        }
        if (blockState.is((Block)NorthstarBlocks.AUTO_LANDER.get())) {
            Northstar.LOGGER.debug("AUTO LANDER");
            this.hasAutoLander = true;
        }
        if (blockState.is((Block)NorthstarBlocks.INTERPLANETARY_NAVIGATOR.get())) {
            this.hasInterplanetaryNavigation = true;
        }
        if (NorthstarBlocks.COMPUTER_RACK.has(blockState) && (ent = world.getBlockEntity(pos)) instanceof TargetingComputerRackBlockEntity) {
            crbe = (TargetingComputerRackBlockEntity)ent;
            for (int b = 0; b < crbe.container.getContainerSize(); ++b) {
                if (!crbe.container.getItem(b).is((Item)NorthstarItems.TARGETING_COMPUTER.get()) || !((double)this.computingPower < 0.4)) continue;
                this.computingPower = (float)((double)this.computingPower + 0.0025);
            }
        }
        if (NorthstarBlocks.ROCKET_CONTROLS.has(blockState)) {
            this.hasControls = true;
            if (this.localControlsPos == null) {
                this.localControlsPos = this.toLocalPos(pos);
            }
        }
        if (blockState.getBlock() instanceof JetEngineBlock) {
            ++this.jet_engines;
            if (!((Boolean)blockState.getValue((Property)JetEngineBlock.BOTTOM)).booleanValue()) {
                ++this.visual_jet_engines;
            }
            this.assembledJets.add(this.toLocalPos(pos));
        }
        if ((crbe = world.getBlockEntity(pos)) instanceof FluidTankBlockEntity) {
            FluidTankBlockEntity tank = (FluidTankBlockEntity)crbe;
            if (Float.isFinite(this.fuelAmount)) {
                FluidTank tankInventory = tank.getTankInventory();
                for (int i = 0; i < tankInventory.getTanks(); ++i) {
                    FuelType fuel = FuelType.getFuelType(world.registryAccess(), tankInventory.getFluidInTank(i).getFluid());
                    if (fuel == null) continue;
                    this.fuelAmount += (float)tankInventory.getFluidAmount() * fuel.rocketMultiplier();
                }
                if (blockState.is((Block)AllBlocks.CREATIVE_FLUID_TANK.get())) {
                    this.fuelAmount = Float.POSITIVE_INFINITY;
                }
            }
        }
        if (!blockState.is(Blocks.AIR) && !blockState.is(Blocks.CAVE_AIR)) {
            ++this.blockCount;
        }
        if (blockState.is(NorthstarTags.NorthstarBlockTags.HEAVY_BLOCKS.tag) && !blockState.is(Blocks.AIR)) {
            this.weightCost += 5;
        } else if (blockState.is(NorthstarTags.NorthstarBlockTags.SUPER_HEAVY_BLOCKS.tag) && !blockState.is(Blocks.AIR)) {
            this.weightCost += 10;
        } else if (!blockState.is(Blocks.AIR)) {
            ++this.weightCost;
        }
        if (blockState.is(NorthstarTags.NorthstarBlockTags.TIER_1_HEAT_RESISTANCE.tag) && !blockState.is(Blocks.AIR)) {
            this.heatShielding += 3;
        }
        if (blockState.is(NorthstarTags.NorthstarBlockTags.TIER_2_HEAT_RESISTANCE.tag) && !blockState.is(Blocks.AIR)) {
            this.heatShielding += 8;
        }
        if (blockState.is(NorthstarTags.NorthstarBlockTags.TIER_3_HEAT_RESISTANCE.tag) && !blockState.is(Blocks.AIR)) {
            this.heatShielding += 20;
        }
        return super.capture(world, pos);
    }

    public boolean canBeStabilized(Direction facing, BlockPos localPos) {
        return false;
    }

    public ContraptionType getType() {
        return NorthstarContraptionTypes.ROCKET;
    }

    public boolean hasRocketStation() {
        return this.rocket_station;
    }

    public int hasJetEngine() {
        return this.jet_engines;
    }

    public int getVisualJetEngines() {
        return this.visual_jet_engines;
    }

    public float fuelAmount() {
        return this.fuelAmount;
    }

    public int heatShielding() {
        return this.heatShielding;
    }

    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return super.isAnchoringBlockAt(pos.relative(Direction.DOWN));
    }
}

