/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.contraption.rocket;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarDataComponents;
import com.lightning.northstar.content.NorthstarEntityTypes;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.contraption.rocket.RocketAirSound;
import com.lightning.northstar.contraption.rocket.RocketContraption;
import com.lightning.northstar.contraption.rocket.RocketHandler;
import com.lightning.northstar.contraption.rocket.packet.RocketContraptionQuickSyncPacket;
import com.lightning.northstar.contraption.rocket.packet.RocketContraptionSyncPacket;
import com.lightning.northstar.contraption.rocket.packet.RocketControlPacket;
import com.lightning.northstar.world.NorthstarTemperature;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.simibubi.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.tterrag.registrate.util.RegistrateDistExecutor;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class RocketContraptionEntity
extends AbstractContraptionEntity {
    public static final int LAUNCH_COUNTDOWN_TIME = 200;
    private static final float MAX_SPEED = 5.0f;
    private List<Entity> entitiesWithinContraption = List.of();
    public boolean auto_land_mode;
    public boolean launchingMode;
    public boolean landingMode;
    boolean fuelBurned = false;
    boolean printed = false;
    public boolean blasting = false;
    public boolean slowing = false;
    public boolean hasExploded = false;
    public boolean isUsingTicket = false;
    int i = 90;
    int soundTime = 0;
    int cooldown = 0;
    int cooldownLength = 100;
    private int launchTime = 0;
    private boolean activeLaunch = false;
    public Player owner;
    public UUID ownerID;
    public float lift_vel;
    public float final_lift_vel = this.lift_vel;
    public ResourceKey<Level> home;
    public ResourceKey<Level> destination;
    @OnlyIn(value=Dist.CLIENT)
    private RocketAirSound flyingSound;

    public RocketContraptionEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.noCulling = true;
        this.lift_vel = 0.5f;
        this.launchingMode = true;
        this.landingMode = false;
    }

    public static RocketContraptionEntity create(Level world, Contraption contraption) {
        RocketContraptionEntity entity = new RocketContraptionEntity((EntityType)NorthstarEntityTypes.ROCKET_CONTRAPTION.get(), world);
        entity.setContraption(contraption);
        return entity;
    }

    public void disassemble() {
        super.disassemble();
        RocketHandler.ROCKETS.remove((Object)this);
    }

    protected void tickContraption() {
        ServerLevel level;
        Level level2 = this.level();
        if (level2 instanceof ServerLevel && !(level = (ServerLevel)level2).dimension().equals(this.destination) && this.getY() >= 1750.0) {
            this.changeDimension(new DimensionTransition(level.getServer().getLevel(this.destination), (Entity)this, DimensionTransition.DO_NOTHING));
        }
        RocketContraption contraption = this.getContraption();
        this.tickActors();
        this.entitiesWithinContraption = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.0, (double)(this.lift_vel * 2.0f + 2.0f), 0.0));
        if (this.launchTime > 0 && this.activeLaunch) {
            --this.launchTime;
        }
        if (this.launchingMode && this.launchTime == 0 && this.activeLaunch) {
            if (!this.blasting) {
                this.blasting = true;
            }
            if (!this.fuelBurned) {
                Northstar.LOGGER.debug("BURNING FUEL");
                if (contraption.fuelAmount() < (float)contraption.fuelCost) {
                    this.disassemble();
                } else {
                    contraption.burnFuel(this.level());
                    this.fuelBurned = true;
                }
            }
        }
        if (this.owner == null) {
            if (contraption.owner != null) {
                this.owner = ((RocketContraption)this.contraption).owner;
            }
            if (this.ownerID != null) {
                this.owner = this.level().getPlayerByUUID(this.ownerID);
            }
        }
        if (contraption.isUsingTicket) {
            this.isUsingTicket = true;
        }
        if (this.level().isClientSide) {
            if (Math.abs(this.final_lift_vel) > 0.5f) {
                int volume = NorthstarPlanets.getPlanetAtmosphereCost((ResourceKey<Level>)this.level().dimension()) / 400;
                RegistrateDistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.tickAirSound(Math.max(volume, 1)));
            }
        } else {
            if (this.tickCount % 40 == 0) {
                this.writeSyncPacket();
            }
            if (this.landingMode) {
                CatnipServices.NETWORK.sendToClientsTrackingEntity((Entity)this, (CustomPacketPayload)new RocketContraptionQuickSyncPacket(this.getId(), this.slowing));
            }
        }
        if (contraption.owner != null && !this.printed) {
            this.displayInfo();
            this.printed = true;
        }
        if (this.destination == null) {
            Northstar.LOGGER.error("Rocket destination is null. Setting destination to overworld");
            this.destination = Level.OVERWORLD;
        }
        if (this.launchingMode) {
            if (this.blasting) {
                this.lift_vel += this.lift_vel * 0.005f;
                this.lift_vel = Mth.clamp((float)this.lift_vel, (float)0.5f, (float)5.0f);
                this.final_lift_vel = this.lift_vel - 0.5f;
            }
            if (this.getY() > 1750.0) {
                if (this.level().isClientSide) {
                    this.flyingSound.stopSound();
                }
                this.startLanding();
                this.cooldown = 0;
                this.final_lift_vel = 0.0f;
            }
            if (this.soundTime % 40 == 0 && this.launchTime == 0 && this.blasting) {
                this.level().playLocalSound(this.getX(), this.getY() - 20.0, this.getZ(), (SoundEvent)NorthstarSounds.ROCKET_BLAST.get(), SoundSource.BLOCKS, 5.0f, 0.0f, false);
                this.i = 0;
                this.soundTime = 0;
            } else {
                ++this.soundTime;
            }
        } else if (this.landingMode) {
            if (this.auto_land_mode && this.getY() < this.getSlowdownHeightThreshold()) {
                this.slowing = true;
            }
            if (this.slowing) {
                this.level().playLocalSound(this.getX(), this.getY() - 8.0, this.getZ(), (SoundEvent)NorthstarSounds.ROCKET_LANDING.get(), SoundSource.BLOCKS, 4.0f, 0.0f, false);
                this.i = 0;
                this.soundTime = 0;
            }
            if (this.cooldown <= this.cooldownLength) {
                ++this.cooldown;
            }
            if (this.cooldown >= this.cooldownLength) {
                this.lift_vel = !this.slowing ? (this.lift_vel -= 0.02f) : (this.lift_vel -= this.lift_vel / 10.0f);
                this.final_lift_vel = this.lift_vel = Mth.clamp((float)this.lift_vel, (float)-5.0f, (float)-0.5f);
            }
        }
        this.tickActors();
        if (this.isLaunchingOrLanding() && this.collidesWithBlocks(this.landingMode ? Direction.DOWN : Direction.UP)) {
            if (!this.level().isClientSide) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), AllSoundEvents.STEAM.getMainEvent(), SoundSource.BLOCKS, 3.0f, 0.0f, true);
                if (Math.abs(this.final_lift_vel) < 3.0f || this.hasExploded) {
                    if (this.landingMode && !this.isUsingTicket) {
                        ItemStack returnTicket = this.createReturnTicket();
                        if (this.owner != null) {
                            Player player = this.owner;
                            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), player.getX(), player.getY(), player.getZ(), returnTicket));
                        }
                    }
                    this.disassemble();
                    this.final_lift_vel = 0.0f;
                    if (this.landingMode && this.isUsingTicket) {
                        RocketHandler.deleteTicket(this.level(), this.blockPosition());
                    }
                    this.landingMode = false;
                }
                if (this.landingMode && !this.auto_land_mode && Math.abs(this.final_lift_vel) > 3.0f && !this.hasExploded) {
                    this.level().explode((Entity)this, this.getX(), this.getY() - 1.0, this.getZ(), 30.0f, NorthstarPlanets.getPlanetOxy(this.destination), Level.ExplosionInteraction.MOB);
                    this.hasExploded = true;
                }
            } else if (this.flyingSound != null) {
                this.flyingSound.stopSound();
            }
        }
        if (!this.isStalled() && this.tickCount > 2) {
            this.move(0.0, this.final_lift_vel, 0.0);
            for (Entity entity : this.entitiesWithinContraption) {
                if (contraption.getSeatOf(entity.getUUID()) != null) continue;
                entity.setPos(entity.getX(), entity.getY() + (double)this.final_lift_vel, entity.getZ());
            }
        }
        this.slowing = false;
    }

    private void writeSyncPacket() {
        RocketContraptionSyncPacket packet = new RocketContraptionSyncPacket(this.getId(), this.position(), this.lift_vel, this.launchTime, this.launchingMode, this.landingMode, this.blasting, this.slowing, this.activeLaunch);
        CatnipServices.NETWORK.sendToClientsTrackingEntity((Entity)this, (CustomPacketPayload)packet);
    }

    private void displayInfo() {
        RocketContraption contraption = this.getContraption();
        double heatCost = NorthstarTemperature.getHeatRating(this.destination) * (double)((RocketContraption)this.contraption).blockCount + NorthstarTemperature.getHeatConstant(this.destination);
        double heatCostHome = NorthstarTemperature.getHeatRating((ResourceKey<Level>)this.level().dimension()) * (double)((RocketContraption)this.contraption).blockCount + NorthstarTemperature.getHeatConstant((ResourceKey<Level>)this.level().dimension());
        if (heatCostHome > heatCost) {
            heatCost = heatCostHome;
        }
        int requiredJets = contraption.fuelCost / 800;
        int fuelCost = (int)((float)contraption.weightCost + ((float)contraption.fuelCost - (float)contraption.fuelCost * contraption.computingPower));
        contraption.owner.displayClientMessage((Component)Component.literal((String)("Fuel: " + (int)contraption.fuelAmount() + "; Required: " + fuelCost)).withStyle(ChatFormatting.GOLD), false);
        contraption.owner.displayClientMessage((Component)Component.literal((String)("Return Fuel Cost: ~" + contraption.fuelReturnCost)).withStyle(ChatFormatting.GOLD), false);
        contraption.owner.displayClientMessage((Component)Component.literal((String)("Heat Shielding: " + contraption.heatShielding() + "; Required: " + (int)Math.ceil(heatCost))).withStyle(ChatFormatting.YELLOW), false);
        contraption.owner.displayClientMessage((Component)Component.literal((String)("Engine Count: " + contraption.hasJetEngine() + "; Required: " + requiredJets)).withStyle(ChatFormatting.BLUE), false);
        if (this.auto_land_mode) {
            contraption.owner.displayClientMessage((Component)Component.literal((String)"Auto Landing Mode Enabled!").withStyle(ChatFormatting.GREEN), false);
        }
        contraption.owner.displayClientMessage((Component)Component.literal((String)"All entities should remain seated for the duration of the flight!").withStyle(ChatFormatting.AQUA), false);
    }

    @Nullable
    public Entity changeDimension(DimensionTransition transition) {
        record PassengerData(Entity entity, Vec3 offset, int seat) {
        }
        ArrayList<PassengerData> passengers = new ArrayList<PassengerData>();
        UUID controllingPlayer = this.getControllingPlayer().orElse(null);
        for (Entity passenger : this.level().getEntities((Entity)this, this.getBoundingBox().inflate(2.0, 50.0, 2.0))) {
            Vec3 offset = passenger.position().subtract(this.position());
            int seat = this.contraption.getSeats().indexOf(this.contraption.getSeatOf(passenger.getUUID()));
            if (passenger instanceof Player && seat == -1) {
                offset = offset.add(0.0, (double)this.final_lift_vel, 0.0);
            }
            passengers.add(new PassengerData(passenger, offset, seat));
        }
        RocketContraptionEntity newRocket = (RocketContraptionEntity)super.changeDimension(transition);
        if (newRocket == null) {
            return null;
        }
        for (PassengerData data : passengers) {
            Entity newPassenger = data.entity.changeDimension(transition);
            if (newPassenger == null) continue;
            newPassenger.setPos(newRocket.position().add(data.offset));
            if (data.seat == -1) continue;
            this.addSittingPassenger(newPassenger, data.seat);
        }
        if (controllingPlayer != null) {
            CatnipServices.NETWORK.sendToClientsTrackingEntity((Entity)this, (CustomPacketPayload)new RocketControlPacket(this.getId(), controllingPlayer, this.getContraption().localControlsPos));
        }
        return newRocket;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickAirSound(float maxVolume) {
        if (this.level().isClientSide) {
            float pitch = (float)Mth.clamp((double)this.getDeltaMovement().length(), (double)0.2f, (double)3.0);
            if (this.flyingSound == null || this.flyingSound.isStopped()) {
                this.flyingSound = new RocketAirSound(SoundEvents.ELYTRA_FLYING, pitch, this);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)this.flyingSound);
            }
            this.flyingSound.setPitch(pitch);
            this.flyingSound.fadeIn(maxVolume);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleSyncPacket(RocketContraptionSyncPacket packet) {
        Entity entity = Minecraft.getInstance().level.getEntity(packet.contraptionEntityId());
        if (!(entity instanceof RocketContraptionEntity)) {
            return;
        }
        RocketContraptionEntity rce = (RocketContraptionEntity)entity;
        rce.setPos(packet.pos().x, packet.pos().y, packet.pos().z);
        rce.lift_vel = packet.lift_vel();
        rce.launchTime = packet.launchTime();
        rce.launchingMode = packet.launched();
        rce.landingMode = packet.landing();
        rce.blasting = packet.blasting();
        rce.slowing = packet.slowing();
        rce.activeLaunch = packet.activeLaunch();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleQuickSyncPacket(RocketContraptionQuickSyncPacket packet) {
        Entity entity = Minecraft.getInstance().level.getEntity(packet.contraptionEntityId);
        if (!(entity instanceof RocketContraptionEntity)) {
            return;
        }
        RocketContraptionEntity rce = (RocketContraptionEntity)entity;
        rce.slowing = packet.slowing;
    }

    public ItemStack createReturnTicket() {
        ItemStack result = new ItemStack((ItemLike)NorthstarItems.RETURN_TICKET.get());
        result.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.northstar.return_ticket_" + NorthstarPlanets.getPlanetName(this.home))).setStyle(Style.EMPTY.withColor(ChatFormatting.AQUA).withItalic(Boolean.valueOf(false))));
        result.set(NorthstarDataComponents.PLANET, (Object)NorthstarPlanets.getPlanetName(this.home));
        return result;
    }

    public void startLanding() {
        this.launchingMode = false;
        this.landingMode = true;
        this.lift_vel = 0.0f;
    }

    public Component getContraptionName() {
        Contraption contraption = this.contraption;
        if (contraption instanceof RocketContraption) {
            RocketContraption rc = (RocketContraption)contraption;
            return Component.literal((String)rc.name);
        }
        return this.getName();
    }

    public boolean startControlling(BlockPos controlsLocalPos, Player player) {
        return player != null && !player.isSpectator();
    }

    public boolean collidesWithBlocks(Direction dir) {
        if (!(this.contraption instanceof RocketContraption)) {
            return false;
        }
        return RocketContraptionEntity.isCollidingWithWorld(this.level(), this.getContraption(), BlockPos.containing((Position)this.position()).relative(dir), dir);
    }

    public static boolean isCollidingWithWorld(Level world, RocketContraption contraption, BlockPos anchor, Direction movementDirection) {
        for (BlockPos pos : contraption.getOrCreateColliders(world, movementDirection)) {
            BlockPos colliderPos = pos.offset((Vec3i)anchor);
            BlockState collidedState = world.getBlockState(colliderPos);
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos);
            boolean emptyCollider = collidedState.getCollisionShape((BlockGetter)world, pos).isEmpty();
            if (collidedState.getBlock() instanceof CocoaBlock) continue;
            MovementBehaviour movementBehaviour = (MovementBehaviour)MovementBehaviour.REGISTRY.get((StateHolder)blockInfo.state());
            if (movementBehaviour != null) {
                if (movementBehaviour instanceof BlockBreakingMovementBehaviour) {
                    BlockBreakingMovementBehaviour behaviour = (BlockBreakingMovementBehaviour)movementBehaviour;
                    if (behaviour.canBreak(world, colliderPos, collidedState) || emptyCollider) continue;
                    return true;
                }
                if (movementBehaviour instanceof HarvesterMovementBehaviour) {
                    HarvesterMovementBehaviour harvesterMovementBehaviour = (HarvesterMovementBehaviour)movementBehaviour;
                    if (harvesterMovementBehaviour.isValidCrop(world, colliderPos, collidedState) || harvesterMovementBehaviour.isValidOther(world, colliderPos, collidedState) || emptyCollider) continue;
                    return true;
                }
            }
            if (collidedState.canBeReplaced() || emptyCollider) continue;
            return true;
        }
        return false;
    }

    public boolean control(BlockPos controlsLocalPos, Collection<Integer> heldControls, Player player) {
        if (player.isSpectator() || !this.toGlobalVector(VecHelper.getCenterOf((Vec3i)controlsLocalPos), 1.0f).closerThan((Position)player.position(), 8.0) || heldControls.contains(5)) {
            return false;
        }
        boolean spaceDown = heldControls.contains(4);
        if (spaceDown && this.launchingMode && this.launchTime == 0 && !this.blasting) {
            this.startLaunchSequence();
        }
        if (spaceDown && this.landingMode) {
            this.slowing = true;
        }
        return true;
    }

    public void startLaunchSequence() {
        this.launchTime = 200;
        this.activeLaunch = true;
    }

    public void cancelLaunch() {
        this.launchTime = 0;
        this.activeLaunch = false;
    }

    public boolean clientControl(BlockPos controlsLocalPos, Collection<Integer> heldControls, Player player) {
        if (player == null || player.isSpectator() || controlsLocalPos == null || !this.toGlobalVector(VecHelper.getCenterOf((Vec3i)controlsLocalPos), 1.0f).closerThan((Position)player.position(), 8.0) || heldControls.contains(5)) {
            return false;
        }
        boolean spaceDown = heldControls.contains(4);
        if (spaceDown && this.launchingMode && this.launchTime == 0 && !this.blasting) {
            this.startLaunchSequence();
        }
        if (spaceDown && this.landingMode) {
            this.slowing = true;
        }
        return true;
    }

    public boolean isLaunchingOrLanding() {
        return this.blasting || this.landingMode;
    }

    public boolean isActiveLaunch() {
        return this.activeLaunch;
    }

    public int getLaunchTime() {
        return this.launchTime;
    }

    public double getSlowdownHeightThreshold() {
        return this.level().getMaxBuildHeight() + 150;
    }

    public List<Entity> getEntitiesWithinContraption() {
        return this.entitiesWithinContraption;
    }

    public RocketContraption getContraption() {
        return (RocketContraption)this.contraption;
    }

    protected void writeAdditional(CompoundTag compound, HolderLookup.Provider registries, boolean spawnPacket) {
        super.writeAdditional(compound, registries, spawnPacket);
        compound.putBoolean("blasting", this.blasting);
        compound.putBoolean("slowing", this.slowing);
        compound.putBoolean("isUsingTicket", this.isUsingTicket);
        compound.putBoolean("launched", this.launchingMode);
        compound.putBoolean("landing", this.landingMode);
        compound.putBoolean("fuelBurned", this.fuelBurned);
        compound.putBoolean("printed", this.printed);
        compound.putBoolean("activeLaunch", this.activeLaunch);
        compound.putBoolean("isUsingTicket", this.isUsingTicket);
        compound.putString("home", NorthstarPlanets.getPlanetName(this.home));
        compound.putString("destination", NorthstarPlanets.getPlanetName(this.destination));
        if (this.owner != null) {
            compound.putUUID("player", this.owner.getUUID());
        }
        compound.putFloat("lift_vel", this.lift_vel);
        compound.putFloat("final_lift_vel", this.final_lift_vel);
        compound.putBoolean("auto_land", this.auto_land_mode);
    }

    protected void readAdditional(CompoundTag compound, boolean spawnData) {
        super.readAdditional(compound, spawnData);
        this.blasting = compound.contains("blasting") && compound.getBoolean("SequencedOffsetLimit");
        this.slowing = compound.contains("slowing") && compound.getBoolean("slowing");
        this.isUsingTicket = compound.contains("isUsingTicket") && compound.getBoolean("isUsingTicket");
        this.launchingMode = compound.contains("launched") && compound.getBoolean("launched");
        this.landingMode = compound.contains("landing") && compound.getBoolean("landing");
        this.fuelBurned = compound.contains("fuelBurned") && compound.getBoolean("fuelBurned");
        this.printed = compound.contains("printed") && compound.getBoolean("printed");
        this.activeLaunch = compound.contains("activeLaunch") && compound.getBoolean("activeLaunch");
        boolean bl = this.isUsingTicket = compound.contains("isUsingTicket") && compound.getBoolean("isUsingTicket");
        if (compound.contains("home")) {
            this.home = NorthstarPlanets.getPlanetDimension(compound.getString("home"));
        }
        if (compound.contains("destination")) {
            this.destination = NorthstarPlanets.getPlanetDimension(compound.getString("destination"));
        }
        if (compound.contains("player")) {
            this.ownerID = compound.getUUID("player");
        }
        if (compound.contains("lift_vel")) {
            this.lift_vel = compound.getFloat("lift_vel");
        }
        if (compound.contains("final_lift_vel")) {
            this.final_lift_vel = compound.getFloat("final_lift_vel");
        }
        this.auto_land_mode = compound.contains("auto_land") && compound.getBoolean("auto_land");
    }

    public Vec3 applyRotation(Vec3 localPos, float partialTicks) {
        return localPos;
    }

    public Vec3 reverseRotation(Vec3 localPos, float partialTicks) {
        return localPos;
    }

    protected StructureTransform makeStructureTransform() {
        return new StructureTransform(BlockPos.containing((Position)this.getAnchorVec().add(0.5, 0.5, 0.5)), 0.0f, 0.0f, 0.0f);
    }

    protected float getStalledAngle() {
        return 0.0f;
    }

    public void teleportTo(double x, double y, double z) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        super.lerpTo(x, y, z, yRot, xRot, steps);
    }

    protected void handleStallInformation(double x, double y, double z, float angle) {
        this.setPosRaw(x, y, z);
    }

    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        return AbstractContraptionEntity.ContraptionRotationState.NONE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void applyLocalTransforms(PoseStack matrixStack, float partialTicks) {
        TransformStack.of((PoseStack)matrixStack).nudge(this.getId());
    }
}

