/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.data;

import com.lightning.northstar.content.NorthstarRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;

public record FuelType(Set<ResourceLocation> fluids, float rocketMultiplier, int combustionEngineEfficiency, float combustionEngineRpm) {
    public static final Codec<FuelType> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.listOf().fieldOf("fluids").xmap(l -> new HashSet(l), ArrayList::new).forGetter(FuelType::fluids), (App)Codec.FLOAT.fieldOf("rocket_multiplier").forGetter(FuelType::rocketMultiplier), (App)Codec.INT.fieldOf("combustion_engine_use").forGetter(FuelType::combustionEngineEfficiency), (App)Codec.FLOAT.fieldOf("combustion_engine_rpm").forGetter(FuelType::combustionEngineRpm)).apply((Applicative)i, FuelType::new));

    public boolean supports(RegistryAccess registryAccess, Fluid fluid) {
        return this.fluids().contains(registryAccess.registryOrThrow(Registries.FLUID).getKey((Object)fluid));
    }

    public static FuelType getFuelType(RegistryAccess registryAccess, Fluid fluid) {
        ResourceLocation name = registryAccess.registryOrThrow(Registries.FLUID).getKey((Object)fluid);
        return registryAccess.registryOrThrow(NorthstarRegistries.FUEL).stream().filter(fuel -> fuel.fluids().contains(name)).findFirst().orElse(null);
    }
}

