/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MarsCobraEntity
extends Monster
implements GeoAnimatable {
    private static final ResourceLocation SPEED_MODIFIER_ATTACKING_ID = Northstar.asResource("attacking");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_ID, 0.1, AttributeModifier.Operation.ADD_VALUE);
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int attackTick;
    private int lookedAt;

    public MarsCobraEntity(EntityType<? extends MarsCobraEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(1.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.tickCount;
    }

    private PlayState predicate(AnimationState<MarsCobraEntity> event) {
        if (this.attackTick > 0) {
            --this.attackTick;
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().then("bite", Animation.LoopType.PLAY_ONCE));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed((double)event.getLimbSwingAmount()).setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else {
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    protected SoundEvent getAmbientSound() {
        super.getAmbientSound();
        return (SoundEvent)NorthstarSounds.MARS_COBRA_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return (SoundEvent)NorthstarSounds.MARS_COBRA_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)NorthstarSounds.MARS_COBRA_DEATH.get();
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 4) {
            this.attackTick = 40;
        }
        super.handleEntityEvent(pId);
    }

    public static boolean cobraSpawnRules(EntityType<MarsCobraEntity> cobra, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        int surfaceY = level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ());
        BlockState state = level.getBlockState(pos.below());
        if (pos.getY() >= surfaceY) {
            return false;
        }
        if ((double)pos.getY() > (double)surfaceY / 1.5) {
            int light = level.getMaxLocalRawBrightness(pos);
            return light != 0 ? false : MarsCobraEntity.checkMobSpawnRules(cobra, (LevelAccessor)level, (MobSpawnType)spawntype, (BlockPos)pos, (RandomSource)rando) && state.is(NorthstarTags.NorthstarBlockTags.NATURAL_MARS_BLOCKS.tag);
        }
        return false;
    }

    public void tick() {
        super.tick();
    }

    protected void customServerAiStep() {
        AttributeInstance attributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (this.getTarget() != null) {
            if (!attributeinstance.hasModifier(SPEED_MODIFIER_ATTACKING_ID)) {
                attributeinstance.addTransientModifier(SPEED_MODIFIER_ATTACKING);
            }
        } else if (attributeinstance.hasModifier(SPEED_MODIFIER_ATTACKING_ID)) {
            attributeinstance.removeModifier(SPEED_MODIFIER_ATTACKING);
        }
        super.customServerAiStep();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new CobraLookForPlayerGoal(this, this::canTarget));
        this.targetSelector.addGoal(1, (Goal)new CobraAttackWhenStaredAt(this));
        super.registerGoals();
    }

    public boolean doHurtTarget(Entity pEntity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound(SoundEvents.RAVAGER_ATTACK, 1.0f, 1.0f);
        return super.doHurtTarget(pEntity);
    }

    boolean isLookingAtMe(Player pPlayer) {
        ItemStack itemstack = (ItemStack)pPlayer.getInventory().armor.get(3);
        if (itemstack.is(Blocks.CARVED_PUMPKIN.asItem())) {
            return false;
        }
        Vec3 vec3 = pPlayer.getViewVector(1.0f).normalize();
        Vec3 vec31 = new Vec3(this.getX() - pPlayer.getX(), this.getEyeY() - pPlayer.getEyeY(), this.getZ() - pPlayer.getZ());
        double d0 = vec31.length();
        vec31 = vec31.normalize();
        double d1 = vec3.dot(vec31);
        Northstar.LOGGER.debug("{}, comparer: {}", (Object)d1, (Object)(1.0 - 0.35 / (d0 / 8.0)));
        return d1 > 1.0 - 0.35 / (d0 / 8.0) && pPlayer.hasLineOfSight((Entity)this);
    }

    boolean canTarget(LivingEntity target) {
        if (!this.canAttack(target)) {
            return false;
        }
        return target.getType() == EntityType.PLAYER;
    }

    static class CobraLookForPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final MarsCobraEntity cobra;
        @Nullable
        private Player pendingTarget;
        private int aggroTime;
        private int stareTimer;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.forCombat().ignoreLineOfSight();

        public CobraLookForPlayerGoal(MarsCobraEntity coberuh, @Nullable Predicate<LivingEntity> pSelectionPredicate) {
            super((Mob)coberuh, Player.class, 10, false, false, pSelectionPredicate);
            this.cobra = coberuh;
            this.startAggroTargetConditions = TargetingConditions.forCombat().range(this.getFollowDistance()).selector(p_32578_ -> coberuh.isLookingAtMe((Player)p_32578_));
        }

        public boolean canUse() {
            this.pendingTarget = this.cobra.level().getNearestPlayer(this.startAggroTargetConditions, (LivingEntity)this.cobra);
            return this.pendingTarget != null;
        }

        public void start() {
            this.aggroTime = this.adjustedTickDelay(5);
            ++this.cobra.lookedAt;
        }

        public void stop() {
            this.pendingTarget = null;
            super.stop();
        }

        public boolean canContinueToUse() {
            if (this.pendingTarget != null) {
                if (!this.cobra.isLookingAtMe(this.pendingTarget)) {
                    return false;
                }
                this.stareTimer = Mth.clamp((int)(this.stareTimer + 1), (int)0, (int)120);
                Northstar.LOGGER.debug("{}", (Object)this.stareTimer);
                if (this.stareTimer >= 32) {
                    this.cobra.lookAt((Entity)this.pendingTarget, 10.0f, 10.0f);
                    return true;
                }
                return false;
            }
            return this.target != null && this.continueAggroTargetConditions.test((LivingEntity)this.cobra, this.target) ? true : super.canContinueToUse();
        }

        public void tick() {
            if (this.cobra.getTarget() == null) {
                super.setTarget((LivingEntity)null);
            }
            if (this.pendingTarget != null) {
                if (!this.cobra.isLookingAtMe(this.pendingTarget)) {
                    this.stareTimer = Mth.clamp((int)this.stareTimer, (int)0, (int)(this.stareTimer - 1));
                    Northstar.LOGGER.debug("{}", (Object)this.stareTimer);
                }
                if (--this.aggroTime <= 0) {
                    this.target = this.pendingTarget;
                    this.pendingTarget = null;
                    super.start();
                }
            }
            super.tick();
        }
    }

    static class CobraAttackWhenStaredAt
    extends Goal {
        private final MarsCobraEntity cobra;
        @Nullable
        private LivingEntity target;

        public CobraAttackWhenStaredAt(MarsCobraEntity coberuh) {
            this.cobra = coberuh;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            this.target = this.cobra.getTarget();
            if (!(this.target instanceof Player)) {
                return false;
            }
            double d0 = this.target.distanceToSqr((Entity)this.cobra);
            return !(d0 > 256.0) && this.cobra.isLookingAtMe((Player)this.target);
        }

        public void start() {
            this.cobra.getNavigation().stop();
        }

        public void tick() {
            this.cobra.getLookControl().setLookAt(this.target.getX(), this.target.getEyeY(), this.target.getZ());
        }
    }
}

