/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.entity.goals.ChargeAtTargetGoal;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VenusStoneBullEntity
extends Monster
implements GeoAnimatable {
    private static final ResourceLocation SPEED_MODIFIER_ATTACKING_ID = Northstar.asResource("attacking");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_ID, 0.2, AttributeModifier.Operation.ADD_VALUE);
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public boolean charging = false;
    public boolean passedTarget = false;
    public int stopChargeTimer = 0;
    public int chargeTimer = 0;
    public int chargeCooldown = 0;
    public BlockPos targetPos;
    public int ticksSpentCharging = 0;
    public Vec3 moveDirection;

    public VenusStoneBullEntity(EntityType<? extends VenusStoneBullEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(1.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.tickCount;
    }

    private PlayState predicate(AnimationState<VenusStoneBullEntity> event) {
        AnimationController controller = event.getController();
        if (!(event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.charging)) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else if (!(event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || !this.charging || this.passedTarget)) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("charge"));
        } else if ((!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) && this.charging && this.passedTarget) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.venus_stone_bull.stop_charge"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MAX_HEALTH, 60.0).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    public static boolean stoneBullSpawnRules(EntityType<VenusStoneBullEntity> moth, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        BlockState state = level.getBlockState(pos.below());
        return state.is(NorthstarTags.NorthstarBlockTags.NATURAL_VENUS_BLOCKS.tag);
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 4) {
            // empty if block
        }
        if (pId == 63) {
            this.charging = true;
        }
        if (pId == 65) {
            this.charging = false;
        }
        if (pId == 66) {
            this.passedTarget = true;
        }
        if (pId == 67) {
            this.charging = false;
            this.passedTarget = false;
        }
        super.handleEntityEvent(pId);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && this.charging && this.passedTarget && !this.level().getBlockState(this.blockPosition().below()).isAir()) {
            this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, this.getX() + (double)(this.random.nextFloat() * (float)(this.random.nextBoolean() ? -1 : 1)), this.getY(), this.getZ() + (double)(this.random.nextFloat() * (float)(this.random.nextBoolean() ? -1 : 1)), 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, this.getX() + (double)(this.random.nextFloat() * (float)(this.random.nextBoolean() ? -1 : 1)), this.getY(), this.getZ() + (double)(this.random.nextFloat() * (float)(this.random.nextBoolean() ? -1 : 1)), 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, this.getX() + (double)(this.random.nextFloat() * (float)(this.random.nextBoolean() ? -1 : 1)), this.getY(), this.getZ() + (double)(this.random.nextFloat() * (float)(this.random.nextBoolean() ? -1 : 1)), 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, this.getX() + (double)(this.random.nextFloat() * (float)(this.random.nextBoolean() ? -1 : 1)), this.getY(), this.getZ() + (double)(this.random.nextFloat() * (float)(this.random.nextBoolean() ? -1 : 1)), 0.0, 0.0, 0.0);
        }
        if (!this.level().isClientSide && this.getTarget() != null) {
            Northstar.LOGGER.debug("target: {}, charging: {}, chargeTime: {}", new Object[]{this.getTarget(), this.charging, this.chargeTimer});
        }
    }

    protected void customServerAiStep() {
        if (this.chargeTimer > 0) {
            this.chargeTimer = Mth.clamp((int)this.chargeTimer, (int)0, (int)(this.chargeTimer - 1));
        }
        if (this.stopChargeTimer > 0) {
            this.stopChargeTimer = Mth.clamp((int)this.stopChargeTimer, (int)0, (int)(this.stopChargeTimer - 1));
        }
        if (this.chargeCooldown > 0) {
            this.chargeCooldown = Mth.clamp((int)this.chargeCooldown, (int)0, (int)(this.chargeCooldown - 1));
        }
        AttributeInstance attributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (this.getTarget() != null) {
            if (!attributeinstance.hasModifier(SPEED_MODIFIER_ATTACKING_ID)) {
                attributeinstance.addTransientModifier(SPEED_MODIFIER_ATTACKING);
            }
        } else if (attributeinstance.hasModifier(SPEED_MODIFIER_ATTACKING_ID)) {
            attributeinstance.removeModifier(SPEED_MODIFIER_ATTACKING);
        }
        super.customServerAiStep();
    }

    protected SoundEvent getAmbientSound() {
        super.getAmbientSound();
        return (SoundEvent)NorthstarSounds.VENUS_STONE_BULL_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return (SoundEvent)NorthstarSounds.VENUS_STONE_BULL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)NorthstarSounds.VENUS_STONE_BULL_DEATH.get();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new ChargeAtTargetGoal(this, 1.5, 16));
        this.goalSelector.addGoal(9, (Goal)new StareAtTargetGoal(this));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, ZombifiedPiglin.class, true));
        super.registerGoals();
    }

    public boolean doHurtTarget(Entity pEntity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound((SoundEvent)NorthstarSounds.VENUS_STONE_BULL_ATTACK.get(), 1.0f, 1.0f);
        pEntity.setDeltaMovement(pEntity.getDeltaMovement().x + this.getDeltaMovement().x / 4.0, pEntity.getDeltaMovement().y + 1.0, pEntity.getDeltaMovement().z + this.getDeltaMovement().z / 4.0);
        return super.doHurtTarget(pEntity);
    }

    static class StareAtTargetGoal
    extends Goal {
        private final VenusStoneBullEntity starer;

        public StareAtTargetGoal(VenusStoneBullEntity pShooter) {
            this.starer = pShooter;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return true;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            if (this.starer.charging) {
                return;
            }
            if (this.starer.getTarget() == null) {
                Vec3 vec3 = this.starer.getDeltaMovement();
                this.starer.setYRot(-((float)Mth.atan2((double)vec3.x, (double)vec3.z)) * 57.295776f);
                this.starer.yBodyRot = this.starer.getYRot();
            } else {
                LivingEntity livingentity = this.starer.getTarget();
                if (livingentity.distanceToSqr((Entity)this.starer) < 4096.0) {
                    double d1 = livingentity.getX() - this.starer.getX();
                    double d2 = livingentity.getZ() - this.starer.getZ();
                    this.starer.setYRot(-((float)Mth.atan2((double)d1, (double)d2)) * 57.295776f);
                    this.starer.yBodyRot = this.starer.getYRot();
                }
            }
        }
    }
}

