/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin;

import com.lightning.northstar.item.NorthstarEnchantments;
import com.lightning.northstar.particle.SnowflakeParticleData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerFrostEffectMixin
extends LivingEntity {
    protected PlayerFrostEffectMixin(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")})
    private void attack(Entity pTarget, CallbackInfo info) {
        int j = EnchantmentHelper.getEnchantmentLevel((Holder)this.level().holderOrThrow(NorthstarEnchantments.FROSTBITE), (LivingEntity)this);
        if (pTarget instanceof LivingEntity && j > 0) {
            this.frost(pTarget);
        }
    }

    public void frost(Entity pEntityHit) {
        if (this instanceof LocalPlayer) {
            Minecraft.getInstance().particleEngine.createTrackingEmitter(pEntityHit, (ParticleOptions)new SnowflakeParticleData());
        }
    }
}

