/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.util;

import java.util.function.DoubleUnaryOperator;

public enum TemperatureUnit {
    CELSIUS("\u00b0C", d -> d, d -> d),
    FAHRENHEIT("\u00b0F", d -> d * 9.0 / 5.0 + 32.0, d -> (d - 32.0) * 5.0 / 9.0),
    KELVIN("K", d -> d + 273.0, d -> d - 273.0);

    public final String symbol;
    public final DoubleUnaryOperator fromCelsius;
    public final DoubleUnaryOperator toCelsius;

    private TemperatureUnit(String symbol, DoubleUnaryOperator fromCelsius, DoubleUnaryOperator toCelsius) {
        this.symbol = symbol;
        this.fromCelsius = fromCelsius;
        this.toCelsius = toCelsius;
    }

    public float fromCelsius(float celsius) {
        return (float)this.fromCelsius.applyAsDouble(celsius);
    }

    public double fromCelsius(double celsius) {
        return this.fromCelsius.applyAsDouble(celsius);
    }

    public float toCelsius(float celsius) {
        return (float)this.toCelsius.applyAsDouble(celsius);
    }

    public double toCelsius(double celsius) {
        return this.toCelsius.applyAsDouble(celsius);
    }
}

