/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features;

import com.lightning.northstar.world.features.configuration.CraterConfig;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class CraterFeature
extends Feature<CraterConfig> {
    public CraterFeature(Codec<CraterConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<CraterConfig> context) {
        CraterConfig config = (CraterConfig)context.config();
        BlockPos center = context.origin();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        boolean flag = false;
        int j = center.getY() + config.halfHeight().sample(random);
        if (j <= 0) {
            return false;
        }
        int k = center.getY() - config.halfHeight().sample(random) - 1;
        int l = config.radius().sample(random);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int pp = 0;
        int l_old = l;
        while (l > l_old / j && j > 0) {
            if (pp < config.depth().sample(random)) {
                ++pp;
                center = center.below();
            }
            for (BlockPos blockpos1 : BlockPos.betweenClosed((BlockPos)center.offset(-l, 0, -l), (BlockPos)center.offset(l, 0, l))) {
                int j1;
                int i1 = blockpos1.getX() - center.getX();
                if (!((double)(i1 * i1 + (j1 = blockpos1.getZ() - center.getZ()) * j1) <= (double)(l * l) - 0.1)) continue;
                flag |= this.placeColumn(config, level, random, j, k, blockpos$mutableblockpos.set((Vec3i)blockpos1));
                this.placeColumnBelow(config, level, random, j, k, blockpos$mutableblockpos.set((Vec3i)blockpos1.below()));
                this.clearAir(config, level, random, j, k, blockpos$mutableblockpos.set((Vec3i)blockpos1));
            }
            l = (int)((double)l / 1.5);
        }
        return flag;
    }

    protected boolean placeColumn(CraterConfig pConfig, WorldGenLevel pLevel, RandomSource pRandom, int pMaxY, int pMinY, BlockPos.MutableBlockPos pPos) {
        BlockState blockstate = pConfig.airProvider().getState(pRandom, (BlockPos)pPos);
        if (pLevel.getBlockState((BlockPos)pPos).is(pConfig.canDelete())) {
            pLevel.setBlock((BlockPos)pPos, blockstate, 2);
        }
        this.markAboveForPostProcessing(pLevel, (BlockPos)pPos);
        return true;
    }

    protected boolean clearAir(CraterConfig pConfig, WorldGenLevel pLevel, RandomSource pRandom, int pMaxY, int pMinY, BlockPos.MutableBlockPos pPos) {
        boolean flag = false;
        BlockState blockstate = pConfig.airProvider().getState(pRandom, (BlockPos)pPos);
        for (int i = 0; i < 24; ++i) {
            if (pLevel.getBlockState(pPos.atY(pPos.getY() + i)).is(pConfig.canDelete())) {
                pLevel.setBlock(pPos.atY(pPos.getY() + i), blockstate, 2);
            }
            flag = true;
        }
        return flag;
    }

    protected boolean placeColumnBelow(CraterConfig pConfig, WorldGenLevel pLevel, RandomSource pRandom, int pMaxY, int pMinY, BlockPos.MutableBlockPos pPos) {
        BlockState blockstate = pConfig.blockProvider().getState(pRandom, (BlockPos)pPos);
        if (pLevel.getBlockState((BlockPos)pPos) == Blocks.AIR.defaultBlockState()) {
            return false;
        }
        if (pLevel.getBlockState((BlockPos)pPos).is(pConfig.canDelete())) {
            pLevel.setBlock((BlockPos)pPos, blockstate, 2);
        }
        this.markAboveForPostProcessing(pLevel, (BlockPos)pPos);
        return true;
    }
}

