/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features.trunkplacers;

import com.google.common.collect.Lists;
import com.lightning.northstar.world.features.configuration.AlienTreeConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class ArgyreSaplingTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<ArgyreSaplingTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(i -> ArgyreSaplingTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)i).and(i.group((App)IntProvider.POSITIVE_CODEC.fieldOf("extra_branch_steps").forGetter(p -> p.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(p -> Float.valueOf(p.placeBranchPerLogProbability)), (App)IntProvider.NON_NEGATIVE_CODEC.fieldOf("extra_branch_length").forGetter(p -> p.extraBranchLength), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("can_grow_through").forGetter(p -> p.canGrowThrough), (App)IntProvider.NON_NEGATIVE_CODEC.fieldOf("extra_branch_length").forGetter(p -> p.spinFactor))).apply((Applicative)i, ArgyreSaplingTrunkPlacer::new));
    private final IntProvider extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final IntProvider extraBranchLength;
    private final HolderSet<Block> canGrowThrough;
    private final IntProvider spinFactor;

    public ArgyreSaplingTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength, HolderSet<Block> canGrowThrough, IntProvider spinFactor) {
        super(baseHeight, heightRandA, heightRandB);
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
        this.canGrowThrough = canGrowThrough;
        this.spinFactor = spinFactor;
    }

    protected TrunkPlacerType<?> type() {
        return TrunkPlacerType.DARK_OAK_TRUNK_PLACER;
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration treeconfiguration) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int spinX = 0;
        int spinZ = 0;
        int spinZAdd = -1;
        int spinXAdd = 1;
        int branchCount = 0;
        int lastBranch = 0;
        int i = 0;
        while (i < pFreeTreeHeight) {
            if (Math.random() > 0.3) {
                ++i;
                if ((double)pRandom.nextFloat() > 0.9 && branchCount < 3 && lastBranch > 3) {
                    list.addAll(this.placeBranch(pLevel, pBlockSetter, pRandom, pFreeTreeHeight + pRandom.nextIntBetweenInclusive(-pFreeTreeHeight / 4, pFreeTreeHeight / 4), pPos, treeconfiguration, spinX, spinZ));
                    ++branchCount;
                    lastBranch = 0;
                }
            }
            ++lastBranch;
            if (Math.random() > 0.5) {
                spinX += spinXAdd;
            }
            if (Math.random() > 0.5) {
                spinZ += spinZAdd;
            }
            if (Math.random() < 0.5) {
                spinX -= spinXAdd;
            }
            if (Math.random() < 0.5) {
                spinZ -= spinZAdd;
            }
            int Xpos = pPos.getX() + spinX;
            int Zpos = pPos.getZ() + spinZ;
            int j = pPos.getY() + i;
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos, j, Zpos), treeconfiguration);
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos + 1, j, Zpos), treeconfiguration);
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos, j, Zpos + 1), treeconfiguration);
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos - 1, j, Zpos), treeconfiguration);
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos, j, Zpos - 1), treeconfiguration);
            if (i == 1) {
                this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos, j - 1, Zpos), treeconfiguration);
                this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos + 1, j - 1, Zpos), treeconfiguration);
                this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos, j - 1, Zpos + 1), treeconfiguration);
                this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos - 1, j - 1, Zpos), treeconfiguration);
                this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos, j - 1, Zpos - 1), treeconfiguration);
                this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos + 2, j - 1, Zpos), treeconfiguration);
                this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos - 2, j - 1, Zpos), treeconfiguration);
                this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos, j - 1, Zpos + 2), treeconfiguration);
                this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos, j - 1, Zpos - 2), treeconfiguration);
                this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos + 1, j - 1, Zpos + 1), treeconfiguration);
                this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos - 1, j - 1, Zpos - 1), treeconfiguration);
                this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos + 1, j - 1, Zpos - 1), treeconfiguration);
                this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos - 1, j - 1, Zpos + 1), treeconfiguration);
            }
            if (i != pFreeTreeHeight - 1) continue;
            list.add(new FoliagePlacer.FoliageAttachment((BlockPos)blockpos$mutableblockpos.set(Xpos, j + 4, Zpos), 0, false));
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos + 1, j, Zpos), treeconfiguration);
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos - 1, j, Zpos), treeconfiguration);
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos, j, Zpos + 1), treeconfiguration);
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.set(Xpos, j, Zpos - 1), treeconfiguration);
        }
        return list;
    }

    public List<FoliagePlacer.FoliageAttachment> placeBranch(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration treeconfiguration, int oldspinX, int oldspinZ) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos blockpos$mutableblockpos2 = new BlockPos.MutableBlockPos();
        int spinX = 0;
        int spinZ = 0;
        int spinZAdd = -1;
        int spinXAdd = 1;
        int i = 0;
        while (i < pFreeTreeHeight) {
            if (Math.random() > 0.2) {
                ++i;
            }
            if (Math.random() > 0.35) {
                spinX += spinXAdd;
            }
            if (Math.random() > 0.35) {
                spinZ += spinZAdd;
            }
            if (Math.random() < 0.35) {
                spinX -= spinXAdd;
            }
            if (Math.random() < 0.35) {
                spinZ -= spinZAdd;
            }
            int Xpos = pPos.getX() + spinX;
            int Zpos = pPos.getZ() + spinZ;
            int j = pPos.getY() + i;
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.set(Xpos, j, Zpos), treeconfiguration);
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.set(Xpos - 1, j, Zpos), treeconfiguration);
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.set(Xpos, j, Zpos - 1), treeconfiguration);
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.set(Xpos + 1, j, Zpos), treeconfiguration);
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.set(Xpos, j, Zpos + 1), treeconfiguration);
            if (i != pFreeTreeHeight - 1) continue;
            list.add(new FoliagePlacer.FoliageAttachment((BlockPos)blockpos$mutableblockpos2.set(Xpos, j + 4, Zpos), 0, false));
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.set(Xpos + 1, j, Zpos), treeconfiguration);
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.set(Xpos - 1, j, Zpos), treeconfiguration);
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.set(Xpos, j, Zpos + 1), treeconfiguration);
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.set(Xpos, j, Zpos - 1), treeconfiguration);
        }
        return list;
    }

    protected boolean placeLog(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, AlienTreeConfig treeconfiguration) {
        return this.placeLog(pLevel, pBlockSetter, pRandom, pPos, treeconfiguration, Function.identity());
    }

    protected boolean placeLog(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, AlienTreeConfig treeconfiguration, Function<Object, Object> function) {
        if (this.validTreePos(pLevel, pPos)) {
            pBlockSetter.accept(pPos, (BlockState)function.apply(treeconfiguration.trunkProvider().getState(pRandom, pPos)));
            return true;
        }
        return false;
    }

    protected boolean validTreePos(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.isStateAtPosition(pPos, BlockBehaviour.BlockStateBase::canBeReplaced);
    }
}

