/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.sealer;

import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.util.MutableAABB;
import com.lightning.northstar.util.NorthstarLang;
import com.lightning.northstar.world.sealer.SealableBlock;
import com.lightning.northstar.world.sealer.SealerDebugVisualizer;
import com.simibubi.create.foundation.utility.CreateLang;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ProgressiveBlockSealer {
    private final BlockPos.MutableBlockPos tempPos1 = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos tempPos2 = new BlockPos.MutableBlockPos();
    private final Long2LongMap visited = new Long2LongOpenHashMap();
    private final LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
    private final MutableAABB bounds = new MutableAABB();
    private final LongSet sealedBlocks = new LongOpenHashSet();
    private final MutableAABB sealedBounds = new MutableAABB();
    private boolean hasLeak;
    private SealerDebugVisualizer visualizer = SealerDebugVisualizer.NOOP;

    public boolean beginSeal(Level level, BlockPos origin, Direction originDirection) {
        if (originDirection != null) {
            this.tempPos1.setWithOffset((Vec3i)origin, originDirection);
            if (ProgressiveBlockSealer.isFaceOccluded((BlockGetter)level, (BlockPos)this.tempPos1, originDirection.getOpposite(), false)) {
                this.sealedBounds.zero();
                this.sealedBlocks.clear();
                this.visualizer.complete();
                return false;
            }
        } else {
            this.tempPos1.set((Vec3i)origin);
        }
        if (level.isClientSide() && (Boolean)NorthstarConfigs.client().debugSealerBounds.get() != this.visualizer instanceof SealerDebugVisualizer.Client) {
            this.visualizer = (Boolean)NorthstarConfigs.client().debugSealerBounds.get() != false ? new SealerDebugVisualizer.Client() : SealerDebugVisualizer.NOOP;
        }
        this.visited.clear();
        this.queue.clear();
        this.bounds.neg();
        this.visited.put(this.tempPos1.asLong(), 0L);
        this.queue.enqueue(this.tempPos1.asLong());
        this.bounds.union((Vec3i)origin);
        this.bounds.union((Vec3i)this.tempPos1);
        return true;
    }

    public boolean updateSeal(Level level, int maximumSealed) {
        return this.updateSeal(level, maximumSealed, (Integer)NorthstarConfigs.server().sealerMaxBlocksPerTick.get());
    }

    public boolean updateSeal(Level level, int maximumSealed, int maximumChecked) {
        if (this.queue.isEmpty()) {
            return true;
        }
        ProfilerFiller profiler = level.getProfiler();
        profiler.push("northstar:seal_blocks");
        int checked = 0;
        while (!this.queue.isEmpty() && checked++ < maximumChecked && this.visited.size() <= maximumSealed) {
            this.tempPos1.set(this.queue.dequeueLong());
            for (Direction direction : Iterate.directions) {
                long packed;
                this.tempPos2.setWithOffset((Vec3i)this.tempPos1, direction);
                if (this.isAirOccluded((BlockGetter)level, (BlockPos)this.tempPos1, (BlockPos)this.tempPos2, direction) || this.visited.put(packed = this.tempPos2.asLong(), 1L) != 0L) continue;
                this.bounds.union((Vec3i)this.tempPos2);
                this.queue.enqueue(packed);
                this.visualizer.addConnection(this.tempPos1.asLong(), packed);
            }
        }
        if (!this.queue.isEmpty() && this.visited.size() < maximumSealed) {
            profiler.pop();
            return false;
        }
        this.hasLeak = this.visited.size() > maximumSealed;
        this.sealedBlocks.clear();
        if (this.hasLeak) {
            this.sealedBounds.neg();
        } else {
            this.sealedBlocks.addAll((LongCollection)this.visited.keySet());
            this.sealedBounds.set(this.bounds);
        }
        this.visualizer.complete();
        this.queue.clear();
        this.visited.clear();
        this.bounds.neg();
        profiler.pop();
        return true;
    }

    protected boolean isAirOccluded(BlockGetter level, BlockPos from, BlockPos to, Direction direction) {
        return ProgressiveBlockSealer.isFaceOccluded(level, from, direction, true) || ProgressiveBlockSealer.isFaceOccluded(level, to, direction.getOpposite(), false);
    }

    protected static boolean isFaceOccluded(BlockGetter level, BlockPos pos, Direction direction, boolean source) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof SealableBlock) {
            SealableBlock sealable = (SealableBlock)block;
            return sealable.isFaceSealed(level, pos, direction, source);
        }
        if (source && NorthstarTags.NorthstarBlockTags.BLOCKS_AIR.matches(state)) {
            return true;
        }
        return Block.isFaceFull((VoxelShape)state.getShape(level, pos), (Direction)direction) && !NorthstarTags.NorthstarBlockTags.AIR_PASSES_THROUGH.matches(state);
    }

    public void addToGoggleTooltip(List<Component> tooltip, int maximumSealed) {
        if (this.hasLeak()) {
            NorthstarLang.translate("gui.goggles.sealer.area_too_big", new Object[0]).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
        } else {
            NorthstarLang.translate("gui.goggles.sealer.blocks_filled", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            CreateLang.number((double)this.sealedBlocks.size()).style(ChatFormatting.AQUA).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)maximumSealed).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
    }

    public void addCooldownTooltip(List<Component> tooltip, int cooldown, int maximumSealed) {
        if (cooldown > 0) {
            NorthstarLang.translate("gui.goggles.sealer.cooldown", new Object[0]).style(ChatFormatting.GRAY).add(CreateLang.number((double)Math.round((float)cooldown / 20.0f))).forGoggles(tooltip);
        } else {
            NorthstarLang.translate("gui.goggles.sealer.sealing", new Object[0]).style(ChatFormatting.GRAY).add(CreateLang.number((double)(100.0 * (double)this.visited.size() / (double)maximumSealed)).text("%").style(ChatFormatting.AQUA)).forGoggles(tooltip);
        }
    }

    public boolean isSealInProgress() {
        return !this.queue.isEmpty();
    }

    public MutableAABB getSealedBounds() {
        return this.sealedBounds;
    }

    public LongSet getSealedBlocks() {
        return this.sealedBlocks;
    }

    public boolean hasLeak() {
        return this.hasLeak;
    }

    public SealerDebugVisualizer getVisualizer() {
        return this.visualizer;
    }

    public int getSealedBlockCount() {
        return this.sealedBlocks.size();
    }
}

