/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar;

import com.lightning.northstar.NorthstarClient;
import com.lightning.northstar.advancements.NorthstarAdvancements;
import com.lightning.northstar.advancements.NorthstarTriggers;
import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarContraptionTypes;
import com.lightning.northstar.content.NorthstarCreativeModeTab;
import com.lightning.northstar.content.NorthstarEntityTypes;
import com.lightning.northstar.content.NorthstarFluids;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.content.NorthstarMenuTypes;
import com.lightning.northstar.content.NorthstarPackets;
import com.lightning.northstar.content.NorthstarPartialModels;
import com.lightning.northstar.content.NorthstarPotatoProjectileEntityHitActions;
import com.lightning.northstar.content.NorthstarRegistries;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.contraption.FuelType;
import com.lightning.northstar.contraption.rocket.RocketHandler;
import com.lightning.northstar.entity.MarsCobraEntity;
import com.lightning.northstar.entity.MarsMothEntity;
import com.lightning.northstar.entity.MarsToadEntity;
import com.lightning.northstar.entity.MarsWormEntity;
import com.lightning.northstar.entity.MercuryRaptorEntity;
import com.lightning.northstar.entity.MercuryRoachEntity;
import com.lightning.northstar.entity.MercuryTortoiseEntity;
import com.lightning.northstar.entity.MoonEelEntity;
import com.lightning.northstar.entity.MoonLunargradeEntity;
import com.lightning.northstar.entity.MoonSnailEntity;
import com.lightning.northstar.entity.VenusMimicEntity;
import com.lightning.northstar.entity.VenusScorpionEntity;
import com.lightning.northstar.entity.VenusStoneBullEntity;
import com.lightning.northstar.entity.VenusVultureEntity;
import com.lightning.northstar.item.NorthstarEnchantments;
import com.lightning.northstar.item.NorthstarPotions;
import com.lightning.northstar.item.NorthstarRecipeTypes;
import com.lightning.northstar.particle.NorthstarParticles;
import com.lightning.northstar.world.dimension.NorthstarDimensions;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.lightning.northstar.world.features.NorthstarFeatures;
import com.lightning.northstar.world.features.trunkplacers.NorthstarTrunkPlacerTypes;
import com.lightning.northstar.world.oxygen.DefaultOxygenConsumers;
import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.item.TooltipModifier;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DataPackRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import org.slf4j.Logger;
import software.bernie.geckolib.GeckoLib;

@Mod(value="northstar")
public class Northstar {
    public static final double GRAV_CONSTANT = 0.08;
    public static final double EARTH_GRAV = 1.0;
    public static final double MARS_GRAV = 0.37;
    public static final double VENUS_GRAV = 0.89;
    public static final String MOD_ID = "northstar";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"northstar");

    public Northstar(FMLJavaModLoadingContext modContext) {
        IEventBus modEventBus = modContext.getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        REGISTRATE.registerEventListeners(modEventBus);
        GeckoLib.initialize();
        NorthstarTags.register();
        NorthstarCreativeModeTab.register(modEventBus);
        NorthstarItems.register();
        NorthstarBlocks.register();
        NorthstarBlockEntityTypes.register();
        NorthstarPotions.register(modEventBus);
        NorthstarEnchantments.register();
        NorthstarBlocks.register();
        NorthstarFeatures.register(modEventBus);
        NorthstarRecipeTypes.register(modEventBus);
        NorthstarParticles.register(modEventBus);
        NorthstarSounds.register(modEventBus);
        NorthstarMenuTypes.register();
        NorthstarPlanets.register();
        NorthstarDimensions.register();
        NorthstarEntityTypes.register();
        NorthstarFluids.register();
        DefaultOxygenConsumers.register();
        NorthstarPotatoProjectileEntityHitActions.register(modEventBus);
        NorthstarTrunkPlacerTypes.register(modEventBus);
        NorthstarPartialModels.register();
        RocketHandler.register();
        NorthstarConfigs.register((arg_0, arg_1) -> ((FMLJavaModLoadingContext)modContext).registerConfig(arg_0, arg_1));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> NorthstarClient.onCtorClient(modEventBus, forgeEventBus));
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, new FontHelper.Palette(TooltipHelper.styleFromColor((int)8433618), TooltipHelper.styleFromColor((int)5085434))).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }

    @Mod.EventBusSubscriber(modid="northstar", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEventListeners {
        @SubscribeEvent
        public static void onRegistrySync(TagsUpdatedEvent event) {
            FuelType.recacheFuels(event.getRegistryAccess());
        }
    }

    @Mod.EventBusSubscriber(modid="northstar", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEventListeners {
        @SubscribeEvent
        public static void init(FMLCommonSetupEvent event) {
            NorthstarPackets.registerPackets();
            event.enqueueWork(() -> {
                NorthstarAdvancements.register();
                NorthstarTriggers.register();
            });
        }

        @SubscribeEvent
        public static void onRegister(RegisterEvent event) {
            NorthstarContraptionTypes.register();
        }

        @SubscribeEvent
        public static void onNewRegistry(DataPackRegistryEvent.NewRegistry event) {
            event.dataPackRegistry(NorthstarRegistries.FUEL, FuelType.CODEC, FuelType.CODEC);
        }

        @SubscribeEvent
        public static void onLoadConfig(ModConfigEvent.Loading event) {
            NorthstarConfigs.onLoad(event.getConfig());
        }

        @SubscribeEvent
        public static void onReloadConfig(ModConfigEvent.Reloading event) {
            NorthstarConfigs.onReload(event.getConfig());
        }

        @SubscribeEvent
        public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
            event.register((EntityType)NorthstarEntityTypes.MARS_WORM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MarsWormEntity::wormSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
            event.register((EntityType)NorthstarEntityTypes.MARS_TOAD.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MarsToadEntity::toadSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
            event.register((EntityType)NorthstarEntityTypes.MARS_COBRA.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MarsCobraEntity::cobraSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
            event.register((EntityType)NorthstarEntityTypes.MARS_MOTH.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MarsMothEntity::mothSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
            event.register((EntityType)NorthstarEntityTypes.VENUS_MIMIC.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, VenusMimicEntity::mimicSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
            event.register((EntityType)NorthstarEntityTypes.VENUS_SCORPION.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, VenusScorpionEntity::scorpionSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
            event.register((EntityType)NorthstarEntityTypes.VENUS_STONE_BULL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, VenusStoneBullEntity::stoneBullSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
            event.register((EntityType)NorthstarEntityTypes.VENUS_VULTURE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, VenusVultureEntity::vultureSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
            event.register((EntityType)NorthstarEntityTypes.MOON_SNAIL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MoonSnailEntity::snailSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
            event.register((EntityType)NorthstarEntityTypes.MOON_LUNARGRADE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MoonLunargradeEntity::lunargradeSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
            event.register((EntityType)NorthstarEntityTypes.MOON_EEL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MoonEelEntity::eelSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
            event.register((EntityType)NorthstarEntityTypes.MERCURY_RAPTOR.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MercuryRaptorEntity::raptorSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
            event.register((EntityType)NorthstarEntityTypes.MERCURY_ROACH.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MercuryRoachEntity::roachSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
            event.register((EntityType)NorthstarEntityTypes.MERCURY_TORTOISE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MercuryTortoiseEntity::tortoiseSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        }
    }
}

