/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarBlocks;
import com.tterrag.registrate.util.entry.RegistryEntry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.MissingMappingsEvent;

@Mod.EventBusSubscriber(modid="northstar", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class NorthstarContentRemapper {
    private static final Map<ResourceLocation, ResourceLocation> remapped = new HashMap<ResourceLocation, ResourceLocation>();

    public static void remap(String oldValue, RegistryEntry<?> newValue) {
        NorthstarContentRemapper.remap(Northstar.asResource(oldValue), newValue);
    }

    public static void remap(ResourceLocation oldValue, RegistryEntry<?> newValue) {
        remapped.put(oldValue, newValue.getId());
    }

    @SubscribeEvent
    public static void onRemapContent(MissingMappingsEvent event) {
        NorthstarContentRemapper.remapContent(event, Registries.f_256747_, ForgeRegistries.BLOCKS);
        NorthstarContentRemapper.remapContent(event, Registries.f_256922_, ForgeRegistries.BLOCK_ENTITY_TYPES);
        NorthstarContentRemapper.remapContent(event, Registries.f_256913_, ForgeRegistries.ITEMS);
    }

    private static <T> void remapContent(MissingMappingsEvent event, ResourceKey<Registry<T>> registry, IForgeRegistry<T> forgeRegistry) {
        for (MissingMappingsEvent.Mapping mapping : event.getAllMappings(registry)) {
            ResourceLocation remappedId = remapped.get(mapping.getKey());
            if (remappedId == null) continue;
            Northstar.LOGGER.warn("Remapping '{}' to '{}'", (Object)mapping.getKey(), (Object)remappedId);
            mapping.remap(forgeRegistry.getValue(remappedId));
        }
    }

    static {
        NorthstarContentRemapper.remap("iron_sheetmetal", NorthstarBlocks.TITANIUM_SHEETMETAL);
        NorthstarContentRemapper.remap("iron_sheetmetal_slab", NorthstarBlocks.TITANIUM_SHEETMETAL_SLAB);
        NorthstarContentRemapper.remap("iron_sheetmetal_vertical_slab", NorthstarBlocks.TITANIUM_SHEETMETAL_VERTICAL_SLAB);
        NorthstarContentRemapper.remap("iron_plating", NorthstarBlocks.TITANIUM_PLATING);
        NorthstarContentRemapper.remap("iron_plating_slab", NorthstarBlocks.TITANIUM_PLATING_SLAB);
        NorthstarContentRemapper.remap("iron_plating_vertical_slab", NorthstarBlocks.TITANIUM_PLATING_VERTICAL_SLAB);
        NorthstarContentRemapper.remap("iron_plating_stairs", NorthstarBlocks.TITANIUM_PLATING_STAIRS);
        NorthstarContentRemapper.remap("iron_pillar", NorthstarBlocks.TITANIUM_PILLAR);
        NorthstarContentRemapper.remap("iron_grate", NorthstarBlocks.TITANIUM_GRATE);
        NorthstarContentRemapper.remap("iron_space_door", NorthstarBlocks.TITANIUM_SPACE_DOOR);
        NorthstarContentRemapper.remap("oxygen_generator", NorthstarBlocks.OXYGEN_SEALER);
        NorthstarContentRemapper.remap("vent_block", NorthstarBlocks.VENT);
        NorthstarContentRemapper.remap("oxygen_concentrator", NorthstarBlocks.ATMOSPHERIC_CONCENTRATOR);
    }
}

