/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.display;

import com.lightning.northstar.util.TemperatureUnit;
import com.lightning.northstar.world.temperature.NorthstarTemperature;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.SingleLineDisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import java.util.Arrays;
import net.createmod.catnip.lang.LangNumberFormat;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TemperatureDisplaySource
extends SingleLineDisplaySource {
    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        super.initConfigurationWidgets(context, builder, isFirstLine);
        if (isFirstLine) {
            return;
        }
        builder.addSelectionScrollInput(0, 137, (input, label) -> {
            input.forOptions(Arrays.stream(TemperatureUnit.ALL).map(unit -> unit.nameAndSymbol).toList());
            input.titled(Component.m_237115_((String)"northstar.gui.temperature_unit"));
        }, "Unit");
    }

    protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        float temperature = NorthstarTemperature.getTemperatureAt(context.level(), (Vec3i)context.getSourceBlockEntity().m_58899_());
        TemperatureUnit unit = TemperatureUnit.ALL[context.sourceConfig().m_128451_("Unit")];
        return Component.m_237113_((String)LangNumberFormat.format((double)unit.fromCelsius(temperature))).m_130946_(unit.symbol);
    }

    protected boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }
}

