/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.block.simple.MarsSoilBlock;
import com.lightning.northstar.block.simple.MartianTallGrassBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.world.temperature.NorthstarTemperature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.BlockLightEngine;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class MartianGrassBlock
extends Block
implements BonemealableBlock {
    public MartianGrassBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    private static boolean canBeGrass(BlockState pState, LevelReader pLevelReader, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7494_();
        BlockState blockstate = pLevelReader.m_8055_(blockpos);
        if (blockstate.m_60819_().m_76186_() == 8) {
            return false;
        }
        int i = BlockLightEngine.m_284282_((BlockGetter)pLevelReader, (BlockState)pState, (BlockPos)pPos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.m_60739_((BlockGetter)pLevelReader, blockpos));
        return i < pLevelReader.m_7469_() && NorthstarTemperature.getTemperatureAt((Level)pLevelReader, (Vec3i)pPos) > 0.0f;
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos.m_121945_(facing));
        return plantType != PlantType.CROP && plantType != PlantType.WATER;
    }

    private static boolean canPropagate(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7494_();
        return MartianGrassBlock.canBeGrass(pState, pLevel, pPos) && !pLevel.m_6425_(blockpos).m_205070_(FluidTags.f_13131_);
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!MartianGrassBlock.canBeGrass(pState, (LevelReader)pLevel, pPos)) {
            if (!pLevel.isAreaLoaded(pPos, 1)) {
                return;
            }
            if (pRandom.m_188503_(5) == 0) {
                pLevel.m_46597_(pPos, ((MarsSoilBlock)((Object)NorthstarBlocks.MARS_SOIL.get())).m_49966_());
            }
        } else {
            if (!pLevel.isAreaLoaded(pPos, 3)) {
                return;
            }
            if (pLevel.m_46803_(pPos.m_7494_()) >= 9) {
                BlockState blockstate = this.m_49966_();
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pPos.m_7918_(pRandom.m_188503_(3) - 1, pRandom.m_188503_(5) - 3, pRandom.m_188503_(3) - 1);
                    if (!pLevel.m_8055_(blockpos).m_60713_((Block)NorthstarBlocks.MARS_SOIL.get()) || !MartianGrassBlock.canPropagate(blockstate, (LevelReader)pLevel, blockpos)) continue;
                    pLevel.m_46597_(blockpos, blockstate);
                }
            }
        }
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return pLevel.m_8055_(pPos.m_7494_()).m_60795_();
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        BlockState blockstate = ((MartianTallGrassBlock)((Object)NorthstarBlocks.MARTIAN_TALL_GRASS.get())).m_49966_();
        if (pRandom.m_188499_() && level.m_8055_(pPos.m_7494_()).m_60795_()) {
            level.m_7731_(pPos.m_7494_(), blockstate, 2);
        }
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos pos = new BlockPos(pPos.m_123341_() + x, pPos.m_123342_() + y, pPos.m_123343_() + z);
                    BlockState state = level.m_8055_(pos.m_7495_());
                    if (!level.m_8055_(pos).m_60795_() || !pState.m_60713_((Block)NorthstarBlocks.MARTIAN_GRASS.get()) && !state.m_60713_((Block)NorthstarBlocks.MARS_SOIL.get()) || pRandom.m_188503_(2) != 0) continue;
                    level.m_7731_(pos, blockstate, 2);
                }
            }
        }
    }
}

