/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.circuit_engraver;

import com.lightning.northstar.block.tech.circuit_engraver.EngravingRecipe;
import com.lightning.northstar.client.BasicTickableSoundInstance;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.item.NorthstarRecipeTypes;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class CircuitEngraverBlockEntity
extends KineticBlockEntity {
    private static final RecipeWrapper recipeInventory = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
    private boolean disabled;
    private boolean running;
    private EngravingRecipe currentRecipe;
    private int processingTicks;
    private int emptyTicks;
    @OnlyIn(value=Dist.CLIENT)
    private BasicTickableSoundInstance sound;

    public CircuitEngraverBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add((BlockEntityBehaviour)new BeltProcessingBehaviour((SmartBlockEntity)this).whenItemEnters(this::onItemReceived).whileItemHeld(this::onItemHeld));
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82363_(0.0, -1.5, 0.0);
    }

    public BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (this.getSpeed() == 0.0f || this.disabled) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        Optional<EngravingRecipe> recipe = this.getRecipe(transported.stack);
        if (recipe.isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        this.running = true;
        this.currentRecipe = recipe.get();
        this.processingTicks = 0;
        this.emptyTicks = 0;
        this.sendData();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    public BeltProcessingBehaviour.ProcessingResult onItemHeld(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (this.currentRecipe == null || this.disabled || this.getSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        this.emptyTicks = 0;
        if (this.currentRecipe != null && this.processingTicks < this.currentRecipe.getProcessingDuration()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        List<TransportedItemStack> outputs = RecipeApplier.applyRecipeOn((Level)this.f_58857_, (ItemStack)transported.stack.m_255036_(1), (Recipe)this.currentRecipe, (boolean)true).stream().map(stack -> {
            TransportedItemStack copy = transported.copy();
            boolean centered = BeltHelper.isItemUpright((ItemStack)stack);
            copy.stack = stack;
            copy.locked = true;
            copy.angle = centered ? 180 : this.f_58857_.f_46441_.m_188503_(360);
            return copy;
        }).toList();
        TransportedItemStack held = transported.copy();
        held.stack.m_41774_(1);
        if (outputs.isEmpty()) {
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo((TransportedItemStack)held));
        } else {
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(outputs, (TransportedItemStack)held));
        }
        this.processingTicks = 0;
        if (held.stack.m_41619_()) {
            this.currentRecipe = null;
            this.running = false;
            this.sendData();
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.running && this.emptyTicks++ >= 2) {
            this.running = false;
            this.sendData();
        }
        if (this.currentRecipe != null) {
            this.processingTicks += Mth.m_14045_((int)((int)Math.abs(this.getSpeed() / 64.0f)), (int)1, (int)256);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.running) {
            if (this.sound == null || this.sound.m_7801_()) {
                this.sound = new BasicTickableSoundInstance((SoundEvent)NorthstarSounds.LASER_AMBIENT.get(), SoundSource.BLOCKS, SoundInstance.m_235150_(), (BlockEntity)this);
                this.sound.setLooping(true);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.sound);
            }
        } else if (this.sound != null) {
            this.sound.cancel();
            this.sound = null;
        }
    }

    public void updateRedstone() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        boolean powered = this.f_58857_.m_276867_(this.f_58858_);
        if (powered == this.disabled) {
            return;
        }
        this.disabled = powered;
        if (powered) {
            this.running = false;
            this.currentRecipe = null;
            this.processingTicks = 0;
        }
        this.sendData();
    }

    public Optional<EngravingRecipe> getRecipe(ItemStack item) {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)item, NorthstarRecipeTypes.ENGRAVING.getType(), EngravingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        recipeInventory.m_6836_(0, item);
        return NorthstarRecipeTypes.ENGRAVING.find(recipeInventory, this.f_58857_);
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.running = compound.m_128471_("Running");
        this.processingTicks = compound.m_128451_("ProcessingTicks");
        this.disabled = compound.m_128471_("Disabled");
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128379_("Running", this.running);
        compound.m_128405_("ProcessingTicks", this.processingTicks);
        compound.m_128379_("Disabled", this.disabled);
    }
}

