/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.combustion_engine;

import com.lightning.northstar.block.tech.atmospheric_concentrator.AtmosphericConcentratorBlock;
import com.lightning.northstar.client.BasicTickableSoundInstance;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.contraption.FuelType;
import com.lightning.northstar.util.NorthstarLang;
import com.lightning.northstar.world.oxygen.NorthstarOxygen;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CombustionEngineBlockEntity
extends GeneratingKineticBlockEntity
implements IHaveGoggleInformation {
    public ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    public SmartFluidTankBehaviour tank;
    protected float usageBuffer;
    protected float generatorSpeed;
    protected Fluid lastFluid;
    protected FuelType fuelType;
    @OnlyIn(value=Dist.CLIENT)
    protected BasicTickableSoundInstance sound;

    public CombustionEngineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
        ValueBoxTransform.Sided slot = new ValueBoxTransform.Sided(){

            protected boolean isSideActive(BlockState state, Direction direction) {
                return direction == Direction.UP;
            }

            public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
                return VecHelper.voxelSpace((double)8.0, (double)12.0, (double)8.0);
            }

            protected Vec3 getSouthLocation() {
                return Vec3.f_82478_;
            }
        };
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)CreateLang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)slot);
        this.movementDirection.withCallback($ -> {
            this.reActivateSource = true;
        });
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
    }

    public void tick() {
        FuelType fuel;
        super.tick();
        FluidStack fluid = this.tank.getPrimaryHandler().getFluid();
        if (!fluid.getFluid().equals(this.lastFluid)) {
            this.lastFluid = fluid.getFluid();
            this.fuelType = FuelType.getFuelType(this.lastFluid);
            if (this.fuelType != null && (this.fuelType.combustionEngineRpm() == 0.0f || this.fuelType.combustionEngineUse() == 0.0f)) {
                this.fuelType = null;
            }
        }
        if ((fuel = this.fuelType) == null) {
            this.setGeneratorSpeed(0.0f);
            return;
        }
        if (!NorthstarOxygen.hasOxygen(this.f_58857_, (Vec3i)this.f_58858_)) {
            this.setGeneratorSpeed(0.0f);
            return;
        }
        if (this.generatorSpeed > 0.0f && !this.isOverStressed()) {
            this.usageBuffer += fuel.combustionEngineUse();
        }
        int drainable = Math.min(fluid.getAmount(), (int)this.usageBuffer);
        this.tank.getPrimaryHandler().drain(drainable, IFluidHandler.FluidAction.EXECUTE);
        this.usageBuffer -= (float)drainable;
        if (this.usageBuffer > 1.0f) {
            this.setGeneratorSpeed(0.0f);
        } else if (this.generatorSpeed == 0.0f) {
            this.setGeneratorSpeed(fuel.combustionEngineRpm());
        }
    }

    private void setGeneratorSpeed(float generatorSpeed) {
        if (this.generatorSpeed != generatorSpeed) {
            this.generatorSpeed = generatorSpeed;
            this.updateGeneratedRotation();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (!Mth.m_14033_((float)this.generatorSpeed, (float)0.0f) && !this.isOverStressed()) {
            if (this.sound == null || this.sound.m_7801_()) {
                this.sound = new BasicTickableSoundInstance((SoundEvent)NorthstarSounds.COMBUSTION_ENGINE.get(), SoundSource.BLOCKS, SoundInstance.m_235150_(), (BlockEntity)this);
                this.sound.setLooping(true);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.sound);
            }
        } else if (this.sound != null) {
            this.sound.cancel();
            this.sound = null;
        }
    }

    protected boolean isNoisy() {
        return false;
    }

    public float getGeneratedSpeed() {
        return this.generatorSpeed * (float)(this.movementDirection.getValue() == 1 ? 1 : -1);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && (side == null || side == this.m_58900_().m_61143_(AtmosphericConcentratorBlock.HORIZONTAL_FACING))) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        FluidStack fluidStack = this.tank.getPrimaryHandler().getFluidInTank(0);
        if (!fluidStack.getFluid().getFluidType().isAir()) {
            CreateLang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip);
        } else {
            CreateLang.translate((String)"gui.goggles.empty", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        }
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        CreateLang.builder().add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)this.tank.getPrimaryHandler().getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        if (this.fuelType != null) {
            NorthstarLang.translate("gui.goggles.fuel_use", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            CreateLang.number((double)this.fuelType.combustionEngineUse()).style(ChatFormatting.GOLD).add(NorthstarLang.MB_PER_TICK).forGoggles(tooltip, 1);
        }
        return true;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.generatorSpeed = compound.m_128457_("GeneratorSpeed");
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128350_("GeneratorSpeed", this.generatorSpeed);
    }
}

