/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.large_fan;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.tech.large_fan.LargeFanBlock;
import com.lightning.northstar.block.tech.large_fan.LargeFanBlockEntity;
import com.lightning.northstar.block.tech.large_fan.TenPatch;
import com.lightning.northstar.content.NorthstarPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.RenderTypes;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.Arrays;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LargeFanRenderer
extends SafeBlockEntityRenderer<LargeFanBlockEntity> {
    private static final ResourceLocation CHAIN_LOCATION = Northstar.asResource("textures/block/chain.png");
    private static final Vector3f[] CHAIN_STEP = (Vector3f[])Arrays.stream(Direction.values()).map(Direction::m_253071_).map(v -> v.mul(0.375f)).toArray(Vector3f[]::new);
    private final Vector3f offset = new Vector3f();
    private final Vector3f scale = new Vector3f();
    private final Vector3f chainA = new Vector3f();
    private final Vector3f chainB = new Vector3f();
    private final Vector3f side = new Vector3f();

    public LargeFanRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(LargeFanBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = be.m_58900_();
        Direction.Axis axis = (Direction.Axis)state.m_61143_(LargeFanBlock.AXIS);
        Direction dir = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        TenPatch patch = (TenPatch)((Object)state.m_61143_(LargeFanBlock.PATCH));
        PartialModel model = switch (patch.type) {
            default -> throw new IncompatibleClassChangeError();
            case TenPatch.PatchType.SINGLE -> NorthstarPartialModels.LARGE_FAN_SINGLE;
            case TenPatch.PatchType.CENTER -> NorthstarPartialModels.LARGE_FAN_CENTER;
            case TenPatch.PatchType.CORNER -> NorthstarPartialModels.LARGE_FAN_CORNER;
            case TenPatch.PatchType.SIDE -> NorthstarPartialModels.LARGE_FAN_SIDE;
        };
        ((SuperByteBuffer)CachedBuffers.partialFacing((PartialModel)model, (BlockState)state, (Direction)dir).rotateCenteredDegrees((float)patch.rotation, axis)).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110463_()));
        if (!be.isController()) {
            return;
        }
        Vector3f offset = this.offset.set((float)be.getVolumeX(), (float)be.getVolumeY(), (float)be.getVolumeZ()).mul(0.5f);
        float rot = be.angle + be.effectiveSpeed.getValue() / 1200.0f * partialTicks;
        float angle = rot * ((float)Math.PI * 2);
        int blades = be.blades;
        float size = be.width == 1 ? 0.375f : ((float)be.width - 0.5f) * 0.5f;
        Vector3f scale = switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> this.scale.set(0.999f, size, size);
            case Direction.Axis.Y -> this.scale.set(size, 0.999f, size);
            case Direction.Axis.Z -> this.scale.set(size, size, 0.999f);
        };
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.block((BlockState)((BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)axis))).translate((Vector3fc)offset)).scale((Vector3fc)scale)).rotate(axis, angle).uncenter()).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partialFacing((PartialModel)NorthstarPartialModels.LARGE_FAN_ROTOR, (BlockState)state, (Direction)dir).translate((Vector3fc)offset)).scale(size)).rotate(axis, angle).uncenter()).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        if (be.chain != null) {
            this.renderChain(be, be.m_58899_(), be.chain, offset, ms, buffer, light, dir, rot);
        }
        for (int i = 0; i < blades; ++i) {
            float a = angle + (float)Math.PI * 2 * (float)i / (float)blades;
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)NorthstarPartialModels.LARGE_FAN_BLADE, (BlockState)state).translate((Vector3fc)offset)).scale(size)).rotate(axis, a).rotateYDegrees(AngleHelper.horizontalAngle((Direction)dir))).rotateXDegrees(AngleHelper.verticalAngle((Direction)dir))).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110463_()));
        }
    }

    protected void renderChain(LargeFanBlockEntity be, BlockPos pos1, BlockPos pos2, Vector3f center, PoseStack ms, MultiBufferSource buffer, int light, Direction dir, float rot) {
        Vector3f step = CHAIN_STEP[(be.flipChain ? dir.m_122424_() : dir).ordinal()];
        Vector3f chainA = this.chainA.set((Vector3fc)center).add((Vector3fc)step);
        Vector3f chainB = this.chainB.set((float)(pos2.m_123341_() - pos1.m_123341_()) + 0.5f, (float)(pos2.m_123342_() - pos1.m_123342_()) + 0.5f, (float)(pos2.m_123343_() - pos1.m_123343_()) + 0.5f).add((Vector3fc)step);
        float length = chainA.distance((Vector3fc)chainB);
        Vector3f side = chainB.sub((Vector3fc)chainA, this.side).mul(1.0f / length);
        switch (dir.m_122434_()) {
            case X: {
                side.rotateX(1.5707964f);
                break;
            }
            case Y: {
                side.rotateY(1.5707964f);
                break;
            }
            case Z: {
                side.rotateZ(1.5707964f);
            }
        }
        Matrix4f mm = ms.m_85850_().m_252922_();
        Matrix3f mn = ms.m_85850_().m_252943_();
        VertexConsumer vc = buffer.m_6299_(RenderTypes.chain((ResourceLocation)CHAIN_LOCATION));
        float spacing = (float)be.width * 0.5f * 2.0f / 16.0f;
        LargeFanRenderer.renderChain(mm, mn, vc, chainA, chainB, side, spacing - 0.0625f, spacing, 0.125f, 0.0625f, rot * 3.0f, length * 3.0f, dir, light);
        LargeFanRenderer.renderChain(mm, mn, vc, chainA, chainB, side, -spacing + 0.0625f, -spacing, -0.125f, -0.0625f, 1.0f - rot * 3.0f, length * 3.0f, dir.m_122424_(), light);
    }

    private static void renderChain(Matrix4f mm, Matrix3f mn, VertexConsumer vc, Vector3f pos1, Vector3f pos2, Vector3f side, float d1, float d2, float d3, float d4, float offset, float length, Direction direction, int light) {
        LargeFanRenderer.addVertex(mm, mn, vc, pos1.x + side.x * d1, pos1.y + side.y * d1, pos1.z + side.z * d1, 0.0f, offset, direction, light);
        LargeFanRenderer.addVertex(mm, mn, vc, pos1.x + side.x * d2, pos1.y + side.y * d2, pos1.z + side.z * d2, 0.1875f, offset, direction, light);
        LargeFanRenderer.addVertex(mm, mn, vc, pos2.x + side.x * d3, pos2.y + side.y * d3, pos2.z + side.z * d3, 0.1875f, length += offset, direction, light);
        LargeFanRenderer.addVertex(mm, mn, vc, pos2.x + side.x * d4, pos2.y + side.y * d4, pos2.z + side.z * d4, 0.0f, length, direction, light);
        LargeFanRenderer.addVertex(mm, mn, vc, pos1.x + side.x * d1, pos1.y + side.y * d1, pos1.z + side.z * d1, 0.0f, offset, direction, light);
        LargeFanRenderer.addVertex(mm, mn, vc, pos2.x + side.x * d4, pos2.y + side.y * d4, pos2.z + side.z * d4, 0.0f, length, direction, light);
        LargeFanRenderer.addVertex(mm, mn, vc, pos2.x + side.x * d3, pos2.y + side.y * d3, pos2.z + side.z * d3, 0.1875f, length, direction, light);
        LargeFanRenderer.addVertex(mm, mn, vc, pos1.x + side.x * d2, pos1.y + side.y * d2, pos1.z + side.z * d2, 0.1875f, offset, direction, light);
    }

    private static void addVertex(Matrix4f pose, Matrix3f normal, VertexConsumer vc, float x, float y, float z, float u, float v, Direction direction, int light) {
        vc.m_252986_(pose, x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, (float)direction.m_122429_(), (float)direction.m_122430_(), (float)direction.m_122431_()).m_5752_();
    }
}

