/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.rocket_controls;

import com.lightning.northstar.block.tech.rocket_controls.RocketControlsInputPacket;
import com.lightning.northstar.content.NorthstarPackets;
import com.lightning.northstar.contraption.rocket.RocketContraptionEntity;
import com.mojang.blaze3d.platform.InputConstants;
import com.simibubi.create.foundation.utility.ControlsUtil;
import com.simibubi.create.foundation.utility.CreateLang;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public class RocketControlsClientHandler {
    public static Collection<Integer> currentlyPressed = new HashSet<Integer>();
    public static int PACKET_RATE = 5;
    private static int packetCooldown;
    private static int displaytime;
    private static int launchTime;
    private static WeakReference<RocketContraptionEntity> entityRef;
    private static BlockPos controlsPos;

    public static void levelUnloaded(LevelAccessor level) {
        packetCooldown = 0;
        entityRef = new WeakReference<Object>(null);
        controlsPos = null;
        currentlyPressed.clear();
    }

    public static void startControlling(RocketContraptionEntity rce, BlockPos controllerLocalPos) {
        entityRef = new WeakReference<RocketContraptionEntity>(rce);
        controlsPos = controllerLocalPos;
        displaytime = 0;
        if (rce != null && rce.isLaunchingOrLanding()) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)CreateLang.translateDirect((String)"contraption.controls.start_controlling", (Object[])new Object[]{rce.getContraptionName()}), true);
        } else {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"northstar.contraption.controls.rocket_tut").m_130940_(ChatFormatting.AQUA), true);
        }
    }

    public static void stopControlling() {
        ControlsUtil.getControls().forEach(kb -> kb.m_7249_(ControlsUtil.isActuallyPressed((KeyMapping)kb)));
        RocketContraptionEntity contrapEntity = (RocketContraptionEntity)((Object)entityRef.get());
        if (!currentlyPressed.isEmpty() && contrapEntity != null) {
            NorthstarPackets.getChannel().sendToServer((Object)new RocketControlsInputPacket(currentlyPressed, false, contrapEntity.m_19879_(), controlsPos, true));
        }
        packetCooldown = 0;
        entityRef = new WeakReference<Object>(null);
        controlsPos = null;
        currentlyPressed.clear();
        Minecraft.m_91087_().f_91074_.m_5661_((Component)CreateLang.translateDirect((String)"contraption.controls.stop_controlling", (Object[])new Object[0]), true);
    }

    public static void tick() {
        RocketContraptionEntity rce = (RocketContraptionEntity)((Object)entityRef.get());
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (rce == null || player == null) {
            return;
        }
        if (displaytime < 61) {
            ++displaytime;
        }
        if (rce.isActiveLaunch()) {
            if (Math.abs(rce.getLaunchTime() - launchTime) > 10) {
                launchTime = rce.getLaunchTime();
            }
            if (launchTime % 20 == 0 && launchTime != 0) {
                player.m_5661_((Component)Component.m_237113_((String)("T-" + launchTime / 20)).m_130940_(ChatFormatting.AQUA), true);
                player.m_9236_().m_5594_((Player)player, player.m_20183_(), (SoundEvent)SoundEvents.f_12216_.get(), SoundSource.BLOCKS, 10.0f, launchTime / 20 == 0 ? 10.0f : 1.0f);
            }
            --launchTime;
        }
        if (rce.landingMode && rce.m_20186_() < rce.getSlowdownHeightThreshold() && rce.getControllingPlayer().isPresent() && rce.getControllingPlayer().get() == player.m_20148_()) {
            if (rce.auto_land_mode) {
                player.m_5661_((Component)Component.m_237115_((String)"northstar.contraption.controls.landing_notification").m_130940_(ChatFormatting.RED), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"northstar.contraption.controls.landing_warning").m_130940_(ChatFormatting.RED), true);
            }
        }
        if (packetCooldown > 0) {
            --packetCooldown;
        }
        if (rce.m_213877_() || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)256)) {
            BlockPos pos = controlsPos;
            RocketControlsClientHandler.stopControlling();
            NorthstarPackets.getChannel().sendToServer((Object)new RocketControlsInputPacket(currentlyPressed, false, rce.m_19879_(), pos, true));
            return;
        }
        Vector controls = ControlsUtil.getControls();
        HashSet<Integer> pressedKeys = new HashSet<Integer>();
        for (int i = 0; i < controls.size(); ++i) {
            if (!ControlsUtil.isActuallyPressed((KeyMapping)((KeyMapping)controls.get(i)))) continue;
            pressedKeys.add(i);
        }
        rce.clientControl(controlsPos, pressedKeys, (Player)player);
        HashSet<Integer> newKeys = new HashSet<Integer>(pressedKeys);
        Collection<Integer> releasedKeys = currentlyPressed;
        newKeys.removeAll(releasedKeys);
        releasedKeys.removeAll(pressedKeys);
        if (!releasedKeys.isEmpty()) {
            NorthstarPackets.getChannel().sendToServer((Object)new RocketControlsInputPacket(releasedKeys, false, rce.m_19879_(), controlsPos, false));
        }
        if (!newKeys.isEmpty()) {
            NorthstarPackets.getChannel().sendToServer((Object)new RocketControlsInputPacket(newKeys, true, rce.m_19879_(), controlsPos, false));
            packetCooldown = PACKET_RATE;
        }
        if (packetCooldown == 0 && !pressedKeys.isEmpty()) {
            NorthstarPackets.getChannel().sendToServer((Object)new RocketControlsInputPacket(pressedKeys, true, rce.m_19879_(), controlsPos, false));
            packetCooldown = PACKET_RATE;
        }
        if (!currentlyPressed.isEmpty()) {
            if (currentlyPressed.contains(4)) {
                // empty if block
            }
            if (currentlyPressed.contains(5)) {
                launchTime = -20;
                RocketControlsClientHandler.stopControlling();
            }
        }
        currentlyPressed = pressedKeys;
        controls.forEach(kb -> kb.m_7249_(false));
    }

    @Nullable
    public static RocketContraptionEntity getContraption() {
        return (RocketContraptionEntity)((Object)entityRef.get());
    }

    @Nullable
    public static BlockPos getControlsPos() {
        return controlsPos;
    }

    static {
        displaytime = 0;
        launchTime = 0;
        entityRef = new WeakReference<Object>(null);
    }
}

