/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.telescope;

import com.lightning.northstar.block.tech.telescope.TelescopeBlockEntity;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.joml.Vector3f;

public class TelescopeBlock
extends BaseEntityBlock
implements IBE<TelescopeBlockEntity> {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)24.0, (double)12.0);

    public TelescopeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction player_looking = pContext.m_7820_();
        if (player_looking == Direction.UP || player_looking == Direction.DOWN) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_7820_());
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.m_5776_()) {
            BlockEntity entity = pLevel.m_7702_(pPos);
            if (entity instanceof TelescopeBlockEntity && this.canSeeSky(pPos.m_7494_(), pLevel, (Direction)pState.m_61143_((Property)FACING)) && (pLevel.m_46462_() || NorthstarPlanets.canSeeSkyAtDay((ResourceKey<Level>)pLevel.m_46472_())) && (!pLevel.m_46471_() || !NorthstarPlanets.hasWeather((ResourceKey<Level>)pLevel.m_46472_())) && NorthstarPlanets.planetHasSky((ResourceKey<Level>)pLevel.m_46472_())) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)((TelescopeBlockEntity)entity), (BlockPos)pPos);
            } else {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"northstar.gui.telescope_fail"), true);
            }
        }
        return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
    }

    private boolean canSeeSky(BlockPos pos, Level level, Direction dir) {
        boolean flag = false;
        int clearSpots = 0;
        for (int x = 0; x <= 3; ++x) {
            Vector3f vec = dir.m_253071_();
            vec.mul((float)x);
            if (!level.m_45527_(pos.m_7918_(Mth.m_14143_((float)vec.x), Mth.m_14143_((float)vec.y), Mth.m_14143_((float)vec.z))) || ++clearSpots < 2) continue;
            flag = true;
        }
        return flag;
    }

    public Class<TelescopeBlockEntity> getBlockEntityClass() {
        return TelescopeBlockEntity.class;
    }

    public BlockEntityType<? extends TelescopeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NorthstarBlockEntityTypes.TELESCOPE.get();
    }
}

