/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.temperature_regulator;

import com.lightning.northstar.util.MutableAABB;
import com.lightning.northstar.world.sealer.ProgressiveBlockSealer;
import com.lightning.northstar.world.sealer.SealingMode;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BaseTemperatureRegulator {
    protected final MutableAABB bounds = new MutableAABB();
    protected final ProgressiveBlockSealer sealer = new ProgressiveBlockSealer(SealingMode.TEMPERATURE){

        @Override
        protected boolean isAirOccluded(BlockGetter level, BlockPos from, BlockPos to, Direction direction) {
            if (!BaseTemperatureRegulator.this.bounds.contains((Vec3i)to)) {
                return true;
            }
            return super.isAirOccluded(level, from, to, direction);
        }
    };
    protected boolean limit = false;
    protected int sizeX = 2;
    protected int sizeY = 2;
    protected int sizeZ = 2;
    protected float temperature;
    protected boolean showLeak;

    public BaseTemperatureRegulator() {
        this.bounds.inf();
    }

    public void setBounds(Vec3i pos, boolean limit, int sizeX, int sizeY, int sizeZ) {
        this.limit = limit;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        if (limit) {
            this.bounds.setCentered(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), sizeX, sizeY, sizeZ);
        } else {
            this.bounds.inf();
        }
    }

    public void write(CompoundTag compound) {
        compound.m_128350_("temperature", this.temperature);
        compound.m_128379_("limit", this.limit);
        compound.m_128405_("sizeX", this.sizeX);
        compound.m_128405_("sizeY", this.sizeY);
        compound.m_128405_("sizeZ", this.sizeZ);
    }

    public void read(CompoundTag compound, BlockPos pos) {
        this.temperature = compound.m_128457_("temperature");
        this.setBounds((Vec3i)pos, compound.m_128471_("limit"), compound.m_128451_("sizeX"), compound.m_128451_("sizeY"), compound.m_128451_("sizeZ"));
        if (compound.m_128425_("temp", 3)) {
            this.temperature = compound.m_128451_("temp");
        }
    }
}

