/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.compat.kubejs.recipe;

import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.fluid.OutputFluid;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.FluidComponents;
import dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;

public interface ElectrolysisRecipeSchema {
    public static final RecipeKey<InputFluid[]> INGREDIENTS = FluidComponents.INPUT_ARRAY.key("ingredients");
    public static final RecipeKey<OutputFluid[]> RESULTS = FluidComponents.OUTPUT_ARRAY.key("results");
    public static final RecipeConstructor.Factory FACTORY = (recipe, schemaType, keys, from) -> {
        InputFluid[] input = (InputFluid[])from.getValue(recipe, INGREDIENTS);
        if (input.length != 1) {
            throw new RecipeExceptionJS("Electrolysis recipes must have exactly 1 fluid input");
        }
        OutputFluid[] output = (OutputFluid[])from.getValue(recipe, RESULTS);
        if (output.length != 2) {
            throw new RecipeExceptionJS("Electrolysis recipes require 2 fluid results");
        }
        recipe.setValue(INGREDIENTS, (Object)input);
        recipe.setValue(RESULTS, (Object)output);
    };
    public static final RecipeSchema SCHEMA = new RecipeSchema(new RecipeKey[]{RESULTS, INGREDIENTS}).constructor(FACTORY, new RecipeKey[]{RESULTS, INGREDIENTS});
}

