/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.compat.kubejs.recipe;

import com.mojang.datafixers.util.Either;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.fluid.OutputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.FluidComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.TimeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;

public interface FreezingRecipeSchema {
    public static final RecipeKey<Either<InputFluid, InputItem>[]> INGREDIENTS = FluidComponents.INPUT_OR_ITEM_ARRAY.key("ingredients");
    public static final RecipeKey<Either<OutputFluid, OutputItem>[]> OUTPUTS = FluidComponents.OUTPUT_OR_ITEM_ARRAY.key("results");
    public static final RecipeKey<Integer> MIN_TEMPERATURE = NumberComponent.ANY_INT.key("minTemperature").optional((Object)Integer.MIN_VALUE);
    public static final RecipeKey<Integer> MAX_TEMPERATURE = NumberComponent.ANY_INT.key("maxTemperature").optional((Object)Integer.MAX_VALUE);
    public static final RecipeKey<Long> TIME = TimeComponent.TICKS.key("processingTime").optional((Object)100L);
    public static final RecipeSchema SCHEMA = new RecipeSchema(FreezingRecipeJS.class, FreezingRecipeJS::new, new RecipeKey[]{OUTPUTS, INGREDIENTS, MIN_TEMPERATURE, MAX_TEMPERATURE, TIME}).constructor(new RecipeKey[]{OUTPUTS, INGREDIENTS, TIME});

    public static class FreezingRecipeJS
    extends RecipeJS {
        public RecipeJS duration(long ticks) {
            return this.setValue(TIME, ticks);
        }

        public RecipeJS colderThan(int temp) {
            return this.withinTemperature(Integer.MIN_VALUE, temp);
        }

        public RecipeJS hotterThan(int temp) {
            return this.withinTemperature(temp, Integer.MAX_VALUE);
        }

        public RecipeJS withTemperature(int temp) {
            return this.withinTemperature(temp, temp);
        }

        public RecipeJS withinTemperature(int min, int max) {
            return this.setValue(MIN_TEMPERATURE, min).setValue(MAX_TEMPERATURE, (Object)max);
        }
    }
}

