/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.data;

import com.lightning.northstar.data.Mod;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;

public final class Tags<T, R> {
    private final RegistrateTagsProvider<T> provider;
    private final Function<T, ResourceLocation> locationExtractor;
    private final Function<R, T> mapping;

    public Tags(RegistrateTagsProvider<T> provider, Function<T, Holder.Reference<T>> referenceExtractor, Function<R, T> mapping) {
        this.provider = provider;
        this.locationExtractor = referenceExtractor.andThen(Holder.Reference::m_205785_).andThen(ResourceKey::m_135782_);
        this.mapping = mapping;
    }

    public Appender<T, R> tag(TagKey<T> tag) {
        return new Appender(this, tag, this.provider.addTag(tag).getInternalBuilder());
    }

    public Appender<T, R> tag(Tag<T> tag) {
        return this.tag(tag.tag());
    }

    public record Appender<T, R>(Tags<T, R> tags, TagKey<T> key, TagBuilder builder) {
        public Appender<T, R> add(R value) {
            this.builder.m_215900_(this.tags.locationExtractor.apply(this.tags.mapping.apply(value)));
            return this;
        }

        public Appender<T, R> opt(R value) {
            this.builder.m_215905_(this.tags.locationExtractor.apply(this.tags.mapping.apply(value)));
            return this;
        }

        @SafeVarargs
        public final Appender<T, R> add(R ... values) {
            Stream.of(values).map(this.tags.mapping).map(this.tags.locationExtractor).forEach(arg_0 -> ((TagBuilder)this.builder).m_215900_(arg_0));
            return this;
        }

        @SafeVarargs
        public final Appender<T, R> opt(R ... values) {
            Stream.of(values).map(this.tags.mapping).map(this.tags.locationExtractor).forEach(arg_0 -> ((TagBuilder)this.builder).m_215905_(arg_0));
            return this;
        }

        public Appender<T, R> add(TagKey<T> value) {
            this.builder.m_215907_(value.f_203868_());
            return this;
        }

        public Appender<T, R> opt(TagKey<T> value) {
            this.builder.m_215909_(value.f_203868_());
            return this;
        }

        public Appender<T, R> add(Tag<T> value) {
            return this.add(value.tag());
        }

        public Appender<T, R> opt(Tag<T> value) {
            return this.opt(value.tag());
        }

        public Appender<T, R> add(Mod mod, String path) {
            this.builder.m_215900_(mod.loc(path));
            return this;
        }

        public Appender<T, R> opt(Mod mod, String path) {
            this.builder.m_215905_(mod.loc(path));
            return this;
        }
    }

    public static interface Tag<T> {
        public TagKey<T> tag();
    }
}

