/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.block.crops.MartianFlowerBlock;
import com.lightning.northstar.block.crops.MartianTallFlowerBlock;
import com.lightning.northstar.block.simple.MarsRootBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MarsMothEntity
extends Monster
implements GeoAnimatable {
    private static final EntityDataAccessor<Byte> RESTING = SynchedEntityData.m_135353_(MarsMothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> FLYING = SynchedEntityData.m_135353_(MarsMothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final TargetingConditions BAT_RESTING_TARGETING = TargetingConditions.m_148353_().m_26883_(4.0);
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    private BlockPos targetPosition;
    private int pollinationTimer = 0;
    private int timeForPollination = 400;
    private int timeForPathFinding = 400;
    private boolean pollinating = false;
    boolean floorOrCeiling;

    public MarsMothEntity(EntityType<? extends MarsMothEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }

    private PlayState predicate(AnimationState<MarsMothEntity> event) {
        boolean resting = this.isResting();
        if (!resting && this.isFlying()) {
            event.getController().setAnimationSpeed(2.0).setAnimation(RawAnimation.begin().thenLoop("fly"));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed((double)event.getLimbSwingAmount()).setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else if (resting) {
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().thenLoop("sleep"));
        } else {
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RESTING, (Object)0);
        this.f_19804_.m_135372_(FLYING, (Object)1);
    }

    protected SoundEvent m_7515_() {
        if (this.isResting()) {
            return (SoundEvent)NorthstarSounds.MARS_MOTH_SNORE.get();
        }
        if (this.f_19796_.m_188503_(9) == 0) {
            return (SoundEvent)NorthstarSounds.MARS_MOTH_IDLE.get();
        }
        return null;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)NorthstarSounds.MARS_MOTH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)NorthstarSounds.MARS_MOTH_DEATH.get();
    }

    public void m_7822_(byte pId) {
        super.m_7822_(pId);
    }

    public static boolean mothSpawnRules(EntityType<MarsMothEntity> moth, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        int surfaceY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_());
        BlockState state = level.m_8055_(pos.m_7495_());
        if (pos.m_123342_() >= surfaceY) {
            return false;
        }
        if (pos.m_123342_() < surfaceY / 2) {
            int light = level.m_46803_(pos);
            return light != 0 ? false : MarsMothEntity.m_217057_(moth, (LevelAccessor)level, (MobSpawnType)spawntype, (BlockPos)pos, (RandomSource)rando) && state.m_204336_(NorthstarTags.NorthstarBlockTags.NATURAL_MARS_BLOCKS.tag);
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.pollinationTimer > 0) {
            this.pollinationTimer = Mth.m_14045_((int)this.pollinationTimer, (int)0, (int)(this.pollinationTimer - 1));
        }
        if (this.isResting()) {
            this.m_20256_(Vec3.f_82478_);
            this.m_20343_(this.m_20185_(), (double)Mth.m_14107_((double)this.m_20186_()) + 1.0 - (double)this.m_20206_(), this.m_20189_());
        } else if (this.isFlying()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
    }

    protected void usePlayerItem(Player player, InteractionHand hand, ItemStack stack) {
        if (this.isFood(stack)) {
            this.m_5496_(SoundEvents.f_11788_, 1.0f, 1.0f);
            this.targetPosition = this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, this.m_20183_());
            this.setFlying(true);
        }
    }

    public boolean isFood(ItemStack stack) {
        return stack.m_150930_(((MarsRootBlock)((Object)NorthstarBlocks.GLOWING_MARS_ROOTS.get())).m_5456_());
    }

    protected void m_8024_() {
        super.m_8024_();
        BlockPos blockpos = this.m_20183_();
        BlockPos blockpos1 = blockpos.m_7494_();
        if (this.isResting()) {
            boolean flag = this.m_20067_();
            if (this.m_9236_().m_8055_(blockpos1).m_60796_((BlockGetter)this.m_9236_(), blockpos)) {
                if (this.f_19796_.m_188503_(200) == 0) {
                    this.f_20885_ = this.f_19796_.m_188503_(360);
                }
                if (this.m_9236_().m_45946_(BAT_RESTING_TARGETING, (LivingEntity)this) != null) {
                    this.setResting(false);
                    if (!flag) {
                        this.m_9236_().m_5898_(null, 1025, blockpos, 0);
                    }
                }
            } else {
                this.setResting(false);
                if (!flag) {
                    this.m_9236_().m_5898_(null, 1025, blockpos, 0);
                }
            }
        } else if (this.isFlying()) {
            this.f_19789_ = 0.0f;
            if (!(this.targetPosition == null || this.m_9236_().m_46859_(this.targetPosition) && this.targetPosition.m_123342_() > this.m_9236_().m_141937_())) {
                this.targetPosition = null;
            }
            if (this.timeForPathFinding > 0) {
                this.timeForPathFinding = Mth.m_14045_((int)this.timeForPathFinding, (int)0, (int)(this.timeForPathFinding - 1));
            } else {
                this.targetPosition = null;
                this.timeForPathFinding = 400;
            }
            if (this.pollinationTimer <= 0 && this.targetPosition == null) {
                this.targetPosition = this.searchForFlower();
            }
            if (this.targetPosition == null || this.f_19796_.m_188503_(30) == 0 || this.targetPosition.m_203195_((Position)this.m_20182_(), 2.0) && !this.pollinating) {
                this.targetPosition = new BlockPos(this.m_146903_() + this.f_19796_.m_188503_(16) - this.f_19796_.m_188503_(16), this.m_146904_() + this.f_19796_.m_188503_(16) - this.f_19796_.m_188503_(16), this.m_146907_() + this.f_19796_.m_188503_(16) - this.f_19796_.m_188503_(16));
            }
            if (this.timeForPollination > 0) {
                --this.timeForPollination;
            } else {
                this.pollinating = false;
            }
            if (this.pollinating && this.targetPosition.m_203195_((Position)this.m_20182_(), 0.5)) {
                this.pollinating = false;
                this.pollinationTimer = 6000;
                if (this.m_9236_().m_8055_(this.targetPosition).m_60734_() instanceof MartianFlowerBlock) {
                    item = ((MartianFlowerBlock)this.m_9236_().m_8055_(this.targetPosition).m_60734_()).getSeedItem();
                    ItemEntity spawnedItem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)item, 1));
                    this.m_9236_().m_7967_((Entity)spawnedItem);
                } else if (this.m_9236_().m_8055_(this.targetPosition).m_60734_() instanceof MartianTallFlowerBlock) {
                    item = (Item)NorthstarItems.MARS_SPROUT_SEEDS.get();
                    ItemEntity spawnedItem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)item, 1));
                    this.m_9236_().m_7967_((Entity)spawnedItem);
                }
                this.targetPosition = null;
            }
            if (this.targetPosition != null) {
                double tX = (double)this.targetPosition.m_123341_() + 0.5 - this.m_20185_();
                double tY = (double)this.targetPosition.m_123342_() + 0.1 - this.m_20186_();
                double tZ = (double)this.targetPosition.m_123343_() + 0.5 - this.m_20189_();
                Vec3 vec3 = this.m_20184_();
                Vec3 vec31 = vec3.m_82520_((Math.signum(tX) * 0.5 - vec3.f_82479_) * (double)0.1f, (Math.signum(tY) * (double)0.7f - vec3.f_82480_) * (double)0.1f, (Math.signum(tZ) * 0.5 - vec3.f_82481_) * (double)0.1f);
                this.m_20256_(vec31);
                float f = (float)(Mth.m_14136_((double)vec31.f_82481_, (double)vec31.f_82479_) * 57.2957763671875) - 90.0f;
                float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
                this.f_20902_ = 0.5f;
                this.m_146922_(this.m_146908_() + f1);
                if (this.f_19796_.m_188503_(100) == 0 && this.m_9236_().m_8055_(blockpos1).m_60796_((BlockGetter)this.m_9236_(), blockpos1) && !this.pollinating) {
                    this.setResting(true);
                } else if (this.f_19796_.m_188503_(300) == 0 && this.m_9236_().m_8055_(blockpos.m_7495_()).m_60796_((BlockGetter)this.m_9236_(), blockpos.m_7495_()) && !this.pollinating) {
                    this.setFlying(false);
                }
            }
        } else if (this.f_19796_.m_188503_(500) == 0) {
            this.setFlying(true);
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("flying", this.isFlying());
        pCompound.m_128379_("resting", this.isResting());
        pCompound.m_128379_("pollinating", this.pollinating);
        pCompound.m_128405_("pollinationTimer", this.pollinationTimer);
        pCompound.m_128405_("timeForPollination", this.timeForPollination);
        pCompound.m_128405_("timeForPathFinding", this.timeForPathFinding);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("flying")) {
            this.setFlying(pCompound.m_128471_("flying"));
        }
        if (pCompound.m_128441_("resting")) {
            this.setResting(pCompound.m_128471_("resting"));
        }
        if (pCompound.m_128441_("pollinating")) {
            this.pollinating = pCompound.m_128471_("pollinating");
        }
        if (pCompound.m_128441_("pollinationTimer")) {
            this.pollinationTimer = pCompound.m_128451_("pollinationTimer");
        }
        if (pCompound.m_128441_("timeForPollination")) {
            this.timeForPollination = pCompound.m_128451_("timeForPollination");
        }
        if (pCompound.m_128441_("timeForPathFinding")) {
            this.timeForPathFinding = pCompound.m_128451_("timeForPathFinding");
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && this.isResting()) {
            this.setResting(false);
        } else if (!this.m_9236_().f_46443_ && !this.isFlying()) {
            this.setFlying(true);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean isResting() {
        return ((Byte)this.f_19804_.m_135370_(RESTING) & 1) != 0;
    }

    public boolean isFlying() {
        return ((Byte)this.f_19804_.m_135370_(FLYING) & 1) != 0;
    }

    public void setResting(boolean pIsResting) {
        byte b0 = (Byte)this.f_19804_.m_135370_(RESTING);
        if (pIsResting) {
            this.f_19804_.m_135381_(RESTING, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(RESTING, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void setFlying(boolean flying) {
        byte b0 = (Byte)this.f_19804_.m_135370_(RESTING);
        if (flying) {
            this.f_19804_.m_135381_(FLYING, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(FLYING, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        super.m_8099_();
    }

    @Nullable
    private BlockPos searchForFlower() {
        for (int bX = -5; bX < 5; ++bX) {
            for (int bY = -5; bY < 5; ++bY) {
                for (int bZ = -5; bZ < 5; ++bZ) {
                    BlockPos blockpo = this.m_20183_().m_7918_(bX, bY, bZ);
                    BlockState state = this.m_9236_().m_8055_(blockpo);
                    if (state.m_60734_() instanceof MartianFlowerBlock && this.m_9236_().f_46441_.m_188503_(4) == 0) {
                        if ((Integer)state.m_61143_((Property)MartianFlowerBlock.AGE) != 2) continue;
                        this.timeForPollination = 400;
                        this.pollinating = true;
                        return blockpo;
                    }
                    if (!(state.m_60734_() instanceof MartianTallFlowerBlock) || this.m_9236_().f_46441_.m_188503_(4) != 0) continue;
                    this.timeForPollination = 400;
                    this.pollinating = true;
                    return blockpo;
                }
            }
        }
        return null;
    }

    public boolean m_7327_(Entity pEntity) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_(SoundEvents.f_12357_, 1.0f, 1.0f);
        return super.m_7327_(pEntity);
    }
}

